<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:bundle name="commonBundle" class="oracle.sysman.db.rsc.rec.CommonMsg"/>
  <uix:bundle name="catalogBundle" class="oracle.sysman.db.rsc.rec.CatalogMsg"/>
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

    <db:form name="foo" destination="/console/database/rec/vpc" method="post" copyParams="target,type">

      <uix:pageLayout>
        <%@ include file="location.jspf" %>

  <uix:header textBinding="VPC_HDR_ADD_VPC@catalogBundle">
    <uix:contents>
      <%@ include file="msgbox.jspf" %>                           
      <uix:stackLayout>
      <uix:contents>
        
      <uix:tableLayout cellSpacing="10" width="100%" borderWidth="0" summary="tl">
        <uix:rowLayout>
          <uix:styledText textBinding="VPC_INST_SELECT_ROLE@catalogBundle"  styleClass="OraInstructionText" />
        </uix:rowLayout>
        
        <uix:rowLayout>
          <uix:cellFormat hAlign="left" columnSpan="2" headers="">
              <uix:messageRadioButton name="taskRole" value="privUser" 
                                      selectedValueBinding="taskRole@defaultBean@servletRequest" 
                                      textBinding="VPC_OPT_PRIV_USER@catalogBundle" 
                                      tipBinding="VPC_TIP_PRIV_USER@catalogBundle"
                                      styleClass="OraInstructionText" />
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="left" columnSpan="2" headers="">
              <uix:messageRadioButton name="taskRole" value="cataOwner" 
                                      selectedValueBinding="taskRole@defaultBean@servletRequest" 
                                      textBinding="VPC_OPT_CATA_OWNER@catalogBundle" 
                                      tipBinding="VPC_TIP_CATA_OWNER@catalogBundle"
                                      styleClass="OraInstructionText" />
          </uix:cellFormat>
        </uix:rowLayout>
        
        <uix:rowLayout>
          <uix:cellFormat headers="">
              <uix:messageRadioButton name="taskRole" value="vpcUser" 
                                      selectedValueBinding="taskRole@defaultBean@servletRequest" 
                                      textBinding="VPC_OPT_VPC_USER@catalogBundle" 
                                      tipBinding="VPC_TIP_VPC_USER@catalogBundle"
                                      styleClass="OraInstructionText" />
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat headers="">
              <uix:messageRadioButton name="taskRole" value="saveVpc"
                                      selectedValueBinding="taskRole@defaultBean@servletRequest"
                                      textBinding="VPC_OPT_SAVE_USER@catalogBundle"
                                      tipBinding="VPC_TIP_SAVE_USER@catalogBundle"
                                      styleClass="OraInstructionText" />
          </uix:cellFormat>
        </uix:rowLayout>

      </uix:tableLayout>
      
      </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>

  <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@commonBundle" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle" />
          <uix:submitButton textBinding="CONTINUE@commonBundle" name="event" value="continueAdd" shortDescBinding="CONTINUE@commonBundle" />
        </uix:pageButtonBar>
  </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

