<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:bundle name="commonBundle" class="oracle.sysman.db.rsc.rec.CommonMsg"/>
  <uix:bundle name="catalogBundle" class="oracle.sysman.db.rsc.rec.CatalogMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destination="/console/database/rec/vpc" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="2"/>
      <uix:formValue name="pageFunction" valueBinding="pageFunction@defaultBean@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="location.jspf" %>


        <uix:header textBinding="VPC_HDR_ADD_VPC@catalogBundle">
        <uix:contents>

        <%@ include file="msgbox.jspf" %>
                               
          <uix:stackLayout>
            <uix:contents>

        <uix:header textBinding="VPC_SHDR_VPC_USER@catalogBundle">
        <uix:tableLayout width="75%" summary="tl">
          <uix:rowLayout>
                  <uix:styledText textBinding="VPC_INST_SPECIFY_VPC_USER@catalogBundle" styleClass="OraInstructionText" />
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:labeledFieldLayout labelWidth="50%">
                 <uix:messagePrompt promptBinding="VPC_PROM_BASE_CATALOG_DATABASE@catalogBundle" />                  
                 <uix:styledText textBinding="catalogDbName@defaultBean@servletRequest" styleClass="OraDataText"/>
<%--
              <uix:messagePrompt required="yes" labeledNodeId="selectedVpcUser" 
                                 prompt="Virtual Private Catalog Username" />
               <oem:choice name="selectedVpcUser"
                           id="selectedVpcUser"
                           shortDescBinding="ADD_DATABASE_TARGET@catalogBundle@servletRequest"
                           optionsBinding="allVpcUsers@defaultBean@servletRequest"
                           selectedValueBinding="selectedVpcUser@defaultBean@servletRequest">
               </oem:choice>
--%>
                    <uix:messageTextInput name="vpcUsername" id="vpcUsername" 
                                          textBinding="vpcUsername@defaultBean@servletRequest" 
                                          promptBinding="VPC_PROM_VPC_USERNAME@catalogBundle" 
                                          shortDescBinding="VPC_PROM_VPC_USERNAME@catalogBundle"
                                          columns="20" />
                    <uix:messageTextInput name="vpcUserSecretPassword" id="vpcUserSecretPassword" 
                                          textBinding="vpcUserSecretPassword@defaultBean@servletRequest" 
                                          promptBinding="VPC_PROM_VPC_PASSWORD@catalogBundle" 
                                          shortDescBinding="VPC_PROM_VPC_PASSWORD@catalogBundle" 
                                          columns="20" secret="true" noAutoComplete="true"/>

            </uix:labeledFieldLayout>
          </uix:rowLayout>
        </uix:tableLayout>
        </uix:header>

            </uix:contents>
          </uix:stackLayout>

        </uix:contents>
      </uix:header>

      <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@commonBundle" name="event" value="cancel"  shortDescBinding="CANCEL@commonBundle"/>
              <uix:submitButton textBinding="OK@commonBundle" name="event" value="applyCreateVpc" shortDescBinding="OK@commonBundle" />
            </uix:pageButtonBar>
      </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

