<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:bundle name="commonBundle" class="oracle.sysman.db.rsc.rec.CommonMsg"/>
  <uix:bundle name="catalogBundle" class="oracle.sysman.db.rsc.rec.CatalogMsg"/>

  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

    <db:form name="foo"  destination="/console/database/rec/vpc" method="post" copyParams="target,type">
       <uix:formValue name="pageName"
                           value="/database/rec/vpc/vpcgrant"/>

      <uix:pageLayout>
        <%@ include file="location.jspf" %>

  <uix:header textBinding="VPC_HDR_GRANT_PRIV@catalogBundle">
    <uix:contents>
        <%@ include file="msgbox.jspf" %>
                           
      <uix:stackLayout>
        <uix:contents>
          
        <uix:switcher childNameBinding="catalogOwnerLogin@defaultBean@servletRequest">
        <uix:case name="false">
        <uix:stackLayout>
        <%-- VPC User ---------%>
        <uix:header textBinding="VPC_SHDR_VPC_USER@catalogBundle">
          <uix:tableLayout cellSpacing="5" width="80%" borderWidth="0" summary="tl">
            <uix:rowLayout>
                  <uix:styledText textBinding="VPC_INST_SPECIFY_VPC_USER@catalogBundle" styleClass="OraInstructionText" />
            </uix:rowLayout>
              
            <uix:rowLayout>
              <uix:labeledFieldLayout labelWidth="40%">
                     <uix:messageTextInput name="vpcUsername" 
                                           promptBinding="VPC_PROM_VPC_USERNAME@catalogBundle"
                                           textBinding="vpcUsername@defaultBean@servletRequest" 
                                           columns="20"
                                           required="uiOnly"/>

                <uix:messageTextInput name="catalogOwner" id="catalogOwner" 
                                      promptBinding="VPC_PROM_CATALOG_OWNER_USERNAME@catalogBundle" 
                                      textBinding="catalogOwner@defaultBean@servletRequest" 
                                      columns="20"
                                      required="uiOnly"/>
                <uix:messageTextInput name="catalogOwnerSecretPassword" 
                                      id="catalogOwnerSecretPassword" 
                                      promptBinding="VPC_PROM_CATALOG_OWNER_PASSWORD@catalogBundle" 
                                      textBinding="catalogOwnerSecretPassword@defaultBean@servletRequest" 
                                      columns="20" 
                                      secret="true" 
                                      noAutoComplete="true"
                                      required="uiOnly"/>
                </uix:labeledFieldLayout>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:stackLayout>
        </uix:case>
        <%-- end catalog owner credentials --%>  

        <%-- manage privilege --%>
        <uix:case name="true">
        <uix:header textBinding="VPC_SHDR_REGISTER_PRIVILEGE@catalogBundle">
          <uix:tableLayout cellSpacing="10" width="100%" borderWidth="0" summary="tl">
            <uix:rowLayout>
                  <uix:styledText textBinding="VPC_INST_SPECIFY_PRIVILEGE@catalogBundle" styleClass="OraInstructionText" />
            </uix:rowLayout>

                <uix:rowLayout>
                      <uix:styledText textBinding="TEXT_HAS_CATALOG_PRIVS@catalogBundle" styleClass="OraInstructionText" />
                </uix:rowLayout>
              
              <uix:rowLayout>
               <uix:tableLayout cellSpacing="2" width="80%" summary="tl">
                <uix:rowLayout>
                 <uix:table  width="100%"
                           name="addTableData"
                           tableDataBinding="partialTableData@addTableData@servletRequest"
                           summaryBinding="CATALOG_PRIV_TABLE@catalogBundle"
                           shortDescBinding="ATALOG_PRIV_TABLE@catalogBundle"
                           formSubmitted="true"
                           columnFormatsBinding="columnFormats@addTableData@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@addTableData@servletRequest"                                      valueBinding="indexOfFirstVisibleRow@addTableData@servletRequest" 
                           alternateTextBinding = "NO_ITEM_FOUND@catalogBundle"
                           blockSizeBinding="blockSize@addTableData@servletRequest"
                           minValue="1"
			   maxValueBinding="listSize@addTableData@servletRequest"
			   partialRenderMode="self"
                           >
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                   <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/> 
                   </uix:columnHeaderStamp>

                   <uix:contents>                               
                     <uix:styledText textBinding="dbname"/> 
                     <uix:textInput name="dbid"  textBinding="val" readOnlyBinding="readOnly" />
                   </uix:contents>

                  <uix:tableSelection>
                      <uix:multipleSelection textBinding="SELECT_ITEMS_AND@catalogBundle" 
                                             shortDescBinding="SELECT@commonBundle"
                                             selectionBinding="selection@addTableData@servletRequest"
					     selectedBinding="isSelected"
                                             >
                          <%--uix:submitButton textBinding="BUT_DELETE@catalogBundle" name="event" value="deleteRow" shortDesc="image" /--%>
                     </uix:multipleSelection>
                  </uix:tableSelection>
                  
                  <%--uix:footer>
                    <uix:submitButton textBinding="BUT_MORE@catalogBundle" name="event" value="moreRow" shortDesc="image"/>
                  </uix:footer--%>
                </uix:table>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:messageCheckBox name = "registerNewDb" 
                                         textBinding="TEXT_ADD_NEW_DB@catalogBundle" 
                                         tipBinding="VPC_TIP_ADD_NEW_DB@catalogBundle" 
                                         shortDescBinding="VPC_TIP_ADD_NEW_DB@catalogBundle"
                                         labeledNodeId="registerNewDbId"
                                         checkedBinding="registerNewDb@defaultBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:rowLayout>
          </uix:tableLayout>
         </uix:header>
         </uix:case>
         </uix:switcher>
        <%-- end manage privilege --%>
                
        </uix:contents>
      </uix:stackLayout>

    </uix:contents>
  </uix:header>

      <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@commonBundle" name="event" value="cancel"  shortDescBinding="CANCEL@commonBundle"/>
                <uix:switcher childNameBinding="catalogOwnerLogin@defaultBean@servletRequest">
                  <uix:case name="false">
                    <uix:submitButton textBinding="CONTINUE@commonBundle" name="event" value="cataOwnerLogin"  shortDescBinding="CONTINUE@commonBundle" />
                  </uix:case>
                  <uix:case name="true">
                    <uix:submitButton textBinding="OK@commonBundle" name="event" value="applyEdit"  shortDescBinding="OK@commonBundle" />
                  </uix:case>
                </uix:switcher>
            </uix:pageButtonBar>
      </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

