<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:bundle name="commonBundle" class="oracle.sysman.db.rsc.rec.CommonMsg"/>
  <uix:bundle name="catalogBundle" class="oracle.sysman.db.rsc.rec.CatalogMsg"/>
  <uix:bundle name="credsMsgBundle" class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

    <db:form name="foo" destination="/console/database/rec/vpc" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout>
        <%@ include file="location.jspf" %>

  <uix:header textBinding="VPC_HDR_GRANT_ROLE@catalogBundle">
    <uix:contents>
        <%@ include file="msgbox.jspf" %>
                           
      <uix:stackLayout>
        <uix:contents>

      <uix:switcher childNameBinding="catalogUserConnected@defaultBean@servletRequest">
      <uix:case name="false">
      <%-- show login for catalog privileged user --%>
      <uix:header textBinding="VPC_SHDR_CATA_DB_CREDS@catalogBundle">
        <uix:styledText textBinding="VPC_INST_CATA_DB_CREDS@catalogBundle" styleClass="OraInstructionText" />
            <uix:contents>
           <uix:labeledFieldLayout labelWidth="40%">
            <uix:contents>
             <uix:messageTextInput name="targetUserName" 
                                   promptBinding="USERNAME@credsMsgBundle"
                                   textBinding="targetUserName@defaultBean@servletRequest" 
                                   disabledBinding="targetUserNameDisabled@defaultBean@servletRequest"
                                   messageBinding="targetUserNameError@defaultBean@servletRequest" 
                                   messageTypeBinding="targetUserNameErrorType@defaultBean@servletRequest" 
                                   columns="20"
                                   required="uiOnly"
                                   noAutoComplete="true"/>
          
             <uix:messageTextInput name="targetSecretPassword" 
                                   promptBinding="PASSWORD@credsMsgBundle" 
                                   textBinding="targetSecretPassword@defaultBean@servletRequest" 
                                   messageBinding="targetPasswordError@defaultBean@servletRequest" 
                                   messageTypeBinding="targetPasswordErrorType@defaultBean@servletRequest" 
                                   secret="true"           
                                   columns="20"
                                   required="uiOnly"
                                   noAutoComplete="true"/>
          
             <uix:messagePrompt promptBinding="DB_TARGET@credsMsgBundle" />
          
             <%--
	     <uix:styledText styleClass="OraDataText"
                             textBinding="credTarget@defaultBean@servletRequest" />	
	     --%>
	      <uix:styledText styleClass="OraDataText"
                             textBinding="catalogDbName@defaultBean@servletRequest" />		     
          
             <uix:messagePrompt required="uiOnly" labeledNodeId="targetRole"
                                promptBinding="ROLE@credsMsgBundle" />
          
             <uix:choice name="targetRole" id="targetRole">
              <uix:option text="Normal" value="normal"/>
              <uix:option text="SYSDBA" value="sysdba"/>
             </uix:choice>
            </uix:contents>
           </uix:labeledFieldLayout>

            </uix:contents>
      </uix:header>
      </uix:case>
      <%-- end of show login for catalog privileged user --%>
      <uix:case name="true">
      <%-- show select VPC User ---------%>
        <uix:header textBinding="VPC_SHDR_VPC_USER@catalogBundle">
          <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
            <uix:rowLayout>
                  <uix:styledText textBinding="VPC_INST_SPECIFY_VPC_USER@catalogBundle" styleClass="OraInstructionText" />
            </uix:rowLayout>
              
            <uix:rowLayout>
              <uix:labeledFieldLayout labelWidth="40%">
                  <uix:messagePrompt required="yes" labeledNodeId="vpcUsername" 
                                     promptBinding="VPC_PROM_VPC_USERNAME@catalogBundle" />
               
                  <uix:lovInput name="vpcUsername" id="vpcUsername" 
                      textBinding="vpcUsername@defaultBean@servletRequest" columns="20" 
                      shortDescBinding="VPC_PROM_VPC_USERNAME@catalogBundle"
                      destinationBinding="fullDestination@defaultBean@servletRequest" 
                      noAutoComplete="true"/>
              </uix:labeledFieldLayout>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
        
        </uix:case>
        </uix:switcher>
        <%-- end VPC User ---------%>

        </uix:contents>
      </uix:stackLayout>

    </uix:contents>
  </uix:header>

      <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@commonBundle" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle" />
            
              <uix:switcher childNameBinding="catalogUserConnected@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:submitButton textBinding="OK@commonBundle" name="event" value="applyGrantOwner"  shortDescBinding="OK@commonBundle" />
                </uix:case>
                <uix:case name="false">
                  <uix:submitButton textBinding="CONTINUE@commonBundle" name="event" value="continueAddRole"  shortDescBinding="CONTINUE@commonBundle" />
                </uix:case>
                </uix:switcher>
                
            </uix:pageButtonBar>
      </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

