/* $Header: emdb/sysman/webapps/em/database/remoteBrowser/remoteBrowser.js /st_emdbsa_11.2/2 2009/01/27 16:16:47 mmootha Exp $ */

/* Copyright (c) 2004, 2008, Oracle and/or its affiliates. All rights reserved.*/

/*
   DESCRIPTION
    Java Script support for the remote file and directory browser.

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    ngade       08/12/08 - Code slap 10.2.0.5GC -> 112SA
    chanchan    05/08/07 - Support new EM MLAF interface
    ngade       08/06/08 - Code Slap 10.2.0.5GC -> 11.2SA
    dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
                           st_emdbsa_11.1
    chanchan    01/29/08 - Add Search And List function
    npamnani    09/15/05 - support multi-byte target name
    qsong       10/08/04 - add setHostName
    rreilly     07/27/04 - always add em for now 
    rreilly     05/29/04 - add cancel fix and breadcrumbs 
    rreilly     05/20/04 - rreilly_enh_rb3
    rreilly     05/11/04 - add directory and file picker option 
    rreilly     05/10/04 - add init directory settings 
    rreilly     05/09/04 - add host login 
    rreilly     04/21/04 - Creation
 */


/* Make sure to Reset after window launch */
var hostName = null; 
var defaultDir = null; /* 0-ROOT 1-ORACLE_HOME 2-CUSTOM */
var titleID = null;
var titleBundle = null;
var infoID = null;
var infoBundle = null;
var customDir = "/";
var customDirDelimiter = "/";
var bListOnly = false;

/* Don't need reset, always specified */
var destField;

function callBackRemoteBrowser()
{
    return (destField);
}

function setDefaultDirectory(initDir, initDirDelimiter)
{
    customDir = initDir;
    customDirDelimiter = initDirDelimiter;
    defaultDir = 2;
}
function setDefaultDirectoryToRoot()
{
    defaultDir = 0;
}
function setDefaultDirectoryToOracleHome()
{
    defaultDir = 1;
}
function setHostName(host)
{
    hostName = host;
}

function setTitle(msgBundleName, msgID)
{
    titleBundle = msgBundleName;
    titleID = msgID;
}

function setInfo(iBundleName, iID)
{
    infoBundle = iBundleName;
    infoID = iID;
}
function startDirectoryListing()
{
    bListOnly = true;
    startDirectoryBrowser(null);
}
function startBrowser(rbTargetField)
{
    startBrowser(rbTargetField, 2);
}
function startFileBrowser(rbTargetField)
{
    startBrowser(rbTargetField, 1);
}
function startDirectoryBrowser(rbTargetField)
{
    startBrowser(rbTargetField, 0);
}

function startBrowser(rbTargetField, rbTypeBrowser)
{
    sURL = "/em/console/database/remoteBrowser/remoteBrowser?event=rbLaunchWindow";
    sURL += "&target="+queryString('target');
    sURL += "&type="+queryString('type');
    if (hostName != null)
    {
      sURL += "&host="+hostName;
    }
    if (bListOnly)
    	sURL += "&ListOnly=true";
    else
    	sURL += "&rbTargetField="+rbTargetField;
    sURL += "&rbTypeBrowser="+rbTypeBrowser;
    sURL += "&_em.coIFR=true&no_frame=/faces/sdk/nonFacesWrapper";

    if (defaultDir != null)
      sURL += "&rbDefaultDir=" + defaultDir;

    if(titleID != null)
      sURL += "&rbTitleID="+titleID;

    if(titleBundle != null)
      sURL += "&rbTitleBundle="+titleBundle;

    if(infoID != null)
      sURL += "&rbInfoID="+infoID;

    if(infoBundle != null)
      sURL += "&rbInfoBundle="+infoBundle;

    if(defaultDir == 2)
    {
       sURL += "&rbCustomDir=" + encodeURIComponent(customDir) +
              "&rbCustomDirDelimiter=" + customDirDelimiter;
    }

    var userText = bListOnly ? null : document.forms[0][rbTargetField].value;
    if (userText != null)
      sURL += "&rbDirectoryText=" + userText;

    // reset values for next launch
    defaultDir=null;
    titleID=null;
    titleBundle=null;
    infoID=null;
    infoBundle=null;
    hostName=null;
    customDir = "/";
    customDirDelimiter = "/";
    bReadOnly = false;
    
    openWindow(window,
               sURL,
               'lovWindow',
               {width:700, height:600},
               true,
               'dialog',
               callBackRemoteBrowser);
}
 function queryString(key)
 {
     sUrl = location.search.substring(1);
     i   = sUrl.indexOf(key+"=");
     while ( i >= 0 )
     {
          if((i > 0) && (sUrl.substring(i-1, i) != "&"))
          {
              sUrl = sUrl.substring( key.length+i+1 );
              i = sUrl.indexOf(key+"=");
              continue;
          }
          sUrl = sUrl.substring( key.length+i+1 );
          i = sUrl.indexOf("&");
          return(sUrl.substring( 0, (i>=0) ? i : sUrl.length ));
     }
     return("");
 }


