<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        remoteBrowser.jsp
  -- Controller:  RemoteBrowserController.jsp
  -- Description: Remote System File and Directory Browser
  -- 
  -- MODIFIED    (MM/DD/YY)
  --   dchakumk  03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                        st_emdbsa_11.1
  --   chanchan  01/29/08 - Add Search And List function
  --   sresrini  03/21/06 - Fix jsp compilation errors
  --   mpawelko  09/16/05 - bug 4463685 - rework progress page to prevent hang/loop
  --   qsong     07/21/05 - bug 4463685
  --   qsong     06/08/05 - imbed progress page
  --   mnihalan  05/09/05 - Fix ADA bugs 
  --   qsong     03/18/05 - 4249822, UI layout change
  --   sxzhu     02/04/05 - fix bug 4014250: handle windows platform
  --   rreilly   07/27/04 - add search tip 
  --   rreilly   06/01/04 - fix error layout
  --   rreilly   05/29/04 - add cancel fix and breadcrumbs 
  --   rreilly   05/28/04 - fix errors 
  --   rreilly   05/14/04 - ui fixes 
  --   rreilly   05/10/04 - use NLS msgs 
  --   rreilly   05/09/04 - add host login 
  --   rreilly   05/05/04 - use const 
  --   rreilly   04/24/04 - implement details view 
  --   rreilly   04/20/04 - created
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.remoteBrowser.RemoteBrowserConst" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/cabo/jsLibs/TableProxy.js"/>

<script language="JavaScript">
var tableName = "<%= RemoteBrowserConst.DETAILS_TABLE %>";
var nameCol = "<%= RemoteBrowserConst.NAME_COL %>";
function returnSelect()
{
  var target = document.forms[0].<%= RemoteBrowserConst.PARAM_TARGET_FIELD %>.value;
  var lenName = tableName + ":length";

  // set selected value to target field
  if ((document.forms[0][lenName] != null) && (target != null) && (target.length > 0))
  {
    var proxy = new TableProxy(tableName);
    var tableLen = document.forms[0][lenName].value;
    var selectedIndex = proxy.getSelectedRow();
    var selectedItem = tableName 
                       + ":" + "<%=RemoteBrowserConst.NAME_COL_SELECT %>" 
                       + ":" + selectedIndex;
    var radioButtonName = tableName + ":selected";
    var radios = eval(document.forms[0][radioButtonName]);
    if (( tableLen == 1 && !radios.disabled) // one item in table
         || (tableLen > 1 && !radios[selectedIndex].disabled))
    {
      var itemName = document.forms[0][selectedItem].value;
      var fullDir =  "";

      if (itemName == '.')
        fullDir = document.forms[0].<%= RemoteBrowserConst.CURRENT_DIRECTORY %>.value;
      else if (itemName == '..')
        fullDir = document.forms[0].<%= RemoteBrowserConst.PARENT_DIRECTORY %>.value;
      else
      {
        var selectedType = tableName 
                           + ":" + "<%= RemoteBrowserConst.INT_ITEM_TYPE %>" 
                           + ":" + selectedIndex;
        var dirType = document.forms[0][selectedType].value;
        var dirDelim = document.forms[0].<%= RemoteBrowserConst.DIRECTORY_DELIMITER %>.value;     
        fullDir = document.forms[0].<%= RemoteBrowserConst.CURRENT_DIRECTORY %>.value + itemName;
        if (dirType == <%= RemoteBrowserConst.DIRECTORY %>)
          fullDir = fullDir + dirDelim;
      }
      top.opener.document.forms[0][target].value = fullDir;
    }
  }

  // close
  top.close();
}
function gotoSubDirectory(dirName)
{
  document.forms[0].<%= RemoteBrowserConst.SUB_DIRECTORY %>.value = dirName;
  submitForm('<%= RemoteBrowserConst.PAGE_FORM_RB %>', true, 
             {event:'<%= RemoteBrowserConst.GOTO_SUB_DIRECTORY %>'});
}
function gotoDirectory(dirName)
{
  document.forms[0].<%= RemoteBrowserConst.DIRECTORY_TEXT %>.value = dirName;
  submitForm('<%= RemoteBrowserConst.PAGE_FORM_RB %>', true, 
             {event:'<%= RemoteBrowserConst.GOTO_BREADCRUMB_DIRECTORY %>'});
}
</script>


<uix:renderingContext id="renderingContext">

  <uix:bundle name="rbMsgs" class="oracle.sysman.db.rsc.remoteBrowser.RemoteBrowserMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="RBMsgs" class="oracle.sysman.db.rsc.remoteBrowser.RemoteBrowserMsg"/>
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

  <uix:metaContainer>
    <uix:head titleBinding="<%= RemoteBrowserConst.HEADER %>" />
  </uix:metaContainer>

  <uix:body>
  <uix:dataScope currentDataBinding="remoteBrowserBean@servletRequest">

    <db:form name="remoteBrowser" 
             method="post"
             destinationBinding="<%= RemoteBrowserConst.DESTINATION %>"
             copyParams="target,type,pageName,cancelURL,oname,otype" >
    <uix:pageLayout titleBinding="<%= RemoteBrowserConst.HEADER %>" >

      <%-- Hidden Form Values --%>
      <uix:formValue name="pageName" value="<%= RemoteBrowserConst.PAGE_RB %>" />
      <uix:formValue name="event" value="<%= RemoteBrowserConst.SELECT %>"/>
      <uix:formValue name="<%= RemoteBrowserConst.CURRENT_DIRECTORY %>" 
                     valueBinding="<%= RemoteBrowserConst.CURRENT_DIRECTORY %>"/>
      <uix:formValue name="<%= RemoteBrowserConst.PARENT_DIRECTORY %>" 
                     valueBinding="<%= RemoteBrowserConst.PARENT_DIRECTORY %>"/>
      <uix:formValue name="<%= RemoteBrowserConst.PARAM_TARGET_FIELD %>" 
                     valueBinding="<%= RemoteBrowserConst.PARAM_TARGET_FIELD %>"/>
      <uix:formValue name="<%= RemoteBrowserConst.SUB_DIRECTORY %>" />
      <uix:formValue name="<%= RemoteBrowserConst.DIRECTORY_DELIMITER %>" 
                     valueBinding="<%= RemoteBrowserConst.DIRECTORY_DELIMITER %>"/>

      <%-- Remote File and Directory Browser Contents: START --%>

      <%-- ====================================== --%>
      <%-- Page Status: Info Text                 --%>
      <%-- ====================================== --%>
      <uix:pageStatus>
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="<%= RemoteBrowserConst.INFO_MESSAGE %>" />
      </uix:pageStatus>


      <%-- ====================================== --%>
      <%-- Error and Info Display                 --%>
      <%-- ====================================== --%>

      <uix:messages>
        <oem:messageBox messageTypeBinding="rbMessageType@servletRequest" 
                    errorTableBinding="rbErrors@servletRequest"
                    titleTextKey="rbTitleText" mainTextKey="rbMainText"/>
      </uix:messages>

      <%-- ====================================== --%>
      <%-- Host Connection UI                     --%>
      <%-- ====================================== --%>

      <uix:labeledFieldLayout width="75%">

        <%-- Host Name --%>
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="HOST@rbMsgs" />
        <uix:styledText styleClass="OraDataText"
                        textBinding="<%= RemoteBrowserConst.HOST_NAME %>" />

        <%-- Host Username --%>
        <uix:messagePrompt promptBinding="HOST_USER@rbMsgs" />
        <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText styleClass="OraDataText" 
                          textBinding="<%= RemoteBrowserConst.HOST_USER %>" />
          <uix:spacer width="5" />
          <uix:submitButton textBinding="CHANGE@rbMsgs" 
                          name="event" 
                          value="<%= RemoteBrowserConst.CHANGE_CONNECTION %>" />
        </uix:rowLayout>
        </uix:tableLayout>
      
        <%-- Current Directory Breadcrumbs --%>
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="CURRENT_DIRECTORY@rbMsgs" />
        <uix:breadCrumbs>
          <uix:contents childDataBinding="<%= RemoteBrowserConst.CURRENT_DIR_LINKS %>">
            <uix:link textBinding="text"
                      onClickBinding="destination" /> 
          </uix:contents>
        </uix:breadCrumbs>

      </uix:labeledFieldLayout>


      <uix:header textBinding="SEARCH@dbMsgs">
      <%-- ====================================== --%>
      <%-- File and Directory UI                  --%>
      <%-- ====================================== --%>

      <uix:rowLayout>
        <uix:cellFormat width="200" hAlign="right" wrappingDisabled="true">
          <uix:messagePrompt promptBinding="SET_DIRECTORY@rbMsgs" 
                             labeledNodeId="<%= RemoteBrowserConst.DIRECTORY_TEXT %>"/>
        </uix:cellFormat> 
        <uix:spacer width="5"/> 
        <uix:cellFormat> 
          <uix:textInput name="<%= RemoteBrowserConst.DIRECTORY_TEXT %>" 
			 id="<%= RemoteBrowserConst.DIRECTORY_TEXT %>"
                         columns="60"
                         shortDescBinding="SET_DIRECTORY@rbMsgs"
                         textBinding="<%= RemoteBrowserConst.DIRECTORY_TEXT %>"/>
        </uix:cellFormat> 
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:cellFormat width="205"/> 
        <uix:messageText messageBinding="(SET_DIRECTORY@rbMsgs)@rbErrors@servletRequest"
                         messageTypeBinding="(SET_DIRECTORY@rbMsgs)@rbMessageTypes@servletRequest"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:cellFormat width="205"/> 
        <uix:styledText styleClass="OraTipText" textBinding="DIRECTORY_TIP@rbMsgs"/>
      </uix:rowLayout>

      <uix:spacer height="5"/> 


      <uix:rowLayout>
        <uix:cellFormat width="200" hAlign="right" wrappingDisabled="true">
          <uix:messagePrompt promptBinding="SEARCH@rbMsgs" 
                             labeledNodeId="<%= RemoteBrowserConst.SEARCH_TEXT%>"/>
        </uix:cellFormat> 
        <uix:spacer width="5"/> 
        <uix:cellFormat> 
          <%-- Search Text --%>
          <uix:textInput id="<%= RemoteBrowserConst.SEARCH_TEXT %>"
                         name="<%= RemoteBrowserConst.SEARCH_TEXT %>" 
                         shortDesc="SEARCH@rbMsgs"
                         textBinding="<%= RemoteBrowserConst.SEARCH_TEXT %>"/>
        </uix:cellFormat> 
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:cellFormat width="205"/> 
        <uix:messageText messageBinding="(SEARCH@rbMsgs)@rbErrors@servletRequest"
                         messageTypeBinding="(SEARCH@rbMsgs)@rbMessageTypes@servletRequest"/>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:cellFormat width="205"/> 
        <uix:styledText styleClass="OraTipText" textBinding="SEARCH_TIP@rbMsgs"/>
      </uix:rowLayout>

      <uix:spacer height="5"/> 
      <uix:rowLayout>
      <uix:cellFormat width="205"/>
        <%-- Go Button --%>
        <uix:submitButton textBinding="GO@rbMsgs" 
                          name="event" 
                          value="<%= RemoteBrowserConst.GOTO_DIRECTORY %>"/>
      </uix:rowLayout>



      <uix:separator />
      <%-- Details Table --%>
      <uix:table id="<%= RemoteBrowserConst.DETAILS_TABLE %>"
               alternateTextBinding="<%= RemoteBrowserConst.NO_DATA_AVAILABLE_MSG %>"
               formSubmitted="true"
               width="100%"
               tableDataBinding="<%= RemoteBrowserConst.ROW_DATA %>"
               minValue="1"
               valueBinding="<%= RemoteBrowserConst.START_INDEX %>"
               maxValueBinding="<%= RemoteBrowserConst.MAX_VALUE %>"
               blockSizeBinding="<%= RemoteBrowserConst.BLOCK_SIZE %>"
               summaryBinding="DIRECTORY_CONTENTS@rbMsgs" 
               showAll="yes">
        <uix:tableFormat tableBanding="rowBanding"/>
        <uix:tableSelection>

          <uix:singleSelection selectedIndexBinding="<%= RemoteBrowserConst.SELECTED_INDEX %>"
                              shortDescBinding="SELECT@rbMsgs"
                              renderedBinding="<%= RemoteBrowserConst.PARAM_RETURN_SELECT %>"
                              disabledBinding="<%= RemoteBrowserConst.SELECT_DISABLED %>">
          </uix:singleSelection>

        </uix:tableSelection>

        <%-- Name --%>
        <uix:column>
          <uix:columnHeader>
            <uix:sortableHeader textBinding="NAME@rbMsgs" 
                                shortDescBinding="NAME@rbMsgs"
                                sortableBinding="<%= RemoteBrowserConst.NAME_SORT %>"/>
          </uix:columnHeader>
          <uix:styledText textBinding="<%= RemoteBrowserConst.NAME_COL %>"
                          renderedBinding="<%= RemoteBrowserConst.IS_TYPE_FILE %>"/>
          <uix:link textBinding="<%=RemoteBrowserConst.NAME_COL %>"
                    onClickBinding="<%=RemoteBrowserConst.NAME_COL_LINK %>"
                    renderedBinding="<%= RemoteBrowserConst.IS_TYPE_DIRECTORY %>" />
          <uix:formValue name="<%= RemoteBrowserConst.NAME_COL_SELECT %>"
                    valueBinding="<%= RemoteBrowserConst.NAME_COL %>"/>
        </uix:column>    

        <%-- Type --%>
        <uix:column>
          <uix:columnHeader>
            <uix:sortableHeader textBinding="TYPE@rbMsgs" 
                                shortDescBinding="TYPE@rbMsgs"
                                sortableBinding="<%= RemoteBrowserConst.TYPE_SORT %>"/>
          </uix:columnHeader>
          <uix:styledText textBinding="<%= RemoteBrowserConst.TYPE_COL %>"/>
          <uix:formValue name="<%= RemoteBrowserConst.INT_ITEM_TYPE %>"
                    valueBinding="<%= RemoteBrowserConst.INT_ITEM_TYPE %>" />
        </uix:column>    

        <%-- Owner --%>
        <uix:column renderedBinding="<%=RemoteBrowserConst.OWNER_SHOW %>">
          <uix:columnHeader>
            <uix:sortableHeader textBinding="OWNER@rbMsgs" 
                                shortDescBinding="OWNER@rbMsgs"
                                sortableBinding="<%= RemoteBrowserConst.OWNER_SORT %>"/>
          </uix:columnHeader>
          <uix:styledText textBinding="<%= RemoteBrowserConst.OWNER_COL %>"/>
        </uix:column>    

        <%-- Group --%>
        <uix:column renderedBinding="<%=RemoteBrowserConst.GROUP_SHOW %>">
          <uix:columnHeader>
            <uix:sortableHeader textBinding="GROUP@rbMsgs" 
                                shortDescBinding="GROUP@rbMsgs"
                                sortableBinding="<%= RemoteBrowserConst.GROUP_SORT %>"/>
          </uix:columnHeader>
          <uix:styledText textBinding="<%= RemoteBrowserConst.GROUP_COL %>"/>
        </uix:column>    

        <%-- Size --%>
        <uix:column>
          <uix:columnHeader>
            <uix:sortableHeader textBinding="SIZE@rbMsgs" 
                                shortDescBinding="SIZE@rbMsgs"
                                sortableBinding="<%= RemoteBrowserConst.SIZE_SORT %>"/>
          </uix:columnHeader>
          <uix:styledText textBinding="<%= RemoteBrowserConst.SIZE_COL %>"/>
        </uix:column>    

        <%-- Last Modified --%>
        <uix:column>
          <uix:columnHeader>
            <uix:sortableHeader textBinding="LAST_MODIFIED@rbMsgs" 
                                shortDescBinding="LAST_MODIFIED@rbMsgs"
                                sortableBinding="<%= RemoteBrowserConst.MODIFIED_SORT %>"/>
          </uix:columnHeader>
          <uix:styledText textBinding="<%= RemoteBrowserConst.MODIFIED_COL %>"/>
        </uix:column>    

      </uix:table>
  
      </uix:header>

      <%-- Page Buttons --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:button textBinding="CLOSE@rbMsgs" 
                      onClick="top.close()"
		      renderedBinding="<%= RemoteBrowserConst.PARAM_LIST_ONLY %>"
                      shortDescBinding="CLOSE@rbMsgs" />
          <uix:button textBinding="CANCEL@rbMsgs" 
                      onClick="top.close()"
		      renderedBinding="<%= RemoteBrowserConst.PARAM_RETURN_SELECT %>"
                      shortDescBinding="CANCEL@rbMsgs" />
          <uix:button textBinding="SELECT@rbMsgs" 
                      onClick="returnSelect()" 
		      renderedBinding="<%= RemoteBrowserConst.PARAM_RETURN_SELECT %>"
                      shortDescBinding="SELECT@rbMsgs" />

       </uix:pageButtonBar>
      </uix:pageButtons>


      <%-- Remote File and Directory Browser Contents: END --%>




     </uix:pageLayout>
     </db:form>

   </uix:dataScope>
   </uix:body>
  </uix:document>
</uix:renderingContext>
