<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        remoteBrowserCred.jsp
  -- Controller:  RemoteBrowserController.jsp
  -- Description: Remote System File and Directory Browser
  --              Host Credentials Page
  -- 
  -- MODIFIED    (MM/DD/YY)
  --   chanchan  07/12/06 - Fix bug #5349732: using post instead of get method 
  --   rreilly   05/29/04 - add cancel fix and breadcrumbs 
  --   rreilly   05/28/04 - fix errors 
  --   rreilly   05/20/04 - rreilly_enh_rb3
  --   rreilly   04/20/04 - created
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.remoteBrowser.RemoteBrowserConst" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ include file="/oemNoscript.jspf" %>

<script language="JavaScript">
function cancelSetCredentials()
{
  var change = document.forms[0].<%= RemoteBrowserConst.PARAM_CANCEL_CHANGE_CONNECTION %>.value;
  if (change == 1)
  { 
    submitForm('<%= RemoteBrowserConst.PAGE_FORM_RB %>', true, 
                {event:'<%= RemoteBrowserConst.CANCEL_CHANGE_CONNECTION %>'});
  }
  else 
  {
    // close
    self.close();
  }
}
</script>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="rbMsgs" 
              class="oracle.sysman.db.rsc.remoteBrowser.RemoteBrowserMsg"/>
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

  <uix:metaContainer>
    <uix:head titleBinding="<%= RemoteBrowserConst.HEADER %>" />
  </uix:metaContainer>

  <uix:body>
  <uix:dataScope currentDataBinding="remoteBrowserBean@servletRequest">

    <db:form name="remoteBrowser" 
    	     method="post"
             destinationBinding="<%= RemoteBrowserConst.DESTINATION %>"
             copyParams="target,type">
    <uix:pageLayout titleBinding="HOST_TITLE@rbMsgs" >


      <%-- Hidden Form Values --%>
      <uix:formValue name="pageName" value="<%= RemoteBrowserConst.PAGE_RB_CRED %>" />
      <uix:formValue name="event" value="<%= RemoteBrowserConst.TEST_CONNECTION %>"/>
      <uix:formValue name="<%= RemoteBrowserConst.CURRENT_DIRECTORY %>" 
                     valueBinding="<%= RemoteBrowserConst.CURRENT_DIRECTORY %>"/>
      <uix:formValue name="<%= RemoteBrowserConst.PARAM_CANCEL_CHANGE_CONNECTION %>" 
                     valueBinding="<%= RemoteBrowserConst.PARAM_CANCEL_CHANGE_CONNECTION %>"/>


      <%-- Remote Browser Host Credentials: START --%>

      <%-- ====================================== --%>
      <%-- Page Status: Info Text                 --%>
      <%-- ====================================== --%>
      <uix:pageStatus>
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="HOST_INFO@rbMsgs" />
      </uix:pageStatus>


      <%-- ====================================== --%>
      <%-- Error and Info Display                 --%>
      <%-- ====================================== --%>

      <uix:messages>
        <oem:messageBox messageTypeBinding="rbMessageType@servletRequest" 
                    errorTableBinding="rbErrors@servletRequest"
                    titleTextKey="rbTitleText" mainTextKey="rbMainText"/>
      </uix:messages>

      <%-- ====================================== --%>
      <%-- Host Connection UI                     --%>
      <%-- ====================================== --%>

      <uix:spacer height="5"/>
      <%@ include file="/credentials.jspf"%>
  
      <%-- ====================================== --%>
      <%-- Page Buttons                           --%>
      <%-- ====================================== --%>

      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:button textBinding="CANCEL@rbMsgs" 
                      onClick="cancelSetCredentials()" 
                      shortDescBinding="CANCEL@rbMsgs" />
          <uix:submitButton textBinding="CONTINUE@rbMsgs" 
                      name="event" 
                      value="<%= RemoteBrowserConst.TEST_CONNECTION %>"
                      shortDescBinding="CONTINUE@rbMsgs" />
       </uix:pageButtonBar>
      </uix:pageButtons>

      <%-- Remote Browser Host Credentials: END --%>

     </uix:pageLayout>
     </db:form>

   </uix:dataScope>
   </uix:body>
  </uix:document>
</uix:renderingContext>
