<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        remoteBrowserProgress.jsp
  -- Controller:  RemoteBrowserController.jsp
  -- Description: Remote System File and Directory Browser
  -- 
  -- MODIFIED    (MM/DD/YY)
  --   dchakum 03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from st_emdbsa_11.1
  --   chancha 01/29/08 - Add Search And List function
  --   sresrin 03/21/06 - Fix jsp compilation errors
  --   mpawelk 09/17/05 - bug 4463685 - rework progress page to prevent hang/loop
  --   qsong   07/26/05 - qsong_bug-4463865
  --   qsong   05/07/21 - created
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.remoteBrowser.RemoteBrowserConst" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext">

  <uix:bundle name="rbMsgs" class="oracle.sysman.db.rsc.remoteBrowser.RemoteBrowserMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

  <uix:metaContainer>
    <uix:head titleBinding="<%= RemoteBrowserConst.HEADER %>" />
  </uix:metaContainer>

  <uix:body>
  <uix:dataScope currentDataBinding="remoteBrowserBean@servletRequest">

    <db:form name="processForm" 
             method="post"
             destinationBinding="<%= RemoteBrowserConst.DESTINATION %>"
             copyParams="target,type,pageName,cancelURL,oname,otype" >
    <uix:formValue name="pageName" value="/database/remoteBrowser/remoteBrowserProgress"/>
    <uix:pageLayout titleBinding="<%= RemoteBrowserConst.HEADER %>" >

      <%-- Remote File and Directory Browser Contents: START --%>

      <%-- ====================================== --%>
      <%-- Page Status: Info Text                 --%>
      <%-- ====================================== --%>
      <uix:pageStatus>
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="<%= RemoteBrowserConst.INFO_MESSAGE %>" />
      </uix:pageStatus>


      <%-- ====================================== --%>
      <%-- Host Connection UI                     --%>
      <%-- ====================================== --%>

      <uix:labeledFieldLayout width="75%">

        <%-- Host Name --%>
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="HOST@rbMsgs" />
        <uix:styledText styleClass="OraDataText" 
                        textBinding="<%= RemoteBrowserConst.HOST_NAME %>" />

        <%-- Host Username --%>
        <uix:messagePrompt promptBinding="HOST_USER@rbMsgs" />
        <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText styleClass="OraDataText"
                          textBinding="<%= RemoteBrowserConst.HOST_USER %>" />
          <uix:spacer width="5" />
          <uix:submitButton textBinding="CHANGE@rbMsgs" 
                          name="event" 
                          value="<%= RemoteBrowserConst.CHANGE_CONNECTION %>"
                          disabled="true"/>
        </uix:rowLayout>
        </uix:tableLayout>
      
        <%-- Current Directory Breadcrumbs --%>
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="CURRENT_DIRECTORY@rbMsgs" />
        <uix:breadCrumbs>
          <uix:contents childDataBinding="<%= RemoteBrowserConst.CURRENT_DIR_LINKS %>">
            <uix:link textBinding="text"
                      onClickBinding="destination" 
                      disabled="true"/>
          </uix:contents>
        </uix:breadCrumbs>

      </uix:labeledFieldLayout>

          <uix:dataScope>
            <%@ page import="oracle.cabo.share.config.AccessibilityMode"%>
            <%@ page import="oracle.cabo.share.config.Configuration"%>
              <% 
                  // For ADA, increase time interval if in accessible mode.
                  Configuration adaConfig = renderingContext.getConfiguration();    
              
                  // Normal refresh rate is 1 seconds. 
                  String processingPageInterval = "1000"; 
                 
                  if (!AccessibilityMode.isInaccessibleMode(adaConfig))
                      processingPageInterval = "60000"; 
              %>

              <uix:tableLayout>
                <uix:header text="">
                  <uix:tableLayout hAlign="center" cellSpacing="5">
                    <uix:rowLayout>
                      <uix:spacer height="10"/>
                    </uix:rowLayout>
                    <uix:rowLayout> 
                      <uix:processing timeInterval="<%=processingPageInterval%>">
                        <uix:styledText styleClass="OraProcessingStatusFixed"
                                        textBinding="PROCESS_DIR@rbMsgs"/>
                      </uix:processing>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>
              </uix:tableLayout>
          </uix:dataScope>


      <%-- Page Buttons --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:button textBinding="CLOSE@rbMsgs" 
                      onClick="top.close()"
		      renderedBinding="<%= RemoteBrowserConst.PARAM_LIST_ONLY %>"
                      shortDescBinding="CLOSE@rbMsgs" />
          <uix:button textBinding="CANCEL@rbMsgs" 
                      onClick="top.close()"
		      renderedBinding="<%= RemoteBrowserConst.PARAM_RETURN_SELECT %>"
                      shortDescBinding="CANCEL@rbMsgs" />
          <uix:button textBinding="SELECT@rbMsgs" 
                      shortDescBinding="SELECT@rbMsgs" 
		      renderedBinding="<%= RemoteBrowserConst.PARAM_RETURN_SELECT %>"
                      disabled="true"/>

       </uix:pageButtonBar>
      </uix:pageButtons>

      <%-- Remote File and Directory Browser Contents: END --%>
     </uix:pageLayout>
     </db:form>

   </uix:dataScope>
   </uix:body>
  </uix:document>
</uix:renderingContext>
