<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleAddSchemaObjects@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizAddSchemaObjects"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizAddSchemaObjects"/>

          <uix:pageLayout titleBinding="headerAddSchemaObjects@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:header textBinding="SEARCH@ReorgBundle@servletRequest">
              <uix:contents>

                <uix:borderLayout>
                  <uix:left>
                    <uix:labeledFieldLayout labelWidth="20%">
                      <uix:contents>
                        <uix:messagePrompt
                            labeledNodeId="searchType"
                            promptBinding="TYPE@ReorgBundle@servletRequest"/>
                        <uix:choice
                            id="searchType"
                            name="searchType"
                            selectedValueBinding="searchType@reorgBean@servletRequest">
                          <uix:contents>
                            <uix:option value="ALL_TYPES" 
                                textBinding="ALL_TYPES@ReorgBundle@servletRequest"/>
                            <uix:option value="TABLES" 
                                textBinding="TABLES@ReorgBundle@servletRequest"/>
                            <uix:option value="INDEXES" 
                                textBinding="INDEXES@ReorgBundle@servletRequest"/>
                            <uix:option value="TABLE_PARTS" 
                                textBinding="TABLE_PARTS@ReorgBundle@servletRequest"/>
                            <uix:option value="INDEX_PARTS" 
                                textBinding="INDEX_PARTS@ReorgBundle@servletRequest"/>
                            <%--
                            <uix:option value= "SCHEMAS" 
                                textBinding="SCHEMAS@ReorgBundle@servletRequest"/>
                            --%>
                          </uix:contents>
                        </uix:choice>
                        <uix:messagePrompt
                            labeledNodeId="searchSchema"
                            promptBinding="SCHEMA@ReorgBundle@servletRequest"/>
                        <uix:lovInput
                            id="searchSchema"
                            name="searchSchema"
                            columns="30"
                            textBinding="searchSchema@reorgBean@servletRequest"
                            searchDescBinding="CLICK_TO_SELECT_SCHEMA@ReorgBundle@servletRequest"
                            destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                        <uix:messagePrompt
                            labeledNodeId="searchObjectName"
                            promptBinding="OBJECT_NAME@ReorgBundle@servletRequest"/>
                        <uix:textInput
                            id="searchObjectName"
                            name="searchObjectName"
                            textBinding="searchObjectName@reorgBean@servletRequest"
                            columns="30"/>
                        <uix:messagePrompt
                            labeledNodeId="searchPartitionName"
                            promptBinding="PARTITION_NAME@ReorgBundle@servletRequest"/>
                        <uix:textInput
                            id="searchPartitionName"
                            name="searchPartitionName"
                            textBinding="searchPartitionName@reorgBean@servletRequest"
                            columns="30"/>
                        <uix:messagePrompt
                            labeledNodeId="searchTablespace"
                            promptBinding="TABLESPACE@ReorgBundle@servletRequest"/>
                        <uix:lovInput
                            id="searchTablespace"
                            name="searchTablespace"
                            columns="30"
                            searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                            textBinding="searchTablespace@reorgBean@servletRequest"
                            destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                        <uix:messagePrompt prompt=""/>
                        <uix:submitButton
                            name="event"
                            value="addSchemaObjectsSearch"
                            textBinding="BTN_SEARCH@ReorgBundle@servletRequest"/>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:left>
                  <uix:right>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:checkBox
                            name="searchSizeOption"
                            checkedBinding="searchSizeOption@reorgBean@servletRequest"
                            textBinding="MINIMUM_SIZE_CB@ReorgBundle@servletRequest"/>
                        <%--
                        <uix:styledText
                            text="Search by size can result in a slower query"
                            styleClass="OraInlineInfoText"/>
                        --%>
                    <uix:labeledFieldLayout labelWidth="40%">
                      <uix:contents>
                        <uix:messagePrompt
                            labeledNodeId="searchSize"
                            promptBinding="MINIMUM_SIZE_KB@ReorgBundle@servletRequest"/>
                        <uix:textInput
                            id="searchSize"
                            name="searchSize"
                            textBinding="searchSize@reorgBean@servletRequest"
                            columns="10">
                          <uix:onSubmitValidater>
                            <uix:decimal/>
                          </uix:onSubmitValidater>
                        </uix:textInput>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                    </uix:contents>
                    </uix:stackLayout>
                  </uix:right>
                </uix:borderLayout>

                <%--
                <uix:labeledFieldLayout labelWidth="15%">
                  <uix:contents>
                    <uix:messagePrompt
                        labeledNodeId="searchType"
                        promptBinding="TYPE@ReorgBundle@servletRequest"/>
                    <uix:choice
                        id="searchType"
                        name="searchType"
                        selectedValueBinding="searchType@reorgBean@servletRequest">
                      <uix:contents>
                        <uix:option textBinding="ALL_TYPES@ReorgBundle@servletRequest"/>
                        <uix:option textBinding="TABLES@ReorgBundle@servletRequest"/>
                        <uix:option textBinding="INDEXES@ReorgBundle@servletRequest"/>
                        <uix:option textBinding="TABLE_PARTS@ReorgBundle@servletRequest"/>
                        <uix:option textBinding="INDEX_PARTS@ReorgBundle@servletRequest"/>
                      </uix:contents>
                    </uix:choice>
                    <uix:messagePrompt
                        labeledNodeId="searchSchema"
                        promptBinding="SCHEMA@ReorgBundle@servletRequest"/>
                    <uix:lovInput
                        id="searchSchema"
                        name="searchSchema"
                        columns="30"
                        textBinding="searchSchema@reorgBean@servletRequest"
                        shortDesc="Click here to select schema"
                        destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                    <uix:messagePrompt
                        labeledNodeId="searchObjectName"
                        promptBinding="OBJECT_NAME@ReorgBundle@servletRequest"/>
                    <uix:textInput
                        id="searchObjectName"
                        name="searchObjectName"
                        textBinding="searchObjectName@reorgBean@servletRequest"
                        columns="30"/>
                    <uix:messagePrompt
                        labeledNodeId="searchPartitionName"
                        promptBinding="PARTITION_NAME@ReorgBundle@servletRequest"/>
                    <uix:textInput
                        id="searchPartitionName"
                        name="searchPartitionName"
                        textBinding="searchPartitionName@reorgBean@servletRequest"
                        columns="30"/>
                    <uix:messagePrompt
                        labeledNodeId="searchTablespace"
                        promptBinding="TABLESPACE@ReorgBundle@servletRequest"/>
                    <uix:lovInput
                        id="searchTablespace"
                        name="searchTablespace"
                        columns="30"
                        shortDescBinding="CLICKTOSELECTTABLESPACE@uixDBObjectBundle@servletRequest"
                        textBinding="searchTablespace@reorgBean@servletRequest"
                        destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                    <uix:messagePrompt
                        labeledNodeId="searchSize"
                        promptBinding="SIZE@ReorgBundle@servletRequest"/>
                    <uix:textInput
                        id="searchSize"
                        name="searchSize"
                        textBinding="searchSize@reorgBean@servletRequest"
                        columns="10">
                      <uix:onSubmitValidater>
                        <uix:decimal/>
                      </uix:onSubmitValidater>
                    </uix:textInput>
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton
                        name="event"
                        value="addSchemaObjectsSearch"
                        textBinding="BTN_SEARCH@ReorgBundle@servletRequest"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
                --%>
              </uix:contents>
            </uix:header>
            <uix:header textBinding="resultsHeader@reorgBean@servletRequest">
              <uix:contents>
                <oem:table
                    name="selectionTable"
                    beanKey="reorgBean"
                    dataSourceProp="selectionTable"
                    blockSize="10"
                    alternateTextBinding="NO_OBJECTS_FOUND@ReorgBundle@servletRequest"
                    width="100%"
                    summaryBinding="MSG_AVAIL_OBJ@ReorgBundle@servletRequest"
                    formSubmitted="true">
<%--
blockSizeBinding="tableBlocksize@reorgBean@servletRequest"
Using blockSizeBinding with multipleSelection, generates
an exception, a portion of which is shown here:
java.lang.ClassCastException: java.lang.String
at oracle.sysman.emSDK.jsp.RowDataProxy.selectValue(TableDataProxy.java:143)
at oracle.cabo.ui.data.bind.NestedBoundValue.getValue(NestedBoundValue.java:80)
at oracle.cabo.ui.BaseUINode.getAttributeValueImpl(BaseUINode.java:577)
at oracle.cabo.ui.BaseUINode.getAttributeValue(BaseUINode.java:256)
at oracle.cabo.ui.laf.browser.MultipleSelectionRenderer.isChecked(MultipleSelectionRenderer.java:108)
...
--%>
                  <uix:tableSelection>
                    <uix:multipleSelection
                        shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                        selectionBinding="selection@reorgBean@servletRequest"
                        selectedBinding="isSelected">
                    </uix:multipleSelection>
                  </uix:tableSelection>
                </oem:table>
              </uix:contents>
            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="addSchemaObjectsCancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="addSchemaObjectsOK"
                    textBinding="BTN_OK@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

