<%-- 
 * Note re: ADA/OAC - Do not worry about NOSCRIPT tag P1 error.
 * This should be handled by UIX at some point in time.
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleGenerateScript@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizGenerateScript"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue 
              name="pageName" 
              value="/database/reorg/wizGenerateScript"/>

          <uix:pageLayout>

            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:header
                textBinding="headerGenerateScript@reorgDBJobObjectBean@servletRequest"
                icon="/em/images/processl.gif">

              <uix:borderLayout>
                <uix:left>
                  <uix:labeledFieldLayout columns="2" labelWidth="20%">
                    <uix:contents>
                      <uix:messageStyledText
                          promptBinding="targetLabel@reorgBean@servletRequest"
                          styleClass="OraDataText"
                          textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                      <uix:messageStyledText
                          promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                          styleClass="OraDataText"
                          textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                      <uix:messageStyledText
                          promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                          styleClass="OraDataText"
                          textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:left>
                <uix:right>
                  <uix:tableLayout width="100%">
                    <uix:rowLayout hAlign="right">
                      <uix:submitButton
                          name="event"
                          value="cancelGenerate"
                          textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:right>
              </uix:borderLayout>

              <uix:tableLayout width="100%" hAlign="center">

                <uix:rowLayout>
                  <uix:separator/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="left">
                  <uix:flowLayout>
                    <uix:styledText 
                        styleClass="OraInstructionText"
                        textBinding="GEN_REORG_SCR_INFO@ReorgBundle@servletRequest"/>
                    <uix:styledText
                        styleClass="OraInstructionText"
                        textBinding="MIN_TO_COMPLETE@ReorgBundle@servletRequest"/>
                  </uix:flowLayout>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:processing
                            timeInterval="<%=processingPageInterval%>">
                          <uix:contents>
                            <uix:styledText
                                styleClass="OraProcessingStatusFixed"
                                textBinding="IN_PROGRESS@ReorgBundle@servletRequest"/>
                          </uix:contents>
                        </uix:processing>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>

            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelGenerate"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

