<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleOptionsStep@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizOptionsStep"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizOptionsStep"/>

          <uix:pageLayout titleBinding="headerOptionsStep@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:header textBinding="METHOD_HDR@ReorgBundle@servletRequest">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionText"
                          textBinding="METHOD_INSTR@ReorgBundle@servletRequest"/>
                      <uix:radioButton
                          name="reorgMethod"
                          textBinding="METHOD_SPEED@ReorgBundle@servletRequest"
                          selectedValueBinding="reorgMethod@reorgBean@servletRequest"
                          valueBinding="REORG_METHOD_OFFLINE@reorgBean@servletRequest"/>
                      <uix:radioButton
                          name="reorgMethod"
                          textBinding="METHOD_AVAIL@ReorgBundle@servletRequest"
                          selectedValueBinding="reorgMethod@reorgBean@servletRequest"
                          valueBinding="REORG_METHOD_ONLINE@reorgBean@servletRequest"/>
                    </uix:contents>
                  </uix:stackLayout>
                  <uix:switcher childNameBinding="version92OrLater@reorgBean@servletRequest">
                    <uix:case name="true">
                      <uix:labeledFieldLayout labelWidth="5%">
                        <uix:contents>
                          <uix:messagePrompt prompt=""/>
                          <uix:checkBox
                              name="rowidMethod"
                              checkedBinding="rowidMethod@reorgBean@servletRequest"
                              textBinding="METHOD_USE_ROWID@ReorgBundle@servletRequest"/>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:header>

              <uix:header textBinding="SCR_TBSPC_HDR@ReorgBundle@servletRequest">
                <uix:contents>
                  <uix:switcher childNameBinding="typeReorgObjects@reorgDBJobObjectBean@servletRequest">
                    <uix:case name="true">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText"
                              textBinding="SCR_TBSPC_INSTR@ReorgBundle@servletRequest"/>
                          <uix:radioButton
                              name="scratchTablespaceOption"
                              textBinding="SCR_TBSPC_CURR@ReorgBundle@servletRequest"
                              selectedValueBinding="scratchTablespaceOption@reorgBean@servletRequest"
                              valueBinding="TABLESPACE_OPT_CURR@reorgBean@servletRequest"/>
                          <uix:flowLayout>
                            <uix:contents>
                              <uix:radioButton
                                  name="scratchTablespaceOption"
                                  textBinding="SCR_TBSPC_NEW@ReorgBundle@servletRequest"
                                  selectedValueBinding="scratchTablespaceOption@reorgBean@servletRequest"
                                  valueBinding="TABLESPACE_OPT_NEW@reorgBean@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraInstructionText"
                                  labeledNodeId="scratchTablespace1"
                                  textBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                  rendered="false"/>
                              <uix:lovInput
                                  id="scratchTablespace1"
                                  name="scratchTablespace"
                                  columns="40"
                                  searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                                  shortDescBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                  textBinding="scratchTablespace@reorgBean@servletRequest"
                                  destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>
                  <uix:switcher childNameBinding="typeReorgTablespace@reorgDBJobObjectBean@servletRequest">
                    <uix:case name="true">
                      <uix:switcher childNameBinding="tablespaceRenameValid@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="SCR_TBSPC_INSTR@ReorgBundle@servletRequest"/>
                              <uix:radioButton
                                  name="scratchTablespaceOption"
                                  textBinding="SCR_TBSPC_REN@ReorgBundle@servletRequest"
                                  selectedValueBinding="scratchTablespaceOption@reorgBean@servletRequest"
                                  valueBinding="TABLESPACE_OPT_CURR@reorgBean@servletRequest"/>
                              <uix:flowLayout>
                                <uix:contents>
                                  <uix:radioButton
                                      name="scratchTablespaceOption"
                                      textBinding="SCR_TBSPC_NEW@ReorgBundle@servletRequest"
                                      selectedValueBinding="scratchTablespaceOption@reorgBean@servletRequest"
                                      valueBinding="TABLESPACE_OPT_NEW@reorgBean@servletRequest"/>
                                  <uix:styledText
                                      styleClass="OraInstructionText"
                                      labeledNodeId="scratchTablespace2"
                                      textBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                      rendered="false"/>
                                  <uix:lovInput
                                      id="scratchTablespace2"
                                      name="scratchTablespace"
                                      columns="40"
                                      searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                                      shortDescBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                      textBinding="scratchTablespace@reorgBean@servletRequest"
                                      destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                                </uix:contents>
                              </uix:flowLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:case>
                        <uix:case name="false">
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="SCR_TBSPC_INSTR@ReorgBundle@servletRequest"/>
                              <uix:labeledFieldLayout labelWidth="5%">
                                <uix:contents>
                                  <uix:messagePrompt
                                      labeledNodeId="scratchTablespace3"
                                      promptBinding="TABLESPACE@ReorgBundle@servletRequest"
                                      required="yes"/>
                                  <uix:lovInput
                                      id="scratchTablespace3"
                                      name="scratchTablespace"
                                      columns="40"
                                      searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                                      shortDescBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                      textBinding="scratchTablespace@reorgBean@servletRequest"
                                      destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                                </uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>
                  <uix:switcher childNameBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest">
                    <uix:case name="true">
                      <uix:switcher childNameBinding="tablespaceRenameValid@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="SCR_TBSPC_INSTR@ReorgBundle@servletRequest"/>
                              <uix:radioButton
                                  name="scratchTablespaceOption"
                                  textBinding="SCR_TBSPC_REN@ReorgBundle@servletRequest"
                                  selectedValueBinding="scratchTablespaceOption@reorgBean@servletRequest"
                                  valueBinding="TABLESPACE_OPT_CURR@reorgBean@servletRequest"/>
                              <uix:flowLayout>
                                <uix:contents>
                                  <uix:radioButton
                                      name="scratchTablespaceOption"
                                      textBinding="SCR_TBSPC_NEW@ReorgBundle@servletRequest"
                                      selectedValueBinding="scratchTablespaceOption@reorgBean@servletRequest"
                                      valueBinding="TABLESPACE_OPT_NEW@reorgBean@servletRequest"/>
                                  <uix:styledText
                                      styleClass="OraInstructionText"
                                      labeledNodeId="scratchTablespace4"
                                      textBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                      rendered="false"/>
                                  <uix:lovInput
                                      id="scratchTablespace4"
                                      name="scratchTablespace"
                                      columns="40"
                                      searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                                      shortDescBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                      textBinding="scratchTablespace@reorgBean@servletRequest"
                                      destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                                </uix:contents>
                              </uix:flowLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:case>
                        <uix:case name="false">
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="SCR_TBSPC_INSTR@ReorgBundle@servletRequest"/>
                              <uix:labeledFieldLayout labelWidth="5%">
                                <uix:contents>
                                  <uix:messagePrompt
                                      labeledNodeId="scratchTablespace5"
                                      promptBinding="TABLESPACE@ReorgBundle@servletRequest"
                                      required="yes"/>
                                  <uix:lovInput
                                      id="scratchTablespace5"
                                      name="scratchTablespace"
                                      columns="40"
                                      searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                                      shortDescBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                      textBinding="scratchTablespace@reorgBean@servletRequest"
                                      destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                                </uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:header>

              <uix:hideShow
                  id="hideShow"
                  disclosedBinding="showAdvancedOptions@reorgBean@servletRequest"
                  formSubmitted="true"
                  disclosedTextBinding="HIDE_ADVANCED_OPTIONS@ReorgBundle@servletRequest"
                  undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@ReorgBundle@servletRequest">
                <uix:contents>

                  <uix:header textBinding="OBJ_PARS_HDR@ReorgBundle@servletRequest">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:checkBox
                              name="parallel"
                              checkedBinding="parallel@reorgBean@servletRequest"
                              textBinding="OBJ_PARS_USE_PAR@ReorgBundle@servletRequest"/>
                        </uix:contents>
                      </uix:stackLayout>
                      <uix:labeledFieldLayout labelWidth="16%">
                        <uix:contents>
                          <uix:messagePrompt promptBinding="OBJ_PARS_PAR_DEGREE@ReorgBundle@servletRequest"/>
                          <uix:flowLayout>
                            <uix:contents>
                              <uix:radioButton
                                  name="parallelDegreeOption"
                                  textBinding="OBJ_PARS_PAR_DEFAULT@ReorgBundle@servletRequest"
                                  selectedValueBinding="parallelDegreeOption@reorgBean@servletRequest"
                                  valueBinding="PARALLEL_DEGREE_DEFAULT@reorgBean@servletRequest"/>
                              <uix:radioButton
                                  name="parallelDegreeOption"
                                  textBinding="OBJ_PARS_PAR_VALUE@ReorgBundle@servletRequest"
                                  selectedValueBinding="parallelDegreeOption@reorgBean@servletRequest"
                                  valueBinding="PARALLEL_DEGREE_VALUE@reorgBean@servletRequest"/>
                              <uix:textInput
                                  shortDescBinding="OBJ_PARS_PAR_VALUE@ReorgBundle@servletRequest"
                                  name="parallelDegreeValue"
                                  textBinding="parallelDegreeValue@reorgBean@servletRequest"
                                  columns="5"/>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:checkBox
                              name="noLogging"
                              checkedBinding="noLogging@reorgBean@servletRequest"
                              textBinding="OBJ_PARS_NO_LOGGING@ReorgBundle@servletRequest"/>
                          <uix:checkBox
                              name="updateCBOStats"
                              checkedBinding="updateCBOStats@reorgBean@servletRequest"
                              textBinding="OBJ_PARS_UPD_CBO@ReorgBundle@servletRequest"/>
                          <uix:labeledFieldLayout labelWidth="3%">
                            <uix:contents>
                              <uix:messagePrompt prompt=""/>
                              <uix:radioButton
                                  name="cboStatsOption"
                                  textBinding="OBJ_PARS_COMPUTE@ReorgBundle@servletRequest"
                                  selectedValueBinding="cboStatsOption@reorgBean@servletRequest"
                                  valueBinding="CBO_STATS_COMPUTE@reorgBean@servletRequest"/>
                              <uix:messagePrompt prompt=""/>
                              <uix:radioButton
                                  name="cboStatsOption"
                                  textBinding="OBJ_PARS_ESTIMATE@ReorgBundle@servletRequest"
                                  selectedValueBinding="cboStatsOption@reorgBean@servletRequest"
                                  valueBinding="CBO_STATS_ESTIMATE@reorgBean@servletRequest"/>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                          <uix:labeledFieldLayout labelWidth="24%">
                            <uix:contents>
                              <uix:messagePrompt promptBinding="OBJ_PARS_ESTIMATE_PERCENTAGE@ReorgBundle@servletRequest"/>
                              <uix:radioButton
                                  name="sampleSizeOption"
                                  textBinding="OBJ_PARS_DEFAULT@ReorgBundle@servletRequest"
                                  selectedValueBinding="sampleSizeOption@reorgBean@servletRequest"
                                  valueBinding="SAMPLE_SIZE_DEFAULT@reorgBean@servletRequest"/>
                              <uix:messagePrompt prompt=""/>
                              <uix:flowLayout>
                                <uix:contents>
                                  <uix:radioButton
                                      name="sampleSizeOption"
                                      textBinding="OBJ_PARS_PERCENTAGE@ReorgBundle@servletRequest"
                                      selectedValueBinding="sampleSizeOption@reorgBean@servletRequest"
                                      valueBinding="SAMPLE_SIZE_PERCENT@reorgBean@servletRequest"/>
                                  <uix:textInput
                                      shortDescBinding="OBJ_PARS_PERCENTAGE@ReorgBundle@servletRequest"
                                      name="sampleSizeValue"
                                      textBinding="sampleSizeValue@reorgBean@servletRequest"
                                      columns="5"/>
                                </uix:contents>
                              </uix:flowLayout>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                          <uix:checkBox
                              name="numCommitRows"
                              checkedBinding="numCommitRows@reorgBean@servletRequest"
                              textBinding="OBJ_PARS_SPEC_ROWS@ReorgBundle@servletRequest"/>
                          <uix:labeledFieldLayout labelWidth="17%">
                            <uix:contents>
                              <uix:messagePrompt
                                  labeledNodeId="numCommitRowsValue"
                                  promptBinding="OBJ_PARS_NUM_ROWS@ReorgBundle@servletRequest"/>
                              <uix:textInput
                                  id="numCommitRowsValue"
                                  name="numCommitRowsValue"
                                  textBinding="numCommitRowsValue@reorgBean@servletRequest"
                                  columns="5"/>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:header>

        	  <uix:switcher childNameBinding="includeSessionParameters@reorgBean@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="SESS_PARS_HDR@ReorgBundle@servletRequest">
                	<uix:contents>
                	  <uix:switcher childNameBinding="includeWorkAreaSizePolicy@reorgBean@servletRequest">
                            <uix:case name="true">
                              <uix:labeledFieldLayout labelWidth="20%">
                        	<uix:contents>
                        	  <uix:messagePrompt
                                      labeledNodeId="workAreaSizePolicy"
                                      promptBinding="SESS_PARS_WRK_SIZ_POL@ReorgBundle@servletRequest"/>
                        	  <uix:choice
                                      id="workAreaSizePolicy"
                                      name="workAreaSizePolicy"
                                      selectedValueBinding="workAreaSizePolicy@reorgBean@servletRequest">
                                    <uix:contents>
                                      <uix:option textBinding="SESS_PARS_POL_MANUAL@ReorgBundle@servletRequest"/>
                                      <uix:option textBinding="SESS_PARS_POL_AUTO@ReorgBundle@servletRequest"/>
                                    </uix:contents>
                        	  </uix:choice>
                        	</uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:case>
                	  </uix:switcher>
                	  <uix:switcher childNameBinding="includeSortAreaSize@reorgBean@servletRequest">
                            <uix:case name="true">
                              <uix:labeledFieldLayout labelWidth="20%">
                        	<uix:contents>
                        	  <uix:messagePrompt
                                      labeledNodeId="sortAreaSize"
                                      promptBinding="SESS_PARS_SRT_SIZ@ReorgBundle@servletRequest"/>
                        	  <uix:textInput
                                      id="sortAreaSize"
                                      name="sortAreaSize"
                                      textBinding="sortAreaSize@reorgBean@servletRequest"
                                      columns="10"/>
                        	  <uix:messagePrompt
                                      prompt=""/>
                        	  <uix:styledText
                                      textBinding="SESS_PARS_SRT_SIZ_TIP@ReorgBundle@servletRequest"
                                      styleClass="OraInlineInfoText"/>
                        	</uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:case>
                	  </uix:switcher>
                	  <uix:switcher childNameBinding="includeMultiblockReadCount@reorgBean@servletRequest">
                            <uix:case name="true">
                              <uix:labeledFieldLayout labelWidth="20%">
                        	<uix:contents>
                        	  <uix:messagePrompt
                                      labeledNodeId="multiblockReadCount"
                                      promptBinding="SESS_PARS_MUL_RD_CNT@ReorgBundle@servletRequest"/>
                        	  <uix:choice
                                      id="multiblockReadCount"
                                      name="multiblockReadCount"
                                      selectedValueBinding="multiblockReadCount@reorgBean@servletRequest">
                                    <uix:contents>
                                      <uix:option text="8"/>
                                      <uix:option text="16"/>
                                      <uix:option text="32"/>
                                      <uix:option text="64"/>
                                      <uix:option text="128"/>
                                    </uix:contents>
                        	  </uix:choice>
                        	</uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:case>
                	  </uix:switcher>
                	</uix:contents>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="includeRecycleBinOptions@reorgBean@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="RECYCLE_BIN_OPTIONS@ReorgBundle@servletRequest">
                        <uix:contents>
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:checkBox
                        	  name="purgeRecycleBin"
                        	  checkedBinding="purgeRecycleBin@reorgBean@servletRequest"
                        	  textBinding="PURGE_RECYCLE_BIN@ReorgBundle@servletRequest"/>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:contents>
                      </uix:header>
                    </uix:case>
        	  </uix:switcher>

                </uix:contents>
              </uix:hideShow>

            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    minValue="1"
                    maxValueBinding="maxPageSequence@reorgDBJobObjectBean@servletRequest"
                    valueBinding="pageSequence@reorgDBJobObjectBean@servletRequest"
                    formSubmitted="true"
                    formName="wizOptionsStep"
                    destinationBinding="reorgDestination@reorgBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

