<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="titleImpactReportStep@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizPrintableImpactReport"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizPrintableImpactReport"/>

          <uix:pageLayout titleBinding="headerImpactReportStep@reorgDBJobObjectBean@servletRequest">

            <%@ include file="/oemLicense.jspf" %>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:switcher childNameBinding="impactReportAvailable@reorgBean@servletRequest">
                <uix:case name="true">
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:header textBinding="IMPACT_REPORT@ReorgBundle@servletRequest">
                        <uix:contents>
                          <uix:header textBinding="IR_SCR_GEN_SUMMARY@ReorgBundle@servletRequest">
                            <uix:contents>
                              <uix:labeledFieldLayout labelWidth="30%">
                                <uix:contents>
                                  <uix:messagePrompt
                                      promptBinding="IR_MOST_SERIOUS_MSG@ReorgBundle@servletRequest"/>
                                  <uix:styledText
                                      styleClass="OraDataText"
                                      textBinding="generationSeverityText@reorgBean@servletRequest"/>
                                  <uix:messagePrompt
                                      promptBinding="IR_SCR_GEN_STARTED@ReorgBundle@servletRequest"/>
                                  <uix:styledText
                                      styleClass="OraDataText"
                                      textBinding="generationStartTime@reorgBean@servletRequest"/>
                                  <uix:messagePrompt
                                      promptBinding="IR_SCR_GEN_COMPLETED@ReorgBundle@servletRequest"/>
                                  <uix:styledText
                                      styleClass="OraDataText"
                                      textBinding="generationCompleteTime@reorgBean@servletRequest"/>
                                </uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:contents>
                          </uix:header>
                          <uix:header textBinding="IR_SCR_GEN_INFO@ReorgBundle@servletRequest">
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                  textBinding="IR_SCR_GEN_INFO_TIP@ReorgBundle@servletRequest"/>
                              <oem:table
                                  alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                                  name="impactReportTable"
                                  dataSourceProp="impactReportTable"
                                  beanKey="reorgBean"
                                  width="100%" 
                                  blockSize="10"
                                  summaryBinding="IR_SCR_GEN_INFO@ReorgBundle@servletRequest"
                                  formSubmitted="true">
                              </oem:table>
                            </uix:contents>
                          </uix:header>
                        </uix:contents>
                      </uix:header>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:case>
              </uix:switcher>
            </uix:contents>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

