<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="HDR_SEARCH_SEL_SCHEMA@ReorgBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        <uix:form name="foo" method="post" destinationBinding="destination@selectSchemaBean@servletRequest">
        --%>
          <uix:listOfValues
              titleBinding="SCHEMA@ReorgBundle@servletRequest"
              shortDescBinding="SCHEMA@ReorgBundle@servletRequest"
              searchTextBinding="searchCriteria@selectSchemaBean@servletRequest">
            <uix:formValue
                name="pageName"
                value="/database/reorg/wizReorgSelectSchema"/>
            <uix:formValue
                name="target"
                valueBinding="targetDBName@reorgBean@servletRequest"/>
            <uix:formValue
                name="type"
                valueBinding="targetType@reorgBean@servletRequest"/>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="SELECT_SCHEMA_INSTR@ReorgBundle@servletRequest"/>
            </uix:searchInstructions>
            <uix:contents>
              <oem:table
                  beanKey="selectSchemaBean"
                  alternateTextBinding="NO_SCHEMAS@ReorgBundle@servletRequest"
                  name="dataSource"
                  dataSourceProp="dataSource"
                  width="100%"
                  blockSize="10"
                  summaryBinding="SELECT_A_SCHEMA@ReorgBundle@servletRequest"
                  formSubmitted="true"
                  proxied="true">
                <uix:tableSelection>
                  <uix:singleSelection
                      shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                      selectedIndex="0"/>
                </uix:tableSelection>
              </oem:table>
            </uix:contents>
          </uix:listOfValues>
        <%--</uix:form>--%>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

