<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="HDR_SEARCH_SEL_TBSPC@ReorgBundle@servletRequest"/>
      <script language="JavaScript">
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>
      <script>
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('tablespaceDataSource');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('Tablespace', selectedIndex);
            lovField.value = selectedElement.value;
            window.close();
          }
        }
      </script>
      <%--
      var selectedElementTablespace = proxy.getFormElement('Tablespace', selectedIndex);
      window.opener.document.foo.tablesTablespace.value = selectedElementTablespace.value;
      var selectedElementExtentMgmt = proxy.getFormElement('ExtentMgmt', selectedIndex);
      window.opener.document.foo.tablesExtentMgmt.value = selectedElementExtentMgmt.value;
      window.opener.document.foo.tablesTablespaceOption.value = 'n';
      --%>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <uix:form
            name="foo"
            method="post"
            destinationBinding="destination@selectTablespaceBean@servletRequest">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizReorgSelectTbspcDB"/>
          <uix:formValue
              name="target"
              valueBinding="targetDBName@reorgBean@servletRequest"/>
          <uix:formValue
              name="type"
              valueBinding="targetType@reorgBean@servletRequest"/>

          <uix:pageLayout titleBinding="HDR_SEARCH_SEL_TBSPC@ReorgBundle@servletRequest">

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:contents>
              <uix:header textBinding="SELECT_TBSPC_SEARCH@ReorgBundle@servletRequest">
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText"
                      textBinding="SELECT_TBSPC_INSTR@ReorgBundle@servletRequest"/>
                  <uix:labeledFieldLayout labelWidth="10%">
                    <uix:contents>
                      <uix:messagePrompt
                          labeledNodeId="tablespaceSearchCriteria"
                          promptBinding="SELECT_TBSPC_SEARCH_BY@ReorgBundle@servletRequest"/>
                      <uix:flowLayout>
                        <uix:contents>
                          <uix:textInput
                              id="tablespaceSearchCriteria"
                              name="tablespaceSearchCriteria"
                              textBinding="tablespaceSearchCriteria@selectTablespaceBean@servletRequest"/>
                          <uix:submitButton
                              textBinding="BTN_GO@ReorgBundle@servletRequest"
                              name="event"
                              value="changeTablespaceSearchCriteria"/>
                        </uix:contents>
                      </uix:flowLayout>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:contents>
              </uix:header>
              <uix:header textBinding="SELECT_TBSPC_RESULTS@ReorgBundle@servletRequest">
                <uix:contents>
                  <oem:table
                      beanKey="selectTablespaceBean"
                      alternateTextBinding="NO_TABLESPACES@ReorgBundle@servletRequest"
                      name="tablespaceDataSource"
                      dataSourceProp="tablespaceDataSource"
                      width="100%"
                      blockSize="10"
                      summaryBinding="SELECT_A_TBSPC@ReorgBundle@servletRequest"
                      formSubmitted="true">
                    <uix:tableSelection>
                      <uix:singleSelection
                          shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                          selectedIndex="0"/>
                    </uix:tableSelection>
                  </oem:table>
                </uix:contents>
              </uix:header>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"
                    destination="javascript:self.close()"/>
                <uix:button
                    textBinding="BTN_SELECT@ReorgBundle@servletRequest"
                    destinationBinding="selectionDestination@selectTablespaceBean@servletRequest"/> 
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

