<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleReviewStep@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizReviewStep"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizReviewStep"/>

          <uix:pageLayout titleBinding="headerReviewStep@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:labeledFieldLayout labelWidth="25%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="SCHED_JOB_NAME@ReorgBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="jobName@reorgBean@servletRequest"/>
                  <uix:messagePrompt
                      promptBinding="JOB_SCHEDULE@ReorgBundle@servletRequest"/>
                  <uix:switcher childNameBinding="scheduleType@reorgBean@servletRequest">
                    <uix:case name="i">
                      <uix:styledText
                          styleClass="OraDataText"
                          textBinding="SCHED_OPT_IMMED@ReorgBundle@servletRequest"/>
                    </uix:case>
                    <uix:case name="l">
                      <uix:styledText
                          styleClass="OraDataText"
                          textBinding="SCHED_OPT_LATER@ReorgBundle@servletRequest"/>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:labeledFieldLayout>

              <uix:switcher childNameBinding="showGenerationSeverityInfo@reorgBean@servletRequest">
                <uix:case name="true">
                  <uix:flowLayout>
                    <uix:contents>
                      <uix:image sourceBinding="generationSeverityIcon@reorgBean@servletRequest"/>
                      <uix:styledText
                          styleClass="OraDataText"
                          textBinding="generationSeverityMsg@reorgBean@servletRequest"/>
                    </uix:contents>
                  </uix:flowLayout>
                </uix:case>
              </uix:switcher>

              <uix:header textBinding="SCRIPT@ReorgBundle@servletRequest">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:borderLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText"
                              textBinding="SCRIPT_INFO@ReorgBundle@servletRequest"/>
                        </uix:contents>
                        <uix:right>
                          <uix:submitButton
                              name="event"
                              value="saveScript"
                              textBinding="SAVE_FULL_SCRIPT@ReorgBundle@servletRequest"/>
                        </uix:right>
                      </uix:borderLayout>
                      <uix:spacer height="5"/>
                      <uix:labeledFieldLayout labelWidth="5%">
                        <uix:messagePrompt
                            promptBinding="VIEW@ReorgBundle@servletRequest"/>
                        <uix:flowLayout>
                          <uix:radioButton
                              name="viewScriptOption"
                              selectedValueBinding="viewScriptOption@reorgBean@servletRequest"
                              textBinding="SCRIPT_SUMMARY@ReorgBundle@servletRequest"
                              valueBinding="SCRIPT_SUMMARY_OPTION@reorgBean@servletRequest"
                              onClick="submitForm('wizReviewStep',true,{'event':'scriptSummaryClicked'})"/>
                          <uix:radioButton
                              name="viewScriptOption"
                              selectedValueBinding="viewScriptOption@reorgBean@servletRequest"
                              textBinding="FULL_SCRIPT@ReorgBundle@servletRequest"
                              valueBinding="FULL_SCRIPT_OPTION@reorgBean@servletRequest"
                              onClick="submitForm('wizReviewStep',true,{'event':'fullScriptClicked'})"/>
                        </uix:flowLayout>
                      </uix:labeledFieldLayout>
                      <uix:switcher childNameBinding="viewScriptOption@reorgBean@servletRequest">
                        <uix:case name="s">
                          <uix:textInput
                              id="scriptSummary"
                              name="scriptSummary"
                              shortDescBinding="SCRIPT_SUMMARY@ReorgBundle@servletRequest"
                              columns="120" rows="16" wrap="soft"
                              textBinding="scriptSummary@reorgBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="f">
                          <uix:textInput
                              id="fullScript"
                              name="fullScript"
                              shortDescBinding="FULL_SCRIPT@ReorgBundle@servletRequest"
                              columns="120" rows="16" wrap="soft"
                              textBinding="fullScript@reorgBean@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
              </uix:header>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    minValue="1"
                    maxValueBinding="maxPageSequence@reorgDBJobObjectBean@servletRequest"
                    valueBinding="pageSequence@reorgDBJobObjectBean@servletRequest"
                    formSubmitted="true"
                    formName="wizReviewStep"
                    destinationBinding="reorgDestination@reorgBean@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="submitJob"
                    textBinding="BTN_SUBMIT@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

