<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleSaveScript@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizSaveScript"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSaveScript"/>

          <uix:pageLayout titleBinding="headerSaveScript@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:radioButton
                      name="saveScriptOption"
                      selectedValueBinding="saveScriptOption@reorgBean@servletRequest"
                      textBinding="SAVE_FULL_SCRIPT_OMS@ReorgBundle@servletRequest"
                      valueBinding="SAVE_SCRIPT_OMS@reorgBean@servletRequest"/>
                  <uix:labeledFieldLayout labelWidth="15%">
                    <uix:contents>
                      <uix:messagePrompt
                          labeledNodeId="scriptNameOMS"
                          promptBinding="SCRIPT_LOCATION@ReorgBundle@servletRequest"/>
                      <uix:textInput
                          id="scriptNameOMS"
                          name="scriptNameOMS"
                          textBinding="scriptNameOMS@reorgBean@servletRequest"
                          columns="80"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                  <uix:radioButton
                      name="saveScriptOption"
                      selectedValueBinding="saveScriptOption@reorgBean@servletRequest"
                      textBinding="SAVE_FULL_SCRIPT_TARGET@ReorgBundle@servletRequest"
                      valueBinding="SAVE_SCRIPT_DB@reorgBean@servletRequest"/>
                  <uix:labeledFieldLayout labelWidth="15%">
                    <uix:contents>
                      <uix:messagePrompt
                          labeledNodeId="scriptNameDB"
                          promptBinding="SCRIPT_LOCATION@ReorgBundle@servletRequest"/>
                      <uix:textInput
                          id="scriptNameDB"
                          name="scriptNameDB"
                          textBinding="scriptNameDB@reorgBean@servletRequest"
                          columns="80"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="saveScriptCancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="saveScriptOK"
                    textBinding="SAVE_FULL_SCRIPT@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

