<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleScheduleStep@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizScheduleStep"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizScheduleStep"/>

          <uix:pageLayout titleBinding="headerScheduleStep@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:labeledFieldLayout labelWidth="26%">
                <uix:contents>
                  <uix:messagePrompt
                      labeledNodeId="jobName"
                      promptBinding="SCHED_JOB_NAME@ReorgBundle@servletRequest"
                      required="yes"/>
                  <uix:textInput
                      id="jobName"
                      name="jobName"
                      textBinding="jobName@reorgBean@servletRequest"
                      columns="60"/>
                  <uix:messagePrompt
                      labeledNodeId="jobDescription"
                      promptBinding="SCHED_JOB_DESC@ReorgBundle@servletRequest"/>
                  <uix:textInput
                      id="jobDescription"
                      name="jobDescription"
                      textBinding="jobDescription@reorgBean@servletRequest"
                      columns="60"/>
                </uix:contents>
              </uix:labeledFieldLayout>
              <uix:header textBinding="SCHED_HOST_CRED_HDR@ReorgBundle@servletRequest">
                <uix:contents>
                  <%@ include file="/credentials.jspf"%>
                </uix:contents>
              </uix:header>
              <%@ include file="/sdk/schedule/start.jspf"%>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    minValue="1"
                    maxValueBinding="maxPageSequence@reorgDBJobObjectBean@servletRequest"
                    valueBinding="pageSequence@reorgDBJobObjectBean@servletRequest"
                    formSubmitted="true"
                    formName="wizScheduleStep"
                    destinationBinding="reorgDestination@reorgBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

