<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleSchemaAttr@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizSchemaAttr"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSchemaAttr"/>

          <uix:pageLayout titleBinding="headerSchemaAttr@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="SCHEMA_ATTR_TIP@ReorgBundle@servletRequest"/>
              <uix:checkBox
                  name="includeLOBColumns"
                  checkedBinding="includeLOBColumns@reorgBean@servletRequest"
                  textBinding="INCLUDE_LOB_COLUMNS@ReorgBundle@servletRequest"/>
              <uix:checkBox
                  name="includeOverflowSegments"
                  checkedBinding="includeOverflowSegments@reorgBean@servletRequest"
                  textBinding="INCLUDE_OVERFLOW_SEGMENTS@ReorgBundle@servletRequest"/>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="schemaAttrCancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="schemaAttrOK"
                    textBinding="BTN_OK@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

