<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleAttrSchemaObjDependents@reorgDBJobObjectBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizSchemaObjDependentsAttr"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSchemaObjDependentsAttr"/>

          <uix:pageLayout titleBinding="headerAttrSchemaObjDependents@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText 
                      promptBinding="OBJECT_NAME@ReorgBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="selectedName@reorgBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText 
                      promptBinding="TYPE@ReorgBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="selectedType@reorgBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="OBJ_ATTR_INSTR@ReorgBundle@servletRequest"/>
              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar selectedIndex="2">
                    <uix:contents>
                      <uix:link textBinding="OBJ_ATTR_GENERAL@ReorgBundle@servletRequest"
                          onClick="submitForm('wizSchemaObjDependentsAttr', true, {event:'generalTab'})"/>
                      <uix:switcher childNameBinding="includeStorageTab@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:link textBinding="OBJ_ATTR_STORAGE@ReorgBundle@servletRequest"
                              onClick="submitForm('wizSchemaObjDependentsAttr', true, {event:'storageTab'})"/>
                        </uix:case>
                      </uix:switcher>
                      <uix:switcher childNameBinding="dependentObjectsAvailable@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:link textBinding="OBJ_ATTR_DEP_OBJS@ReorgBundle@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:contents>
                  </uix:subTabBar>
                </uix:subTabs>
                <uix:contents>
                  <uix:tableLayout cellSpacing="5" width="100%">
                    <uix:contents>
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:tip>
                            <uix:contents>
                              <uix:styledText styleClass="OraTipText"
                                  textBinding="OBJ_ATTR_DEP_TIP@ReorgBundle@servletRequest"/>
                            </uix:contents>
                          </uix:tip>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:tableLayout>

                  <uix:switcher childNameBinding="overflowSegmentAvailable@reorgBean@servletRequest">
                    <uix:case name="true">
                      <%--
                      <uix:hideShow
                          id="overflowSegment"
                          disclosedBinding="overflowSegmentDisclosed@reorgBean@servletRequest"
                          formSubmitted="true"
                          disclosedTextBinding="Hide Overflow Segment"
                          undisclosedTextBinding="Show Overflow Segment">
                        <uix:contents>
                      --%>
                          <uix:header textBinding="OBJ_ATTR_OVERFLOW_SEG@ReorgBundle@servletRequest">
                            <uix:contents>
                              <oem:table
                                  name="overflowSegmentTable"
                                  dataSourceProp="overflowSegmentTable"
                                  beanKey="reorgBean"
                                  width="100%"
                                  blockSize="10"
                                  summaryBinding="OBJ_ATTR_OVERFLOW_SEG@ReorgBundle@servletRequest"
                                  formSubmitted="true">
                              </oem:table>
                            </uix:contents>
                          </uix:header>
                      <%--
                        </uix:contents>
                      </uix:hideShow>
                      --%>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="tablePartitionsAvailable@reorgBean@servletRequest">
                    <uix:case name="true">
                      <%--
                      <uix:hideShow
                          id="tablePartitions"
                          disclosedBinding="tablePartitionsDisclosed@reorgBean@servletRequest"
                          formSubmitted="true"
                          disclosedTextBinding="Hide Subpartitions"
                          undisclosedTextBinding="Show Subpartitions">
                        <uix:contents>
                      --%>
                          <uix:header textBinding="OBJ_ATTR_SUBPARTITIONS@ReorgBundle@servletRequest">
                            <uix:contents>
                              <oem:table
                                  name="tablePartitionsTable"
                                  dataSourceProp="tablePartitionsTable"
                                  beanKey="reorgBean"
                                  width="100%"
                                  blockSize="10"
                                  summaryBinding="OBJ_ATTR_SUBPARTITIONS@ReorgBundle@servletRequest"
                                  formSubmitted="true">
                              </oem:table>
                            </uix:contents>
                          </uix:header>
                      <%--
                        </uix:contents>
                      </uix:hideShow>
                      --%>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="lobColumnsAvailable@reorgBean@servletRequest">
                    <uix:case name="true">
                      <%--
                      <uix:hideShow
                          id="lobColumns"
                          disclosedBinding="lobColumnsDisclosed@reorgBean@servletRequest"
                          formSubmitted="true"
                          disclosedTextBinding="Hide LOB Columns"
                          undisclosedTextBinding="Show LOB Columns">
                        <uix:contents>
                      --%>
                          <uix:header textBinding="OBJ_ATTR_LOB_COLUMNS@ReorgBundle@servletRequest">
                            <uix:contents>
                              <oem:table
                                  name="lobColumnsTable"
                                  dataSourceProp="lobColumnsTable"
                                  beanKey="reorgBean"
                                  width="100%"
                                  blockSize="10"
                                  summaryBinding="OBJ_ATTR_LOB_COLUMNS@ReorgBundle@servletRequest"
                                  formSubmitted="true">
                              </oem:table>
                            </uix:contents>
                          </uix:header>
                      <%--
                        </uix:contents>
                      </uix:hideShow>
                      --%>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="indexPartitionsAvailable@reorgBean@servletRequest">
                    <uix:case name="true">
                      <%--
                      <uix:hideShow
                          id="indexPartitions"
                          disclosedBinding="indexPartitionsDisclosed@reorgBean@servletRequest"
                          formSubmitted="true"
                          disclosedTextBinding="Hide Subpartitions"
                          undisclosedTextBinding="Show Subpartitions">
                        <uix:contents>
                      --%>
                          <uix:header textBinding="OBJ_ATTR_SUBPARTITIONS@ReorgBundle@servletRequest">
                            <uix:contents>
                              <oem:table
                                  name="indexPartitionsTable"
                                  dataSourceProp="indexPartitionsTable"
                                  beanKey="reorgBean"
                                  width="100%"
                                  blockSize="10"
                                  summaryBinding="OBJ_ATTR_SUBPARTITIONS@ReorgBundle@servletRequest"
                                  formSubmitted="true">
                              </oem:table>
                            </uix:contents>
                          </uix:header>
                      <%--
                        </uix:contents>
                      </uix:hideShow>
                      --%>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>

              </uix:subTabLayout>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="attrSchemaObjDependentsCancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="attrSchemaObjDependentsOK"
                    textBinding="BTN_OK@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

