<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleAttrSchemaObjGeneral@reorgDBJobObjectBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizSchemaObjGeneralAttr"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSchemaObjGeneralAttr"/>

          <uix:pageLayout titleBinding="headerAttrSchemaObjGeneral@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="OBJECT_NAME@ReorgBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="selectedName@reorgBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="TYPE@ReorgBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="selectedType@reorgBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="OBJ_ATTR_INSTR@ReorgBundle@servletRequest"/>

              <uix:subTabLayout>

                <uix:subTabs>
                  <uix:subTabBar selectedIndex="0">
                    <uix:contents>
                      <uix:link textBinding="OBJ_ATTR_GENERAL@ReorgBundle@servletRequest"/>
                      <uix:switcher childNameBinding="includeStorageTab@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:link textBinding="OBJ_ATTR_STORAGE@ReorgBundle@servletRequest"
                              onClick="submitForm('wizSchemaObjGeneralAttr', true, {event:'storageTab'})"/>
                        </uix:case>
                      </uix:switcher>
                      <uix:switcher childNameBinding="dependentObjectsAvailable@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:link textBinding="OBJ_ATTR_DEP_OBJS@ReorgBundle@servletRequest"
                              onClick="submitForm('wizSchemaObjGeneralAttr', true, {event:'dependentsTab'})"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:contents>
                  </uix:subTabBar>
                </uix:subTabs>

                <uix:contents>
                  <uix:tableLayout cellSpacing="5" width="100%">
                    <uix:contents>
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:tip>
                            <uix:contents>
                              <uix:styledText styleClass="OraTipText"
                                  textBinding="OBJ_ATTR_GEN_TIP@ReorgBundle@servletRequest"/>
                            </uix:contents>
                          </uix:tip>
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:switcher childNameBinding="includeStorageTab@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:flowLayout>
                                    <uix:contents>
                                      <uix:radioButton
                                          name="selectedTbspcOption"
                                          textBinding="OBJ_ATTR_TBSPC_CURR@ReorgBundle@servletRequest"
                                          selectedValueBinding="selectedTbspcOption@reorgBean@servletRequest"
                                          valueBinding="TABLESPACE_OPT_CURR@reorgBean@servletRequest"/>
                                      <uix:styledText styleClass="OraDataText"
                                          text="("/>
                                      <uix:styledText styleClass="OraDataText"
                                          textBinding="selectedCurr@reorgBean@servletRequest"/>
                                      <uix:styledText styleClass="OraDataText"
                                          text=")"/>
                                    </uix:contents>
                                  </uix:flowLayout>
                                  <uix:flowLayout>
                                    <uix:contents>
                                      <uix:radioButton
                                          name="selectedTbspcOption"
                                          textBinding="OBJ_ATTR_TBSPC_NEW@ReorgBundle@servletRequest"
                                          selectedValueBinding="selectedTbspcOption@reorgBean@servletRequest"
                                          valueBinding="TABLESPACE_OPT_NEW@reorgBean@servletRequest"/>
                                      <uix:styledText
                                          styleClass="OraInstructionText"
                                          labeledNodeId="selectedDest"
                                          textBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                                          rendered="false"/>
                                      <uix:lovInput
                                          id="selectedDest"
                                          name="selectedDest"
                                          columns="40"
                                          searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                                          shortDescBinding="TABLESPACE@ReorgBundle@servletRequest"
                                          textBinding="selectedDest@reorgBean@servletRequest"
                                          destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                                    </uix:contents>
                                  </uix:flowLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:contents>
                  </uix:tableLayout>

                  <uix:switcher childNameBinding="includeIOTAttributes@reorgBean@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="OBJ_ATTR_IOT_ATTRS@ReorgBundle@servletRequest">
                        <uix:contents>
                          <%--
                          <uix:dataScope currentDataBinding="tableIOT@objectBean@servletRequest">
                            <jsp:include page="/database/schema/utilities/iotInclude.jsp" />
                            <uix:ref refID="iotInclude" />
                          </uix:dataScope>
                          --%>
                          <uix:tableLayout width="100%">

                            <uix:labeledFieldLayout>
                              <%--Compress --%>
                              <uix:messagePrompt 
                                  promptBinding="COMPRESS@uixDBObjectBundle@servletRequest"
                                  labeledNodeId="IOTCompress"/>
                              <oem:choice
                                  id="IOTCompress"
                                  name="IOTCompress"
                                  optionsBinding="compressOptions@tableIOT@objectBean@servletRequest"
                                  selectedValueBinding="IOTCompress@tableIOT@objectBean@servletRequest"/>
                              <%-- Mapping Table --%>
                              <uix:checkBox
                                  name="iotMapping"
                                  checkedBinding="iotMapping@reorgBean@servletRequest" 
                                  textBinding="MAPPING_TABLE@uixSchemaBundle@servletRequest" 
                                  renderedBinding="versionEqualOrHigher90@tableIOT@objectBean@servletRequest"/>
                            </uix:labeledFieldLayout>

                            <uix:switcher childNameBinding="depOverflowSegmentAvailable@reorgBean@servletRequest">
                              <uix:case name="true">
                                <%-- Overflow Options --%>
                                <uix:header textBinding="OVERFLOW_OPTIONS@uixDBObjectBundle@servletRequest">
                                  <uix:rowLayout>
                                    <uix:spacer width="20" />
                                    <uix:tableLayout cellSpacing="5" >
                                      <uix:contents>

                                        <%--pctThreshold --%>
                                        <uix:rowLayout>
                                          <uix:cellFormat hAlign="right" vAlign="top">
                                             <uix:messagePrompt
                                                 promptBinding="PERCENT_THRESHOLD@uixDBObjectBundle@servletRequest"
                                                 labeledNodeId="pctThreshold"/>
                                          </uix:cellFormat>
                                          <uix:cellFormat hAlign="left">
                                            <uix:stackLayout>
                                              <uix:textInput
                                                  id="pctThreshold"
                                                  name="pctThreshold" 
                                                  textBinding="pctThreshold@tableIOT@objectBean@servletRequest"
                                                  shortDescBinding="PERCENT_THRESHOLD@uixDBObjectBundle@servletRequest"
                                                  columns="10">
                                                <uix:onSubmitValidater>
                                                  <uix:decimal/>
                                                </uix:onSubmitValidater>
                                              </uix:textInput>
                                              <uix:styledText
                                                  styleClass="OraInlineInfoText" 
                                                  textBinding="PERCENT_THR_HINT@uixDBObjectBundle@servletRequest"/>
                                            </uix:stackLayout>
                                          </uix:cellFormat>
                                        </uix:rowLayout>

                                        <%-- Including Column--%>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat hAlign="right" vAlign="top">
                                              <uix:messagePrompt
                                                  promptBinding="INCLUDING_COLUMN@uixDBObjectBundle@servletRequest"
                                                  labeledNodeId="includingCol"/>
                                            </uix:cellFormat>
                                            <uix:cellFormat hAlign="left">
                                              <uix:stackLayout>
                                                <oem:choice
                                                    id="includingCol"
                                                    name="includingCol" 
                                                    optionsBinding="includingColumns@tableIOT@objectBean@servletRequest" 
                                                    selectedValueBinding="includingCol@tableIOT@objectBean@servletRequest"/>
                                                <uix:styledText
                                                    styleClass="OraInlineInfoText"  
                                                    textBinding="INCLUDING_COLUMN_HINT@uixDBObjectBundle@servletRequest"/>
                                              </uix:stackLayout>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>

                                      </uix:contents>
                                    </uix:tableLayout>
                                  </uix:rowLayout>
                                </uix:header>
                              </uix:case>
                            </uix:switcher>
                          </uix:tableLayout>
                        </uix:contents>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="includeIndexCompress@reorgBean@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="INDEX_OPTIONS@uixIndexBundle@servletRequest">
                        <uix:contents>
                          <uix:rowLayout>
                            <uix:checkBox
                                name="indexCompress"
                                checkedBinding="indexCompress@segmentBean@servletRequest"
                                textBinding="COMPRESS_TEXT@uixIndexBundle@servletRequest"/>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:tableLayout cellSpacing="3">
                              <uix:rowLayout>
                                <uix:cellFormat width="20"/>
                                  <uix:messagePrompt labeledNodeId="PREFIX" promptBinding="PREFIX_LENGTH@uixIndexBundle@servletRequest"/>
                                  <oem:choice
                                      id="PREFIX"
                                      name="prefixLength"
                                      optionsBinding="prefixLengthChoices@segmentBean@servletRequest"
                                      selectedValueBinding="prefixLength@segmentBean@servletRequest"/>
                              </uix:rowLayout>
                            </uix:tableLayout>
                          </uix:rowLayout>
                        </uix:contents>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="depOverflowSegmentAvailable@reorgBean@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="OBJ_ATTR_OVERFLOW_SEG@ReorgBundle@servletRequest">
                        <uix:contents>
                          <oem:table
                              name="depOverflowSegmentTable"
                              dataSourceProp="depOverflowSegmentTable"
                              beanKey="reorgBean"
                              width="100%" 
                              blockSize="10"
                              summaryBinding="OBJ_ATTR_OVERFLOW_SEG@ReorgBundle@servletRequest"
                              formSubmitted="true">
                          </oem:table>
                        </uix:contents>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="depLOBColumnsAvailable@reorgBean@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="OBJ_ATTR_LOB_COLUMNS@ReorgBundle@servletRequest">
                        <uix:contents>
                          <oem:table
                              name="depLOBColumnsTable"
                              dataSourceProp="depLOBColumnsTable"
                              beanKey="reorgBean"
                              width="100%" 
                              blockSize="10"
                              summaryBinding="OBJ_ATTR_LOB_COLUMNS@ReorgBundle@servletRequest"
                              formSubmitted="true">
                          </oem:table>
                        </uix:contents>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="depSubPartitionsAvailable@reorgBean@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="OBJ_ATTR_SUBPARTITIONS@ReorgBundle@servletRequest">
                        <uix:contents>
                          <oem:table
                              name="depSubPartitionsTable"
                              dataSourceProp="depSubPartitionsTable"
                              beanKey="reorgBean"
                              width="100%" 
                              blockSize="10"
                              summaryBinding="OBJ_ATTR_SUBPARTITIONS@ReorgBundle@servletRequest"
                              formSubmitted="true">
                          </oem:table>
                        </uix:contents>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>

                </uix:contents>
              </uix:subTabLayout>

            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="attrSchemaObjGeneralCancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="attrSchemaObjGeneralOK"
                    textBinding="BTN_OK@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

