<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleAttrSchemaObjStorage@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizSchemaObjStorageAttr"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSchemaObjStorageAttr"/>

          <uix:pageLayout titleBinding="headerAttrSchemaObjStorage@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="OBJECT_NAME@ReorgBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="selectedName@reorgBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="TYPE@ReorgBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="selectedType@reorgBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="OBJ_ATTR_INSTR@ReorgBundle@servletRequest"/>
              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar selectedIndex="1">
                    <uix:contents>
                      <uix:link textBinding="OBJ_ATTR_GENERAL@ReorgBundle@servletRequest"
                          onClick="submitForm('wizSchemaObjStorageAttr', true, {event:'generalTab'})"/>
                      <uix:switcher childNameBinding="includeStorageTab@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:link textBinding="OBJ_ATTR_STORAGE@ReorgBundle@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                      <uix:switcher childNameBinding="dependentObjectsAvailable@reorgBean@servletRequest">
                        <uix:case name="true">
                          <uix:link textBinding="OBJ_ATTR_DEP_OBJS@ReorgBundle@servletRequest"
                              onClick="submitForm('wizSchemaObjStorageAttr', true, {event:'dependentsTab'})"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:contents>
                  </uix:subTabBar>
                </uix:subTabs>
                <uix:contents>
                  <uix:dataScope currentDataBinding="segmentBean@servletRequest">
                    <jsp:include page="/database/schema/utilities/storageContextInclude.jsp"/>
                    <uix:ref refID="storageInclude"/>
                  </uix:dataScope>
                </uix:contents>
              </uix:subTabLayout>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="attrSchemaObjStorageCancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="attrSchemaObjStorageOK"
                    textBinding="BTN_OK@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

