<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
  -- The tag order is important here to properly display the wizard
  -- page with the train at the top with repeating buttons, along with
  -- contents that are indented from the edge of the window.
--%> 
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleSelectReorgTypeStep@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <%-- Include body tag so page is slightly indented from edge of window --%>
    <uix:body>
      <uix:contents>

        <db:form
            name="wizSelectReorgTypeStep"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSelectReorgTypeStep"/>

          <uix:pageLayout titleBinding="headerSelectReorgTypeStep@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

            <%-- Put the borderLayout within a tableLayout that has
              -- a spacer row so there is a couple pixels of space
              -- between the content container and the top repeating
              -- buttons
            --%>
            <uix:tableLayout width="100%">
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:spacer height="3"/>
                  </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:borderLayout>
                      <%-- Right side of borderLayout --%>
                      <uix:right>
                        <uix:contentContainer
                            textBinding="OVERVIEW@ReorgBundle@servletRequest"
                            width="280">
                          <uix:contents>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG1@ReorgBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG2@ReorgBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG3@ReorgBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG4@ReorgBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG5@ReorgBundle@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:contentContainer>
                      </uix:right>
                      <%-- Contents of borderLayout --%>
                      <uix:contents>
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText"
                                textBinding="REORG_OBJ_OR_TBSPC@ReorgBundle@servletRequest"/>
                            <uix:styledText styleClass="OraInstructionText"
                                textBinding="SELECT_REORG_TYPE@ReorgBundle@servletRequest"/>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:radioButton
                                    name="newReorgType"
                                    textBinding="SCHEMA_OBJECTS@ReorgBundle@servletRequest"
                                    selectedValueBinding="newReorgType@reorgDBJobObjectBean@servletRequest"
                                    valueBinding="REORG_TYPE_SCHEMA_OBJ@reorgDBJobObjectBean@servletRequest"/>
                                <uix:radioButton
                                    name="newReorgType"
                                    textBinding="SCHEMA@ReorgBundle@servletRequest"
                                    selectedValueBinding="newReorgType@reorgDBJobObjectBean@servletRequest"
                                    valueBinding="REORG_TYPE_SCHEMA@reorgDBJobObjectBean@servletRequest"/>
                                <uix:radioButton
                                    name="newReorgType"
                                    textBinding="TABLESPACE@ReorgBundle@servletRequest"
                                    selectedValueBinding="newReorgType@reorgDBJobObjectBean@servletRequest"
                                    valueBinding="REORG_TYPE_TABLESPACE@reorgDBJobObjectBean@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:borderLayout>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

            <%-- pageButtons within pageLayout provide repeating (top and bottom) buttons --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    minValue="1"
                    maxValueBinding="maxPageSequence@reorgDBJobObjectBean@servletRequest"
                    valueBinding="pageSequence@reorgDBJobObjectBean@servletRequest"
                    formSubmitted="true"
                    formName="wizSelectReorgTypeStep"
                    destinationBinding="reorgDestination@reorgBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

