<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleSelectSchemaObjectsStep@reorgDBJobObjectBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizSelectSchemaObjectsStep"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSelectSchemaObjectsStep"/>

          <uix:pageLayout titleBinding="headerSelectSchemaObjectsStep@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText"
                        textBinding="SELECTED_INSTR@ReorgBundle@servletRequest"/>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:contents>
                        <uix:flowLayout>
                          <uix:rowLayout hAlign="right">
                            <uix:contents>
                              <uix:pageButtonBar>
                                <uix:submitButton
                                    name="event"
                                    value="addSchemaObjects"
                                    textBinding="BTN_ADD@ReorgBundle@servletRequest"/>
                                <uix:submitButton
                                    name="event"
                                    value="setAttributesByType"
                                    textBinding="BTN_SET_ATTR_BY_TYPE@ReorgBundle@servletRequest"/>
                              </uix:pageButtonBar>
                            </uix:contents>
                          </uix:rowLayout>
                        </uix:flowLayout>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <oem:table
                          alternateTextBinding="NO_SCHEMA_OBJS@ReorgBundle@servletRequest"
                          name="selectedTable"
                          dataSourceProp="selectedTable"
                          beanKey="reorgBean"
                          width="100%" 
                          blockSize="10"
                          summaryBinding="SELECTED_OBJECTS@ReorgBundle@servletRequest"
                          formSubmitted="true">
                        <uix:tableSelection>
                          <uix:singleSelection
                              shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                              selectedIndex="0">
                            <uix:pageButtonBar>
                              <uix:submitButton
                                  name="event"
                                  value="setSchemaObjectAttributes"
                                  textBinding="BTN_SET_ATTR@ReorgBundle@servletRequest"/>
                              <uix:submitButton
                                  name="event"
                                  value="removeSchemaObject"
                                  textBinding="BTN_REMOVE@ReorgBundle@servletRequest"/>
                            </uix:pageButtonBar>
                          </uix:singleSelection>
                        </uix:tableSelection>
                      </oem:table>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    minValue="1"
                    maxValue="6"
                    value="2"
                    formSubmitted="true"
                    formName="wizSelectSchemaObjectsStep"
                    destinationBinding="reorgDestination@reorgBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

