<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleSelectTablespaceStep@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form name="wizSelectTablespaceStep"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSelectTablespaceStep"/>

          <uix:pageLayout titleBinding="headerSelectTablespaceStep@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText"
                      textBinding="selectTbspcInstructions@reorgDBJobObjectBean@servletRequest"/>
                  <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest">
                    <uix:labeledFieldLayout labelWidth="10%">
                      <uix:contents>
                        <uix:messagePrompt
                            labeledNodeId="selectTbspcSearchCriteria"
                            promptBinding="SELECT_TBSPC_SEARCH_BY@ReorgBundle@servletRequest"/>
                        <uix:flowLayout>
                          <uix:contents>
                            <uix:textInput
                                id="selectTbspcSearchCriteria"
                                name="selectTbspcSearchCriteria"
                                textBinding="selectTbspcSearchCriteria@reorgBean@servletRequest"/>
                            <uix:submitButton
                                textBinding="BTN_GO@ReorgBundle@servletRequest"
                                name="event"
                                value="changeSelectTbspcSearchCriteria"/>
                          </uix:contents>
                        </uix:flowLayout>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                    <uix:styledText
                        styleClass="OraInlineInfoText" 
                        textBinding="SEARCH_HINT@uixDBObjectBundle@servletRequest"/>
                  </uix:header>
                  <uix:header textBinding="TABLESPACES@uixDBObjectBundle@servletRequest">
                    <oem:table
                        alternateTextBinding="NO_TABLESPACES@ReorgBundle@servletRequest"
                        name="tablespacesTable"
                        dataSourceProp="tablespacesTable"
                        beanKey="reorgBean"
                        width="100%"
                        blockSize="10"
                        summaryBinding="SELECT_A_TBSPC@ReorgBundle@servletRequest"
                        formSubmitted="true">
                      <uix:tableSelection>
                        <uix:singleSelection
                            shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                            selectedIndexBinding="tablespacesTableSelectedIndex@reorgBean@servletRequest">
                          <uix:submitButton
                              name="event"
                              value="setTablespaceAttributes"
                              textBinding="BTN_SET_ATTR@ReorgBundle@servletRequest"/>
                        </uix:singleSelection>
                      </uix:tableSelection>
                    </oem:table>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    minValue="1"
                    maxValueBinding="maxPageSequence@reorgDBJobObjectBean@servletRequest"
                    valueBinding="pageSequence@reorgDBJobObjectBean@servletRequest"
                    formSubmitted="true"
                    formName="wizSelectTablespaceStep"
                    destinationBinding="reorgDestination@reorgBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

