<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleSetAttributesByType@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizSetAttributesByType"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizSetAttributesByType"/>

          <uix:pageLayout titleBinding="headerSetAttributesByType@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="BY_TYPE_TIP@ReorgBundle@servletRequest"/>
              <%--
              <uix:spacer height="10"/>
              <uix:tip>
                <uix:contents>
                  <uix:styledText styleClass="OraTipText"
                      textBinding="BY_TYPE_TIP@ReorgBundle@servletRequest"/>
                </uix:contents>
              </uix:tip>
              --%>
              <uix:header textBinding="BY_TYPE_TABLES@ReorgBundle@servletRequest">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:radioButton
                          name="tablesTablespaceOption"
                          textBinding="BY_TYPE_TBSPC_CURR@ReorgBundle@servletRequest"
                          selectedValueBinding="tablesTablespaceOption@reorgBean@servletRequest"
                          valueBinding="TABLESPACE_OPT_CURR@reorgBean@servletRequest"/>
                      <uix:flowLayout>
                        <uix:contents>
                          <uix:radioButton
                              name="tablesTablespaceOption"
                              textBinding="BY_TYPE_TBSPC_NEW@ReorgBundle@servletRequest"
                              selectedValueBinding="tablesTablespaceOption@reorgBean@servletRequest"
                              valueBinding="TABLESPACE_OPT_NEW@reorgBean@servletRequest"/>
                          <uix:styledText
                              styleClass="OraInstructionText"
                              labeledNodeId="tablesTablespace"
                              textBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                              rendered="false"/>
                          <uix:lovInput
                              id="tablesTablespace"
                              name="tablesTablespace"
                              columns="40"
                              searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                              shortDescBinding="BY_TYPE_TABLES@ReorgBundle@servletRequest"
                              textBinding="tablesTablespace@reorgBean@servletRequest"
                              destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                        </uix:contents>
                      </uix:flowLayout>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
              </uix:header>
              <uix:header textBinding="BY_TYPE_INDEXES@ReorgBundle@servletRequest">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:radioButton
                          name="indexesTablespaceOption"
                          textBinding="BY_TYPE_TBSPC_CURR@ReorgBundle@servletRequest"
                          selectedValueBinding="indexesTablespaceOption@reorgBean@servletRequest"
                          valueBinding="TABLESPACE_OPT_CURR@reorgBean@servletRequest"/>
                      <uix:flowLayout>
                        <uix:contents>
                          <uix:radioButton
                              name="indexesTablespaceOption"
                              textBinding="BY_TYPE_TBSPC_NEW@ReorgBundle@servletRequest"
                              selectedValueBinding="indexesTablespaceOption@reorgBean@servletRequest"
                              valueBinding="TABLESPACE_OPT_NEW@reorgBean@servletRequest"/>
                          <uix:styledText
                              styleClass="OraInstructionText"
                              labeledNodeId="indexesTablespace"
                              textBinding="TABLESPACE_NAME@ReorgBundle@servletRequest"
                              rendered="false"/>
                          <uix:lovInput
                              id="indexesTablespace"
                              name="indexesTablespace"
                              columns="40"
                              searchDescBinding="CLICK_TO_SELECT_TBSPC@ReorgBundle@servletRequest"
                              shortDescBinding="BY_TYPE_INDEXES@ReorgBundle@servletRequest"
                              textBinding="indexesTablespace@reorgBean@servletRequest"
                              destinationBinding="reorgDestinationWithTargetType@reorgBean@servletRequest"/>
                        </uix:contents>
                      </uix:flowLayout>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
              </uix:header>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="setAttributesByTypeCancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="setAttributesByTypeOK"
                    textBinding="BTN_OK@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

