<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="titleAttrTablespace@reorgDBJobObjectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="wizTablespaceAttr"
            method="post"
            destinationBinding="reorgDestination@reorgBean@servletRequest"
            copyParams="target,type,cancelURL,otype,sname,oname">

          <uix:formValue
              name="pageName"
              value="/database/reorg/wizTablespaceAttr"/>

          <uix:pageLayout titleBinding="headerAttrTablespace@reorgDBJobObjectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@reorgDBJobObjectBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="STEP_TYPE@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"
                      disabled="true"/>
                  <uix:link textBinding="STEP_OBJECTS@ReorgBundle@servletRequest"
                      renderedBinding="typeReorganize@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_TABLESPACE@ReorgBundle@servletRequest"
                      renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
                  <uix:link textBinding="STEP_OPTIONS@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="IMPACT_REPORT@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_SCHEDULE@ReorgBundle@servletRequest" disabled="true"/>
                  <uix:link textBinding="STEP_REVIEW@ReorgBundle@servletRequest" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                messageTypeBinding="messageType@servletRequest"
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="targetLabel@reorgBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetName@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="objectLabel@reorgDBJobObjectBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="objectValue@reorgDBJobObjectBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@uixDBObjectBundle@servletRequest"
                      styleClass="OraDataText"
                      textBinding="targetUserName@reorgDBJobObjectBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="REORG_TBSPC_ATTR_INSTR@ReorgBundle@servletRequest"
                  renderedBinding="typeReorgTablespace@reorgDBJobObjectBean@servletRequest"/>
              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="CNVRT_TBSPC_ATTR_INSTR@ReorgBundle@servletRequest"
                  renderedBinding="typeMakeLocal@reorgDBJobObjectBean@servletRequest"/>
              <uix:header textBinding="EXTENT_ALLOC@ReorgBundle@servletRequest">
                <uix:stackLayout>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:radioButton 
                          name="localExtentMgmtType"
                          value="AUTOMATIC"
                          textBinding="AUTOMATIC_ALLOCATION@tablespaceBundle@servletRequest"
                          selectedValueBinding="localExtentMgmtType@reorgBean@servletRequest"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:radioButton 
                          name="localExtentMgmtType"
                          value="UNIFORM"
                          textBinding="UNIFORM_ALLOCATION@tablespaceBundle@servletRequest"
                          selectedValueBinding="localExtentMgmtType@reorgBean@servletRequest"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:spacer width="20"/>
                      <uix:messagePrompt
                          labeledNodeId="uniAllocSize"
                          promptBinding="SIZE_K@uixDBObjectBundle@servletRequest"/>
                      <uix:textInput 
                          id="uniAllocSize"
                          name="uniAllocSize"
                          textBinding="uniAllocSize@reorgBean@servletRequest"
                          columns="15"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:stackLayout>
              </uix:header>
              <uix:header
                  textBinding="SEGMENT_SPACE_MANAGEMENT@tablespaceBundle@servletRequest" >
                <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:radioButton name="autoSegmentSpaceMgmt"
                        value="true"
                        textBinding="AUTOMATIC@tablespaceBundle@servletRequest"
                        selectedValueBinding="autoSegmentSpaceMgmt@reorgBean@servletRequest"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:spacer width="15"/>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="SEGMENT_SPACE_MANAGEMENT_AUTOMATIC_HINT@tablespaceBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:radioButton 
                        name="autoSegmentSpaceMgmt"
                        value="false"
                        textBinding="MANUAL@tablespaceBundle@servletRequest"
                        selectedValueBinding="autoSegmentSpaceMgmt@reorgBean@servletRequest"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:spacer width="15"/>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="SEGMENT_SPACE_MANAGEMENT_MANUAL_HINT@tablespaceBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="attrTablespaceCancel"
                    textBinding="BTN_CANCEL@ReorgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="attrTablespaceOK"
                    textBinding="BTN_OK@ReorgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

