<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

<uix:metaContainer> 
  <uix:head titleBinding="DIFF_REPORT_TITLE@DBConfigBundle@servletRequest"/>
</uix:metaContainer>

  <uix:pageLayout>	
   <%@ include file="/database/global.jspf" %>
     <uix:contents>

	    <db:form 	name="loginForm" method="POST"  
			destinationBinding="reportDiffTableDestination@DBConfigObject@servletRequest"
      copyParams="target,type">
	    <uix:formValue name="pageName"  value="/database/reports/reportDiff"/>
            <uix:contents>

      <uix:header textBinding="DIFF_REPORT_HEADER@DBConfigBundle@servletRequest">

       <uix:stackLayout>
	<uix:contents>


	      <%-- targets names --%>
	      <uix:tableLayout width="100%">
		<uix:rowLayout hAlign="right">
		 <uix:spacer width="15"/>
		 <uix:button	 textBinding="COMPARE_HOST_BUTTON_TEXT@DBConfigBundle@servletRequest"
				 destinationBinding="compareHostDestination@DBConfigObject@servletRequest"/>
		</uix:rowLayout>
	      </uix:tableLayout>

	      <uix:tableLayout width="100%" hAlign="center">
	       <uix:rowLayout>
		<uix:cellFormat hAlign="right">
	        <uix:styledText styleClass="OraInstructionText"
                  				textBinding="firstPrompt@DBConfigObject@servletRequest"/>
		</uix:cellFormat>
	        <uix:spacer width="5"/>
		<uix:cellFormat hAlign="left">
		<uix:link textBinding="firstTargetDisplayName@DBConfigObject@servletRequest"
			  destinationBinding="firstTargetHomeDestination@DBConfigObject@servletRequest" />
	        </uix:cellFormat>

		<uix:cellFormat hAlign="right">
	        <uix:styledText styleClass="OraInstructionText"
				                  textBinding="secondPrompt@DBConfigObject@servletRequest"/>
		</uix:cellFormat>
	        <uix:spacer width="5"/>
		<uix:cellFormat hAlign="left">
		<uix:link textBinding="secondTargetDisplayName@DBConfigObject@servletRequest" 
			  destinationBinding="secondTargetHomeDestination@DBConfigObject@servletRequest"/>
	        </uix:cellFormat>

		<uix:cellFormat>
		</uix:cellFormat>
	       </uix:rowLayout>

	       <uix:rowLayout>
		<uix:cellFormat hAlign="right">
	        <uix:styledText styleClass="OraInstructionText"
				textBinding="HOST_SHORT_PROMPT@DBConfigBundle@servletRequest"/>
		</uix:cellFormat>
	        <uix:spacer width="5"/>
		<uix:cellFormat hAlign="left">
		<uix:link textBinding="firstHostDisplayName@DBConfigObject@servletRequest"
			  destinationBinding="firstHostHomeDestination@DBConfigObject@servletRequest"/>
	        </uix:cellFormat>
		<uix:cellFormat hAlign="right">
	        <uix:styledText styleClass="OraInstructionText"
				textBinding="HOST_SHORT_PROMPT@DBConfigBundle@servletRequest"/>
		</uix:cellFormat>
	        <uix:spacer width="5"/>
		<uix:cellFormat hAlign="left">
		 <uix:link textBinding="secondHostDisplayName@DBConfigObject@servletRequest" 
			   destinationBinding="secondHostHomeDestination@DBConfigObject@servletRequest"/>
		</uix:cellFormat>
	       </uix:rowLayout>
	      </uix:tableLayout>

               <uix:subTabLayout>
                <uix:subTabs>
                 <uix:subTabBar selectedIndexBinding="subTabBarSelectedIndex@DBConfigObject@servletRequest">
			<db:link textBinding="GENERAL_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="generalTabDestination@DBConfigObject@servletRequest" 
          copyParams="target,type"/>
			<db:link textBinding="SGA_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="sgaTabDestination@DBConfigObject@servletRequest" 
          copyParams="target,type"/>
			<db:link textBinding="INIT_PARAMS_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="initParamsTabDestination@DBConfigObject@servletRequest" 
          copyParams="target,type"/>
			<db:link textBinding="TBSP_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="tbspTabDestination@DBConfigObject@servletRequest"
          copyParams="target,type"/>
			<db:link textBinding="DATAFILE_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="datafileTabDestination@DBConfigObject@servletRequest"
          copyParams="target,type"/>
			<db:link textBinding="CONTROLFILE_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="controlfileTabDestination@DBConfigObject@servletRequest"
          copyParams="target,type"/>
			<db:link textBinding="REDO_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="redoTabDestination@DBConfigObject@servletRequest"
          copyParams="target,type"/>
			<db:link textBinding="ROLLBACK_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="rollbackTabDestination@DBConfigObject@servletRequest" 
          copyParams="target,type"/>
                 </uix:subTabBar>
                </uix:subTabs>

        <uix:spacer height="6"/>

	      <uix:tableLayout>
	       <uix:contents>
		<uix:cellFormat>
	        <uix:styledText styleClass="OraInstructionText"
				textBinding="DIFF_FILTER_PROMPT@DBConfigBundle@servletRequest"
				labeledNodeId="options"/>
	        <uix:spacer width="5"/>	
		 <uix:choice 	name="options" id="options"
				selectedValueBinding="selectedValue@DBConfigObject@servletRequest">
		  <uix:option textBinding="FILTER_ALL_OPTION@DBConfigBundle@servletRequest" value="All"/>
		  <uix:option textBinding="FILTER_DIFFERENT_OPTION@DBConfigBundle@servletRequest" 
                  value="Different"/>
		 </uix:choice>
		</uix:cellFormat>
		<uix:cellFormat hAlign="left">
		 <uix:submitButton	textBinding="GO_BUTTON_TEXT@DBConfigBundle@servletRequest"
					name="event"
					value="filter"/>	
		</uix:cellFormat>
		</uix:contents>
	       </uix:tableLayout>
       
	   <oem:table width="100%"
			 blockSize="25"
			 alternateTextBinding="NO_DATA_FOUND@DBConfigBundle@servletRequest"
			 name="reportDiffTable"
			 formSubmitted="true" 
			 dataSourceProp="reportDiffTable"/>

        <uix:spacer height="6"/>


	    </uix:subTabLayout>
	   </uix:contents>
          </uix:stackLayout>

      </uix:header>

      </uix:contents>
     </db:form>
    </uix:contents>	
   </uix:pageLayout> 
 </uix:document> 
</uix:renderingContext> 
