<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

<uix:metaContainer> 
  <uix:head titleBinding="DIFF_REPORT_TITLE@DBConfigBundle@servletRequest"/>
</uix:metaContainer>

  <uix:pageLayout>	
   <%@ include file="/database/global.jspf" %>
     <uix:contents>

	    <db:form name="loginForm" method="POST"  
			destinationBinding="reportDiffTableDestination@DBConfigObject@servletRequest"
      copyParams="target,type">
	    <uix:formValue name="pageName"  value="/database/reports/singleConfig"/>
            <uix:contents>
	    
      <uix:header textBinding="DIFF_REPORT_HEADER@DBConfigBundle@servletRequest">
       <uix:stackLayout>
	<uix:contents>

	      <%-- targets names --%>
	      <uix:tableLayout width="60%">
	       <uix:rowLayout hAlign="left">
		<uix:cellFormat hAlign="right">
	        <uix:styledText styleClass="OraInstructionText"
                  				textBinding="singlePrompt@DBConfigObject@servletRequest"/>
		</uix:cellFormat>
	        <uix:spacer width="5"/>
		<uix:cellFormat hAlign="left">

		<uix:link textBinding="singleTargetDisplayName@DBConfigObject@servletRequest"
			  destinationBinding="singleTargetHomeDestination@DBConfigObject@servletRequest"/>
	        </uix:cellFormat>
	       </uix:rowLayout>
	       <uix:rowLayout hAlign="left">
		<uix:cellFormat hAlign="right">
	        <uix:styledText styleClass="OraInstructionText"
				textBinding="HOST_SHORT_PROMPT@DBConfigBundle@servletRequest"/>
		</uix:cellFormat>
	        <uix:spacer width="5"/>
		<uix:cellFormat hAlign="left">
		<uix:link textBinding="singleHostDisplayName@DBConfigObject@servletRequest"
			  destinationBinding="singleHostHomeDestination@DBConfigObject@servletRequest"/>
	        </uix:cellFormat>
	       </uix:rowLayout>
	      </uix:tableLayout>


               <uix:subTabLayout>
                <uix:subTabs>
                 <uix:subTabBar selectedIndexBinding="subTabBarSelectedIndex@DBConfigObject@servletRequest">
			<db:link textBinding="GENERAL_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="generalTabDestination@DBConfigObject@servletRequest" 
          copyParams="target,type"/>
			<db:link textBinding="SGA_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="sgaTabDestination@DBConfigObject@servletRequest" 
          copyParams="target,type"/>
			<db:link textBinding="INIT_PARAMS_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="initParamsTabDestination@DBConfigObject@servletRequest" 
          copyParams="target,type"/>
			<db:link textBinding="TBSP_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="tbspTabDestination@DBConfigObject@servletRequest"
          copyParams="target,type"/>
			<db:link textBinding="DATAFILE_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="datafileTabDestination@DBConfigObject@servletRequest"
          copyParams="target,type"/>
			<db:link textBinding="CONTROLFILE_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="controlfileTabDestination@DBConfigObject@servletRequest"
          copyParams="target,type"/>
			<db:link textBinding="REDO_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="redoTabDestination@DBConfigObject@servletRequest"
          copyParams="target,type"/>
			<db:link textBinding="ROLLBACK_TAB@DBConfigBundle@servletRequest" 
				  destinationBinding="rollbackTabDestination@DBConfigObject@servletRequest" 
          copyParams="target,type"/>
                 </uix:subTabBar>
                </uix:subTabs>

	      <%-- Single Table --%>
	      <uix:header textBinding="drillDownDiffSubHeader@DBConfigObject@servletRequest">
		<uix:contents>

	      <oem:messageBox errorTableBinding="errors@servletRequest" messageType="error" 
				titleTextKey="titleText" mainTextKey="mainText" />

	      <oem:table width="100%"
			 formSubmitted="true"
			 blockSize="25"
			 alternateTextBinding="NO_DATA_FOUND@DBConfigBundle@servletRequest"
			 name="reportDiffTable" 
			 dataSourceProp="reportDiffTable"/>
		</uix:contents>
	      </uix:header>

	    </uix:subTabLayout>
	   </uix:contents>
          </uix:stackLayout>

      </uix:header>

	</uix:contents>
      </db:form>
    </uix:contents>	
   </uix:pageLayout> 
 </uix:document> 
</uix:renderingContext> 

