<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="arrTypeMsgs" class="oracle.sysman.db.rsc.schm.ArrayTypeMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/arraytype/createArrayTypePage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:subTabLayout>
    
    <%-- START: TAB CONTENTS starts here --%>

                <uix:header textBinding="GENERAL@dbMsgs">
                    <uix:tableLayout cellSpacing="5">
                        <%-- name --%>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt  promptBinding="NAME@dbMsgs" 
                                                  labeledNodeId="objectName"
                                                  required="yes"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:stackLayout>
                                  <uix:textInput id="objectName"
                                                 name="objectName" 
                                                 textBinding="objectName@objectBean@servletRequest" columns="30"/>
                                  <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                              </uix:stackLayout>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        
                        <%-- schema name --%>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:messagePrompt promptBinding="SCHEMA@dbMsgs" 
                                               labeledNodeId="SCHEMA"
                                               required="yes"/>
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:messageLovField name="schemaName"
                                                 id="SCHEMA"
                                                 shortDescBinding="SCHEMA@dbMsgs"
                                                 searchDescBinding="SCHEMA@dbMsgs"
                                                 textBinding="schemaName@objectBean@servletRequest"
                                                 onClick="startLov('schemaName','ListSchema')"/>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <%--- size ---%>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt  promptBinding="SIZE@arrTypeMsgs" 
                                                  labeledNodeId="arrSize"
                                                  required="yes"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:stackLayout>
                                  <uix:textInput id="arrSize"
                                                 name="arrSize" 
                                                 textBinding="arrSize@objectBean@servletRequest" 
                                                 columns="30"/>
                                  <uix:messageText messageBinding="arrSize@errors@servletRequest" messageType="error"/>
                              </uix:stackLayout>
                            </uix:cellFormat>
                        </uix:rowLayout>
            </uix:tableLayout>
            </uix:header>
            <uix:header textBinding="DATATYPE@arrTypeMsgs">
						<uix:tableLayout cellSpacing="5">
               

              <%-- predefined types--%>
                <uix:rowLayout>
                     <oem:radioButton
                    	name="userType" value="false"
                      textBinding="CHOOSE_PREDEF_TYPE@arrTypeMsgs"
                      selectedValueBinding="userType@objectBean@servletRequest"/>
                </uix:rowLayout>

            </uix:tableLayout>
            <uix:tableLayout cellSpacing="5">

              <%-- type name --%>
                <uix:rowLayout>
                    <uix:cellFormat width="20">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                        <uix:messagePrompt labeledNodeId="TYPE" promptBinding="TYPE@arrTypeMsgs"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <oem:choice name="typeName"
                                id="TYPE"
                                selectedValueBinding="typeName@objectBean@servletRequest" 
                                optionsBinding="predefinedTypes@objectBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>

                        <%-- type length --%>
                        <uix:rowLayout>
                            <uix:cellFormat width="20">
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt labeledNodeId="typeLength"
                                                 promptBinding="LENGTH@arrTypeMsgs"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:stackLayout>
                                    <uix:textInput id="typeLength"
                                                   name="typeLength" 
                                                   textBinding="typeLength@objectBean@servletRequest" columns="30"/>
                                    <uix:messageText messageBinding="typeLength@errors@servletRequest" messageType="error"/>
                                    <uix:styledText styleClass="OraInlineInfoText"  textBinding="APPLIES_LENGTH@arrTypeMsgs"/>
                                </uix:stackLayout>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        
                        <%-- precision --%>
                        <uix:rowLayout>
                            <uix:cellFormat width="20">
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt labeledNodeId="typePrecision"
                                                 promptBinding="PRECISION@arrTypeMsgs"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:stackLayout>
                                    <uix:textInput id="typePrecision"
                                                   name="typePrecision" 
                                                   textBinding="typePrecision@objectBean@servletRequest" columns="30"/>
                                    <uix:messageText messageBinding="typePrecision@errors@servletRequest" messageType="error"/>
                                    <uix:styledText styleClass="OraInlineInfoText"  
                                                    textBinding="APPLIES_NUMBER@arrTypeMsgs"/>
                                </uix:stackLayout>
                            </uix:cellFormat>
                        </uix:rowLayout>
         
            </uix:tableLayout>
            <uix:tableLayout cellSpacing="5">

              <%-- user types--%>
                <uix:rowLayout>
                     <oem:radioButton
                    	name="userType" value="true"
                      textBinding="CHOOSE_USER_TYPE@arrTypeMsgs"
                      selectedValueBinding="userType@objectBean@servletRequest"/>
                </uix:rowLayout>

            </uix:tableLayout>
            <uix:tableLayout cellSpacing="5">

              <%-- type name --%>
              <uix:rowLayout>
                <uix:cellFormat width="20"/>
                <uix:cellFormat> 
                  <uix:messagePrompt labeledNodeId="typename" promptBinding="TYPE@arrTypeMsgs"/>
                  <uix:stackLayout>
                    <uix:lovField name="fullObjectName" 
                                  id="typename"
                                  shortDescBinding="TYPE@arrTypeMsgs" 
                                  searchDescBinding="TYPE@arrTypeMsgs" 
                                  textBinding="fullObjectName@objectBean@servletRequest" 
                                  onClick="setSearchFilter('schemaName');startLov('fullObjectName','ListObjecttype')"/>
                    <uix:messageText messageBinding="fullObjectName@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:cellFormat> 
              </uix:rowLayout>

              <%-- ref --%>
              <uix:rowLayout>
                <uix:cellFormat width="20"/>
                <uix:cellFormat> 
                <uix:checkBox name="typeRef" 
                              textBinding="TYPE_REF@arrTypeMsgs"
                              checkedBinding="typeRef@objectBean@servletRequest"/>
                </uix:cellFormat> 
              </uix:rowLayout>

            </uix:tableLayout>
            </uix:header>


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
<%-- END: HTML Form --%>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




