<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/arraytype/editArrayTypePage"/>
<uix:formValue name="schemaName" valueBinding="schemaName@objectBean@servletRequest"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- START: TAB CONTENTS starts here --%>

    <uix:header  textBinding="GENERAL@uixDBObjectBundle@servletRequest" >
            <uix:tableLayout cellSpacing="5">
                <%-- name --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt  promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="objectName@objectBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <%-- schema name --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt  promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="schemaName@objectBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <%--- size ---%>
		            <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
		                <uix:messagePrompt labeledNodeId="arrSize"
                                       promptBinding="SIZE@uixArraytypeBundle@servletRequest" 
                                       required="yes"/>
    		          </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:textInput id="arrSize"
                                   name="arrSize" 
                                   textBinding="arrSize@objectBean@servletRequest" columns="30"/>
                    <uix:messageText  messageBinding="arrSize@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
             		</uix:rowLayout>
              </uix:tableLayout>



             <uix:rowLayout hAlign="right">
                <uix:switcher childNameBinding="areErrors">
                <uix:case name="true">             
                  <uix:rowLayout hAlign="right">
                    <uix:submitButton  textBinding="SHOW_ERRORS@uixDBObjectBundle@servletRequest"
                        name="event" value="showErrors"/>   
                  </uix:rowLayout>
                </uix:case>
                </uix:switcher>
            </uix:rowLayout>


          
          </uix:header>
          <uix:header textBinding="DATATYPE@uixArraytypeBundle@servletRequest">
						<uix:tableLayout cellSpacing="5">

              <%-- predefined types--%>
                <uix:rowLayout>
                     <oem:radioButton 
                    	name="userType" value="false"
                      textBinding="CHOOSE_PREDEF_TYPE@uixArraytypeBundle@servletRequest"
                      selectedValueBinding="userType@objectBean@servletRequest"/>
                </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5">

              <%-- type name --%>
              <uix:rowLayout>
 		            <uix:cellFormat width="0"/>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="TYPE" 
                                     promptBinding="TYPE@uixArraytypeBundle@servletRequest"/>
                </uix:cellFormat>      
                <uix:cellFormat>
                  <oem:choice name="typeName" 
                              id="TYPE"
                              selectedValueBinding="typeName@objectBean@servletRequest" 
                              optionsBinding="predefinedTypes@objectBean@servletRequest"/>                
                </uix:cellFormat>
              </uix:rowLayout>

 	            <%-- type length --%>
              <uix:rowLayout>
 		            <uix:cellFormat width="20"/>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="typeLength"
                                     promptBinding="LENGTH@uixArraytypeBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:stackLayout>
                    <uix:textInput id="typeLength"
                                   name="typeLength" 
                                   textBinding="typeLength@objectBean@servletRequest" columns="30"/>
                    <uix:messageText messageBinding="typeLength@errors@servletRequest" messageType="error"/>
                    <uix:styledText styleClass="OraInlineInfoText" 
                                    textBinding="APPLIES_LENGTH@uixArraytypeBundle@servletRequest"/>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
                
              <%-- precision --%>
              <uix:rowLayout>
 		            <uix:cellFormat width="20"/>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="typePrecision"
                                     promptBinding="PRECISION@uixArraytypeBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:stackLayout>
                    <uix:textInput id="typePrecision"
                                   name="typePrecision" 
                                   textBinding="typePrecision@objectBean@servletRequest" 
                                   columns="30"/>
                    <uix:messageText messageBinding="typePrecision@errors@servletRequest" 
                                     messageType="error"/>
                    <uix:styledText styleClass="OraInlineInfoText" 
                                     textBinding="APPLIES_NUMBER@uixArraytypeBundle@servletRequest"/>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5">
             	<uix:rowLayout>
            	  <uix:spacer height="5"/>
              </uix:rowLayout>

              <%-- user types--%>
              <uix:rowLayout>
                <oem:radioButton
                   name="userType" value="true"
                   textBinding="CHOOSE_USER_TYPE@uixArraytypeBundle@servletRequest"
                   selectedValueBinding="userType@objectBean@servletRequest"/>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5">
             
             <%-- type name --%>
              <uix:rowLayout>
                <uix:cellFormat width="20"/>
                <uix:cellFormat> 
                  <uix:messagePrompt labeledNodeId="type" 
                                     promptBinding="TYPE@uixArraytypeBundle@servletRequest"/>
                  <uix:stackLayout>
                    <uix:switcher childNameBinding="userType@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:lovField name="fullObjectName"
                                      id="type"
                                      shortDescBinding="TYPE@uixArraytypeBundle@servletRequest"
                                      searchDescBinding="TYPE@uixArraytypeBundle@servletRequest"
                                      textBinding="fullObjectName@objectBean@servletRequest" 
                                      onClick="setSearchFilter('schemaName');startLov('fullObjectName','ListObjecttype')"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:lovField name="fullObjectName"
                                      id="type"
                                      shortDescBinding="TYPE@uixArraytypeBundle@servletRequest"
                                      searchDescBinding="TYPE@uixArraytypeBundle@servletRequest"
                                      onClick="setSearchFilter('schemaName');startLov('fullObjectName','ListObjecttype')"/>
                      </uix:case>
                    </uix:switcher>
                    <uix:messageText messageBinding="fullObjectName@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
    
              <%-- ref --%>
              <uix:rowLayout>
 		<uix:cellFormat width="20"/>
                <uix:cellFormat> 
               	 <uix:checkBox name="typeRef" 
                               textBinding="TYPE_REF@uixArraytypeBundle@servletRequest"
                               checkedBinding="typeRef@objectBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            </uix:header>


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
<%-- END: HTML Form --%>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




