<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

  <db:script src="/database/utils.js"/>
  <db:script src="/cabo/jsLibs/TableProxy.js"/> 
  <script>
    function lovSelect(lovField)
    {
      var proxy = new TableProxy('selectUserObjectDataSource');
      var selectedIndex = proxy.getSelectedRow();
      if (selectedIndex >= 0)
      {
        var selectedElement1 = proxy.getFormElement('Schema', selectedIndex);
        var selectedElement2 = proxy.getFormElement('Object', selectedIndex);
        lovField.value = selectedElement1.value + "." + selectedElement2.value;
        window.close();
      }
    }
  </script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="SEARCH_SEL_USER_OBJ@uixDBObjectBundle@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/arraytype/selectUserObjectPage"/>
<uix:pageLayout title="">
      <uix:stackLayout>
        <uix:spacer height="10"/>
        <uix:header textBinding="SEARCH_SEL_USER_OBJ@uixDBObjectBundle@servletRequest">
          <uix:tableLayout cellSpacing="4">
            <uix:rowLayout hAlign="right">
              <%--
              <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              --%>
              
              <uix:cellFormat>
                <uix:button  textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                            destination="javascript:self.close()"/>
                <uix:spacer width="5"/>
                <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest"
                  destination="javascript:lovSelect(window.opener.document.foo.fullObjectName)"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <%--
              <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              <--%>
              <uix:cellFormat>

              <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest"/>
	      <uix:rowLayout>
              <uix:contents>
              <uix:cellFormat width="20">
              </uix:cellFormat>
              <uix:styledText textBinding="SEARCH_INSTRUCTIONS@uixDBObjectBundle@servletRequest"/>
              </uix:contents>
              </uix:rowLayout>
                <uix:tableLayout cellSpacing="4">
                    <uix:contents>


                    <uix:rowLayout hAlign='left'>
                     <uix:contents>
                      <uix:cellFormat width="10">
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                       <uix:contents>
                        <uix:messagePrompt labeledNodeId="destLovSchemaName"
                                           promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                       </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat>
                       <uix:textInput id="destLovSchemaName"
                                      name="destLovSchemaName" 
                                      textBinding="destLovSchemaName@objectBean@servletRequest"/>
                      </uix:cellFormat> 
                        <%-- <oem:choice name="destLovSchemaName"  optionsBinding="destLovSchemaNames@objectBean@servletRequest" selectedValueBinding="destLovSchemaName@objectBean@servletRequest"/> --%>
                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign='left'>
                       <uix:contents>
  <uix:cellFormat width="10">
              </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="selectUserObjectSearchCriteria"
                                               promptBinding="OBJECT_NAME_COLON@uixDBObjectBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:textInput id="selectUserObjectSearchCriteria"
                                       name="selectUserObjectSearchCriteria" 
                                       textBinding="selectUserObjectSearchCriteria@objectBean@servletRequest"/>
                        <uix:submitButton  textBinding="GO@uixDBObjectBundle@servletRequest"
                            name="event" value="changeSelectUserObjectSearchCriteria"/>
                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>

              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>

              <%--
              <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              --%>

              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:header  textBinding="RESULTS@uixDBObjectBundle@servletRequest">
                    <oem:table beanKey="objectBean" 
                               name="selectUserObjectDataSource"
                               blockSize="10"
                               destinationBinding="destination@objectBean@servletRequest" 
                               formSubmitted="true"
                               dataSourceProp="selectUserObjectDataSource" 
                               width="90%"
                               alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                               summaryBinding="SEARCH_SEL_USER_OBJ@uixDBObjectBundle@servletRequest"
                               copyParams="target,type,cancelURL,sname,oname,otype">
                      <uix:tableSelection>
                      <oem:singleSelection shortDescBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest"                                            selectedIndex="0"/>
                      </uix:tableSelection>
                    </oem:table>
                  </uix:header>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
        <uix:contentFooter>
          <uix:pageButtonBar>
            <uix:button  textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                destination="javascript:self.close()"/>
            <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" 
                destination="javascript:lovSelect(window.opener.document.foo.fullObjectName)"/>
          </uix:pageButtonBar>
        </uix:contentFooter>
      </uix:stackLayout>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




