<%--
  -- Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
  -- All rights reserved. 
  -- Name:        compressOptionsInclude.jsp
  -- Type:        JSP Include 
  -- Description: This include page contains the complete UI for compression options.
  --             
  -- JSP Changes: To use this page, add the following to your jsp file:
  -- 
  --  <uix:dataScope currentDataBinding="<your segment bean>@servletRequest">
  --    <jsp:include page="/database/schema/compressOptionsInclude.jsp" />
  --    <uix:ref refID="compressInclude" />
  --  </uix:dataScope>
  --  MODIFIED    (MM/DD/YY)
  --   chanchan    07/09/09 - Support new compression GUI (ER bug #8669360)
  --   chanchan    05/01/09 - Add columnar compression supports (ER bug #8276145)
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:buildTree nodeID="compressInclude">
  <uix:dataScope>
    <%-- Message Bundles Used --%>
    <uix:bundle name="msgs" class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
    <uix:bundle name="tableMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>

    <%-- OPTIONS --%>
    <uix:header textBinding="COMPRESSION_OPTION@msgs" renderedBinding="compressAvailable@">
      <uix:tableLayout cellSpacing="5" hAlign="left" width="100%">
            <%-- COMPRESS OPTION --%>
            <uix:rowLayout renderedBinding="compressAvailable@">
              <uix:cellFormat vAlign="top" hAlign="left" columnSpan="2">
                <uix:messagePrompt promptBinding="COMPRESSION_INST@msgs"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout renderedBinding="compressAvailable@">
              <uix:cellFormat vAlign="top" hAlign="right" width="5%" wrappingDisabled="true">
                <uix:messagePrompt promptBinding="COMPRESSION@msgs"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="*%">
                <uix:stackLayout>
		 <uix:switcher childNameBinding="showCompressDefault@">
                  <uix:case name="true"> 
                  <oem:radioButton name="compress" 
                                   value="<%= TableConst.COMPRESSION_OPTION_DEFAULT %>" 
                                   textBinding="DEFAULT_OPT@msgs"
                                   selectedValueBinding="compress@"
                                   disabledBinding="compressDisabled@"/>
                  </uix:case> 
		 </uix:switcher>		  
                 <uix:rowLayout renderedBinding="showCompressDefault@">
                   <uix:spacer width="21"/>
		   <uix:switcher childNameBinding="showPartitionCompressDefault@">
                     <uix:case name="true"> 
                       <uix:styledText styleClass="OraInlineInfoText" textBinding="TABLE_COMPRESS_DEF@msgs"/>
                     </uix:case> 
                     <uix:case name="false"> 
                       <uix:styledText styleClass="OraInlineInfoText" textBinding="TABLE_COMPRESS_HINT@msgs"/>
                     </uix:case> 
		    </uix:switcher>		  
                  </uix:rowLayout>
                  <oem:radioButton name="compress" 
                                   value="<%= TableConst.COMPRESSION_OPTION_DISABLED %>" 
                                   textBinding="NO_COMPRESSION@tableMsgs"
                                   selectedValueBinding="compress@"
                                   disabledBinding="compressDisabled@"/>
                  <oem:radioButton name="compress" 
                                   value="<%= TableConst.COMPRESSION_OPTION_ENABLED_DIRECT %>"
                                   textBinding="BASIC_COMPRESSION@tableMsgs"
                                   selectedValueBinding="compress@"
                                   disabledBinding="compressDisabled@"/>
            	  <uix:rowLayout>
                    <uix:spacer width="21"/>
          	    <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_BASIC_COMPRESSION@tableMsgs"/>
                  </uix:rowLayout>

                  <oem:radioButton name="compress" 
                                   value="<%= TableConst.COMPRESSION_OPTION_ENABLED_ALL %>" 
                                   textBinding="OLTP_COMPRESSION@tableMsgs"
                                   selectedValueBinding="compress@"
                                   disabledBinding="compressDisabled@"
				   renderedBinding="advancedCompressionEnabled@" />
            	  <uix:rowLayout renderedBinding="advancedCompressionEnabled@">
                    <uix:spacer width="21"/>
          	    <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_OLTP_COMPRESSION@tableMsgs"/>
                  </uix:rowLayout>

                  <oem:radioButton name="compress" 
                                   value="<%= TableConst.COMPRESSION_OPTION_QUERY_HIGH %>"
                                   textBinding="DATA_WAREHOUSE_COMPRESSION@tableMsgs"
                                   selectedValueBinding="compress@"
				   renderedBinding="hybridColumnarCompressionEnabled@"/>
            	  <uix:rowLayout renderedBinding="hybridColumnarCompressionEnabled@">
                    <uix:spacer width="21"/>
          	    <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_DATA_WAREHOUSE_COMPRESSION@tableMsgs"/>
                  </uix:rowLayout>

                  <oem:radioButton name="compress" 
                                   value="<%= TableConst.COMPRESSION_OPTION_ARCHIVE %>"
                                   textBinding="ARCHIVE_COMPRESSION@tableMsgs"
                                   selectedValueBinding="compress@"
				   renderedBinding="hybridColumnarCompressionEnabled@"/>
            	  <uix:rowLayout renderedBinding="hybridColumnarCompressionEnabled@">
                    <uix:spacer width="21"/>
          	    <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_ARCHIVE_COMPRESSION@tableMsgs"/>
                  </uix:rowLayout>

            	  <uix:rowLayout renderedBinding="hybridColumnarCompressionEnabled@">
                    <uix:spacer width="6"/>
 		    <uix:tip>
	              <uix:styledText styleClass="OraTipText" textBinding="TIP_COMPRESSION_ADVICE@tableMsgs" />
		    </uix:tip>
                  </uix:rowLayout>

                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout renderedBinding="showCompressMoveTable@">
              <uix:cellFormat vAlign="top" hAlign="left" columnSpan="2">
      		<uix:tableLayout>
         	  <uix:rowLayout>
              	    <uix:cellFormat vAlign="top" hAlign="left" columnSpan="2">
		      <uix:checkBox name="<%= TableConst.COMPRESS_MOVE_TABLE %>"
                	   textBinding="MOVE_TABLE@tableMsgs"
                     	   checkedBinding="compressMoveTable@" />
	            </uix:cellFormat>
       		  </uix:rowLayout>
       		  <uix:rowLayout>
              	    <uix:cellFormat vAlign="top" hAlign="left">
		      <uix:spacer width="22" height="1" />
	            </uix:cellFormat>
              	    <uix:cellFormat vAlign="top" hAlign="left">
		      <uix:styledText styleClass="OraInlineInfoText" textBinding="HINT_MOVE_TABLE@tableMsgs"/>
	            </uix:cellFormat>
       		  </uix:rowLayout>
	      </uix:tableLayout>
            </uix:cellFormat>
          </uix:rowLayout>

      </uix:tableLayout>
    </uix:header>

  </uix:dataScope>
</uix:buildTree>
