<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       dataBrowsingOptionPage.jsp
  -- Controller: db/adm/schm/DisplayContentsController.java
  --
  -- Description: For the View Data dropdown option (in context of 
  --              a schema object), there is a refine query button.
  --              This is the JSP for the Refine Query page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.DisplayContentsObject"/>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>


<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<db:form name="optionForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/dataBrowsingOptionPage"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

      <%-- Oracle Logo and Tabs --%>
      <%@ include file="/database/global.jspf" %>

       <%-- Warning/Error display --%>
       <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>

       <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" 
                       titleTextKey="titleText" mainTextKey="mainText"/>


          <uix:tableLayout cellSpacing="3" hAlign="center"> 
            <uix:spacer height="10"/>

            <%-- tip --%>
            <uix:rowLayout renderedBinding="needTipForOption@objectBean@servletRequest">
              <uix:tip textBinding="tip@objectBean@servletRequest"/>
              <uix:spacer height="15"/>
            </uix:rowLayout>

            <!-- OPTION RADIO BUTTONS -->
            <uix:rowLayout>
                <oem:radioButton name="displayOption" 
                                 textBinding="DISPLAY_ALL_ROWS_OPTION@uixDBObjectBundle@servletRequest"
                                 value="0" selectedValueBinding="displayOption@objectBean@servletRequest"/>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:switcher childNameBinding="applyWhereKeyword@objectBean@servletRequest">
                <uix:case name="true">
                  <oem:radioButton name="displayOption" 
                                   textBinding="REFINE_QUERY_OPTION@uixDBObjectBundle@servletRequest"
                                   value="1" selectedValueBinding="displayOption@objectBean@servletRequest"/>
                </uix:case> 
                <uix:case name="false">
                  <oem:radioButton name="displayOption" 
                                   textBinding="REFINE_QUERY_CONDITION_OPTION@uixDBObjectBundle@servletRequest"
                                   value="1" selectedValueBinding="displayOption@objectBean@servletRequest"/>
                </uix:case> 
              </uix:switcher> 
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:tableLayout cellSpacing="5">

                <uix:rowLayout>
                  <uix:cellFormat width="30"/>
                <uix:cellFormat hAlign="right" vAlign="top" width="100">
                  <uix:messagePrompt promptBinding="SELECT_COLUMNS@uixDBObjectBundle@servletRequest"/>
                </uix:cellFormat> 
                <uix:spacer width="8"/> 
                  <%--oem:shuttle name="tableColumns" leadingHeader="Available Columns"--%>
                  <oem:shuttle name="tableColumns" 
                               leadingHeaderBinding="AVAILABLE_COLUMNS@uixDBObjectBundle@servletRequest"
                               trailingHeaderBinding="SELECTED_COLUMNS@uixDBObjectBundle@servletRequest" 
                               size="5" reorderable="true">
                    <uix:leading>
                      <oem:list name="availableColumns" shortDescBinding="AVAILABLE_COLUMNS@uixDBObjectBundle@servletRequest" optionsBinding="availableColumns@objectBean@servletRequest"
                                multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list name="filterColumns" shortDescBinding="SELECTED_COLUMNS@uixDBObjectBundle@servletRequest" optionsBinding="filterColumns@objectBean@servletRequest"
                                multiple="true"/>
                    </uix:trailing>
                  </oem:shuttle>
              </uix:rowLayout>


              <uix:rowLayout>
                  <uix:cellFormat width="30"/>
                <uix:cellFormat hAlign="right" vAlign="top" width="100">
                  <uix:switcher childNameBinding="applyWhereKeyword@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:messagePrompt promptBinding="WHERE_CLAUSE@uixDBObjectBundle@servletRequest"/>
                    </uix:case> 
                    <uix:case name="false">
                      <uix:messagePrompt promptBinding="CONDITION_CLAUSE@uixDBObjectBundle@servletRequest"/>
                    </uix:case> 
                  </uix:switcher> 
                </uix:cellFormat> 
                <uix:spacer width="8"/> 
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:spacer height="5"/>
                    </uix:rowLayout>
 
                    <uix:rowLayout>
                    <uix:textInput name="whereClause" rows="10" columns="65"
				   shortDescBinding="WHERE_CLAUSE@uixDBObjectBundle@servletRequest"
                                   textBinding="whereClause@objectBean@servletRequest"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:switcher childNameBinding="applyWhereKeyword@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:tip textBinding="WHERE_CLAUSE_TIP@uixDBObjectBundle@servletRequest"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:tip textBinding="CONDITION_CLAUSE_TIP@uixDBObjectBundle@servletRequest"/>
                        </uix:case>
                      </uix:switcher> 
                    </uix:rowLayout>
 
                  </uix:tableLayout>
              </uix:rowLayout>

            </uix:tableLayout>
          </uix:rowLayout>

          </uix:tableLayout>

          <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                              name="event" value="cancel"/>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"
                              name="event" value="displayOnOptions"/>
          </uix:pageButtonBar>
          </uix:pageButtons>

       </uix:pageLayout>

  </db:form>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>

