<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.dblink.DbLink"/>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="createForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/dblink/createDbLinkPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>

    <%-- START: TAB CONTENTS starts here --%>

    <%-- general section --%>
            <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">
           
            <uix:tableLayout cellSpacing="5" >
                <%-- name --%>
                <uix:rowLayout vAlign="center">
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                        <uix:messagePrompt labeledNodeId="objectName"
                                           promptBinding="NAME@uixDBObjectBundle@servletRequest"  
                                           required="yes"/>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="left" wrappingDisabled="true">
                      <uix:stackLayout>
                          <uix:textInput id="objectName"
                                         name="objectName" 
                                         textBinding="objectName@objectBean@servletRequest" 
                                         columns="60" 
                                         disabledBinding="editing@objectBean@servletRequest"/>
                          <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/> 
                      </uix:stackLayout>
                    </uix:cellFormat>

                </uix:rowLayout>

             <%-- service name --%> 
                <uix:rowLayout vAlign="center">

                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:messagePrompt labeledNodeId="serviceName"
                                         promptBinding="DBLINK_NET_SERVICE_NAME@uixDbLinkBundle@servletRequest" 
                                         required="yes"/>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="left" wrappingDisabled="true">
                         <uix:stackLayout>
                           <uix:textInput id="serviceName"
                                          name="serviceName" 
                                          textBinding="serviceName@objectBean@servletRequest" 
                                          columns="60" 
                                          disabledBinding="editing@objectBean@servletRequest"/> 
                           <uix:messageText messageBinding="serviceName@errors@servletRequest" messageType="error"/> 
                         </uix:stackLayout>
                    </uix:cellFormat>

                    <%-- test button --%>
                    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                      <uix:case name="false">
                        <uix:spacer width="10"/>
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:submitButton textBinding="TEST@uixDbLinkBundle@servletRequest" 
                                            name="event" value="test"/>
                        </uix:cellFormat>
                      </uix:case> 
                    </uix:switcher>


                </uix:rowLayout>

            </uix:tableLayout>

            <%-- is public link ? --%> 
            <uix:checkBox name="isPublic"  checkedBinding="isPublic@objectBean@servletRequest" 
                                           textBinding="PUBLIC_TEXT@uixDbLinkBundle@servletRequest"  
                                           disabledBinding="editing@objectBean@servletRequest" />
            </uix:header>


            <%-- Connect to  --%>
            <uix:header textBinding="CONNECT_AS@uixDbLinkBundle@servletRequest">

                <%-- Connected User --%>
                <uix:stackLayout>
                  <uix:radioButton name="connectTo" value="connectedUser"  
                                   selectedValueBinding="connectTo@objectBean@servletRequest" 
                                   textBinding="CONNECTED_USER@uixDbLinkBundle@servletRequest"  
                                   disabledBinding="editing@objectBean@servletRequest" />
                  <uix:radioButton name="connectTo" value="currentUser"  
                                   selectedValueBinding="connectTo@objectBean@servletRequest" 
                                   textBinding="CURRENT_USER@uixDbLinkBundle@servletRequest"  
                                   disabledBinding="editing@objectBean@servletRequest"/>
                  <uix:radioButton name="connectTo" value="fixedUser"  
                                   selectedValueBinding="connectTo@objectBean@servletRequest" 
                                   textBinding="FIXED_USER@uixDbLinkBundle@servletRequest"  
                                   disabledBinding="editing@objectBean@servletRequest"/>
                </uix:stackLayout>
                <%-- fixed user credential --%>
               <uix:tableLayout cellSpacing="5" >

                  <uix:rowLayout vAlign = "center">
                    <uix:cellFormat  hAlign="right" wrappingDisabled="true">
                      <uix:spacer width="20" height="1"/>
                      <uix:messagePrompt labeledNodeId="username"
                                         promptBinding="USERNAME@uixDbLinkBundle@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat  hAlign="left"  wrappingDisabled="true">
                      <uix:stackLayout>
                        <uix:textInput id="username"
                                       name="username" 
                                       textBinding="username@objectBean@servletRequest" 
                                       columns="30"  
                                       noAutoComplete="true"
                                       disabledBinding="editing@objectBean@servletRequest"/>
                         <uix:messageText messageBinding="username@errors@servletRequest" messageType="error"/> 
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:switcher childNameBinding="showPwd@objectBean@servletRequest"> 
                    <uix:case name="true"> 
                      <uix:rowLayout vAlign="center">
                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                           <uix:spacer width="20" height="1"/>
                           <uix:messagePrompt labeledNodeId="pwd"
                                              promptBinding="PASSWORD@uixDbLinkBundle@servletRequest"/>
                        </uix:cellFormat>
                      
                        <uix:cellFormat  hAlign="left"  wrappingDisabled="true">
                          <uix:stackLayout>
                             <uix:textInput id="pwd"
                                            name="pwd" 
                                            secret="true"
                                            textBinding="secretPassword@objectBean@servletRequest"
                                            columns="30" 
                                            noAutoComplete="true"
                                            disabledBinding="editing@objectBean@servletRequest"/>
                             <uix:messageText messageBinding="password@errors@servletRequest" messageType="error"/> 
                          </uix:stackLayout>
  
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case> 
                  </uix:switcher> 

                  <uix:switcher childNameBinding="showPwd@objectBean@servletRequest"> 
                    <uix:case name="true"> 
                       <uix:rowLayout vAlign = "center"> 
                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                           <uix:spacer width="20" height="1"/>
                           <uix:messagePrompt labeledNodeId="confirmPassword"
                                              promptBinding="CONFIRM_PASSWORD@uixDbLinkBundle@servletRequest"/>
                        </uix:cellFormat>
                        
                        <uix:cellFormat  hAlign="left"  wrappingDisabled="true">
                          <uix:stackLayout>
                             <uix:textInput id="confirmPassword"
                                            name="confirmPassword" 
                                            secret="true" 
                                            textBinding="secretConfirmPassword@objectBean@servletRequest" 
                                            columns="30"  
                                            noAutoComplete="true"
                                            disabledBinding="editing@objectBean@servletRequest"/>
                             <uix:messageText messageBinding="confirmPassword@errors@servletRequest" messageType="error"/> 
                          </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case> 
                  </uix:switcher> 
              </uix:tableLayout>
            </uix:header>

    <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




