<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post" 
         destination="/console/database/schema/dbLink"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/dblink//viewDbLinkPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest"> 


  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>

    <%-- START: TAB CONTENTS starts here --%>

     <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">
            <uix:tableLayout cellSpacing="5">
                <%-- name --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText" textBinding="objectName@objectBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>

                <%-- dblink service name --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                        <uix:messagePrompt promptBinding="DBLINK_NET_SERVICE_NAME@uixDbLinkBundle@servletRequest"/>
                    </uix:cellFormat>
                   <uix:cellFormat hAlign="left">
                     <uix:flowLayout>
                       <uix:styledText styleClass="OraDataText" 
                                       textBinding="serviceName@objectBean@servletRequest"/>
                       <uix:spacer width="10"/>

                       <%-- test button --%>
                       <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                         <uix:case name="false">
                           <uix:submitButton textBinding="TEST@uixDbLinkBundle@servletRequest" 
                                             name="event" value="test"/>
                         </uix:case>
                       </uix:switcher>
                     </uix:flowLayout>
                   </uix:cellFormat>
                </uix:rowLayout>

                <%-- schema name --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                        <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>

            </uix:tableLayout>
            </uix:header>
            <uix:spacer height="5"/>           
            <uix:header textBinding="CONNECT_AS@uixDbLinkBundle@servletRequest">
            <uix:tableLayout cellSpacing="5">
                <%-- connect user  --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                        <uix:messagePrompt promptBinding="USER@uixDbLinkBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="connectToText@objectBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>

                
            </uix:tableLayout>
          </uix:header>

    <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
      <uix:case name="false">
       <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
       <uix:ref refID="pageButtonViewInclude" />
      </uix:case>
      <uix:case name="true">
        <%-- OK Button --%>
       <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
      </uix:case>
    </uix:switcher>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




