<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       displayContentsPage.jsp
  -- Controller: db/adm/schm/DisplayContentsController.java
  --
  -- Description: This is the results page for the View Data dropdown option
  --              (launched in context of a schema object).
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.DisplayContentsObject"/>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>


<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<uix:body>

<db:form name="dataBrowserForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype"> 
<uix:formValue name="pageName" value="/database/schema/displayContentsPage"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

    <uix:tableLayout width="100%" cellSpacing="5"> 

      <%-- SQL --%>
      <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="right" vAlign="top" width="80">
        <uix:messagePrompt labeledNodeId="SQL" promptBinding="QUERY@uixDBObjectBundle@servletRequest"/>
        </uix:cellFormat> 
        <uix:textInput id="SQL" name="sql" textBinding="sql@objectBean@servletRequest" 
                       columns="80" rows="5" readOnly="true"
                       shortDescBinding="QUERY@uixDBObjectBundle@servletRequest"/>
      </uix:rowLayout>

      <%-- Result Table --%>
      <uix:rowLayout width="100%"> 
        <uix:cellFormat hAlign="right" vAlign="top" width="80">
        <uix:messagePrompt promptBinding="RESULT@uixDBObjectBundle@servletRequest"/>
        </uix:cellFormat> 
          <oem:table name="tableViewDataBrowingUIDS" dataSourceProp="tableViewDataBrowingUIDS"
                     destinationBinding="destination@objectBean@servletRequest"
                     formSubmitted="true" width="100%" blockSize="25"
                     summaryBinding="RESULT@uixDBObjectBundle@servletRequest"
                     showAll="yes"
                     copyParams="target,type,cancelURL,sname,oname,otype" >
          </oem:table>
      </uix:rowLayout>

      <%-- tip --%>
      <uix:rowLayout renderedBinding="needTip@objectBean@servletRequest">
        <uix:spacer height="10"/>
        <uix:tip textBinding="tip@objectBean@servletRequest"/>
      </uix:rowLayout>

    </uix:tableLayout>

    <uix:pageButtons>
      <uix:pageButtonBar>
        <uix:submitButton textBinding="REFINE_QUERY@uixDBObjectBundle@servletRequest"
                          name="event" value="refineQuery"/>
        <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                          name="event" value="cancel"/>
      </uix:pageButtonBar>
    </uix:pageButtons>

  </uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>

