<%@ include file="/sdk/oemTop.jspf" %>

<%--
  -- Page:       grantPrivileges.jsp
  -- Controller: db/adm/schm/GrantObjPrivsController.java
  --
  -- Description: This is Grant Privileges page, from the drop down menu.
  --              (launched in context of a schema object).
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ include file="/oemNoscript.jspf" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.GrantObjectPrivs"/>


<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
  <db:script src="/database/utils.js"/>   
</uix:metaContainer>

  <uix:body>

    <db:form name="grantPrivsForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype" >

    <uix:formValue name="pageName" value="/database/schema/grantPrivileges"/>
      <uix:pageLayout titleBinding="title@objectBean@servletRequest">

      <%-- Oracle Logo and Tabs --%>
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:tableLayout> 
              <%-- Grant Privileges --%>
              <uix:tableLayout> 
                <uix:tableLayout width="80%">
                <uix:rowLayout>
                  <uix:header textBinding="AVAIL_PRIVS_HEADER@uixDBObjectBundle@servletRequest">
                    <oem:table name="availPrivsTableUI" dataSourceProp="availPrivsTableUI"
                               width="100%"
                               destinationBinding="destination@objectBean@servletRequest"
                               formSubmitted="true"
                               alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                               summaryBinding="AVAIL_PRIVS_HEADER@uixDBObjectBundle@servletRequest"
                               copyParams="target,type,cancelURL,sname,oname,otype">
                       <uix:tableSelection>
                         <uix:multipleSelection selectionBinding="privsSelection@objectBean@servletRequest"
                                                shortDescBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest"
                                                selectedBinding="selected"/>
                       </uix:tableSelection>
                     </oem:table>
                     <uix:messageText messageBinding="availPrivsTableUI@errors@servletRequest"
                                      messageType="error"/>
                   </uix:header>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer height="1"/>
              </uix:rowLayout>

              <uix:rowLayout>

                  <uix:header textBinding="GRANT_TO_HEADER@uixDBObjectBundle@servletRequest">
                      <uix:tableLayout cellSpacing="5">
                        <uix:stackLayout>
                          <uix:rowLayout>
                            <uix:messagePrompt labeledNodeId="GRANTEE" promptBinding="SEARCH_FOR@uixDBObjectBundle@servletRequest"/>
                            <uix:cellFormat>
                              <uix:spacer width="5"/>
                            </uix:cellFormat>
                            <oem:choice name="granteeType"
                                        shortDescBinding="SEARCH_FOR@uixDBObjectBundle@servletRequest"
                                        selectedValueBinding="granteeType@objectBean@servletRequest"
                                        optionsBinding="granteeTypes@objectBean@servletRequest"/>
                            <uix:spacer width="5"/>
                            <uix:textInput name="searchKey" 
                                        id="GRANTEE"
                                           columns="16" 
                                           text="%" 
                                           textBinding="searchKey@objectBean@servletRequest"
                                           shortDescBinding="SEARCH_FOR@uixDBObjectBundle@servletRequest"/>
                            <uix:spacer width="5"/>
                            <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest"
                                              name="event" value="searchUserRole"/>
                          </uix:rowLayout>
                        </uix:stackLayout>

                    <uix:rowLayout>
                      <uix:spacer height="5"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:stackLayout>
                        <oem:table name="availGranteesTableUI"  dataSourceProp="availGranteesTableUI"
                                   blockSize="10" width="100%" formSubmitted="true"
                                   destinationBinding="destination@objectBean@servletRequest"
                                   alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                                   summaryBinding="GRANT_TO_HEADER@uixDBObjectBundle@servletRequest"
                                   copyParams="target,type,cancelURL,sname,oname,otype">
                          <uix:tableSelection>
                            <uix:multipleSelection selectionBinding = "granteesSelection@objectBean@servletRequest"
                                                   shortDescBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest"
                                                   selectedBinding = "selected"/>
                          </uix:tableSelection>
                        </oem:table>
                        <uix:messageText messageBinding="availGranteesTableUI@errors@servletRequest"
                                         messageType="error"/>
                      </uix:stackLayout>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:tip>
                        <uix:styledText styleClass="OraTipText"
                                        textBinding="tableRowSelectionTip@objectBean@servletRequest" />
                      </uix:tip>
                    </uix:rowLayout>

                    <uix:rowLayout>
                    <uix:spacer height="5"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:stackLayout>
                        <uix:checkBox name="grantOption" checkedBinding="grantOption@objectBean@servletRequest"
                                      textBinding="GRANT_OPTION@uixDBObjectBundle@servletRequest"/>
                        <uix:messageText messageBinding="grantOption@errors@servletRequest"
                                        messageType="error"/>
                     </uix:stackLayout>
                   </uix:rowLayout>
                 </uix:tableLayout> 
               </uix:header>
             </uix:rowLayout>
           </uix:tableLayout>
           </uix:tableLayout>
           <%-- END: Grant Privileges --%>
         </uix:tableLayout>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          destinationBinding="cancelURL@servletRequest"/>
        <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"
                          name="event"
                          value="doneGrantPriv"/>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:pageButtonBar>
  </uix:pageButtons>

       </uix:pageLayout>
     </db:form>

  </uix:body>
</uix:document>
</uix:renderingContext>

