<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        createSpatialPage.jsp
  -- Controller:  db/adm/schm/IndexController.java
  --
  -- Description: The Spatial Tab for Index. 
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<jsp:useBean id="spatialBean" scope="request"
   type="oracle.sysman.emo.adm.schema.index.IndexSpatial"/>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.index.Index"/>   
   
   <db:script  src="/database/LOV.js"/>
 
<uix:renderingContext id="renderingContext">  
<uix:bundle name="sptlMsgs" class="oracle.sysman.db.rsc.sptl.SpatialMsg"/>   
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
  
  
  <%-- HTML Page Title --%>
  <uix:metaContainer>     
     <uix:head titleBinding="title@objectBean@servletRequest"/>
  </uix:metaContainer>
  
  <uix:body>
  <%-- HTML Form --%>  
    <db:form name="indexForm" 
             method="post"
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/schema/index/createSpatialPage"/>
    <uix:formValue name="value" />     
    <uix:formValue name="source" />   

    
    <uix:pageLayout titleBinding="header@objectBean@servletRequest">
  
    <%-- Oracle Logo and Tabs --%>
    <%@ include file="/database/global.jspf" %>
      
    <%-- Warning/Error display --%>
	
      <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
					  
      <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
					  
                   
    <%-- Create/Edit/View Header --%>
    <uix:subTabLayout>
      <%-- SubTabs --%>
      <uix:subTabs>
         <jsp:include page="/database/schema/index/subTabsInclude.jsp" />
        <uix:ref refID="indexSubTabsInclude" />
      </uix:subTabs>               
      
      <%-- Added by Rajesh --%>
	<uix:tableLayout cellSpacing="5">
	 <uix:rowLayout>
	  <uix:cellFormat hAlign="left" width="50%" vAlign="top">
	  	<uix:rowLayout>
         	<uix:spacer height="10" width="10"/>
      	</uix:rowLayout>
		
      <uix:tableLayout cellSpacing="3">
	  
	
<uix:rowLayout>
         	<uix:spacer height="10" width="10"/>
      	</uix:rowLayout>
		
	<%-- This is for Number of Dimensions (SDO_INDX_DIMS) --%>
		
		<uix:switcher childNameBinding="geodetic@spatialBean@servletRequest" defaultCase="true">
	    	<uix:case name="false">
			
			<uix:rowLayout renderedBinding="noOfDimensionGreater2@spatialBean@servletRequest">
				<uix:cellFormat hAlign="right">
		   			<uix:styledText styleClass="OraInstructionText" textBinding="SPATIAL_NO_DIMS_TO_INDEX@uixDBObjectBundle@servletRequest"/>
		   			
				</uix:cellFormat> 
				
		  		<uix:cellFormat>
		    		<uix:choice name="noOfDimensions" id="noOfDimensions"
				   		selectedValueBinding="noOfDimensions@spatialBean@servletRequest"
				   		shortDescBinding="SPATIAL_NO_DIMS_TO_INDEX@uixDBObjectBundle@servletRequest"
						required="yes">
			 		<uix:contents childDataBinding="noOfDimensionsList@spatialBean@servletRequest">
			  			<uix:option textBinding="textKey" valueBinding="valueKey"/>
			 		
					</uix:contents> 
		    		</uix:choice> 
		  		</uix:cellFormat>
			</uix:rowLayout>
			</uix:case>
	   
	   		<uix:case name="true"> 
			
				<uix:rowLayout renderedBinding="noOfDimensionGreater2@spatialBean@servletRequest">
				<uix:cellFormat hAlign="right">
		   			<uix:styledText styleClass="OraInstructionText" textBinding="SPATIAL_NO_DIMS_TO_INDEX@uixDBObjectBundle@servletRequest"/>
		   			
				</uix:cellFormat>
				
   				<uix:cellFormat>
        			<uix:styledText styleClass="OraDataText"
                        textBinding="SPATIAL_GEODETIC_NO_DIMS_TO_INDEX@uixDBObjectBundle@servletRequest" />
      			</uix:cellFormat>
				</uix:rowLayout>
			</uix:case>
    	</uix:switcher>
      	
		<uix:rowLayout renderedBinding="noOfDimensionGreater2@spatialBean@servletRequest">
	    	<uix:spacer height="10" width="10"/>
		</uix:rowLayout>
	   
	   
	
    <%-- This is for Geometric Type   --%>                                     
	<uix:rowLayout>
 	  <uix:cellFormat hAlign="right">
	    <uix:styledText styleClass="OraInstructionText" textBinding="SPATIAL_GEOMETRY_TYPE@uixDBObjectBundle@servletRequest"/>
	  </uix:cellFormat> 
                                  
	  <uix:cellFormat>
	    <uix:choice name="sdoGeometryType" id="sdoGeometryType"
                           selectedValueBinding="sdoGeometryType@spatialBean@servletRequest"
                           shortDescBinding="SPATIAL_GEOMETRY_TYPE@uixDBObjectBundle@servletRequest"
						   required="yes">
                 <uix:contents childDataBinding="geometryTypesList@spatialBean@servletRequest">
                  <uix:option textBinding="textKey" valueBinding="valueKey"/>
                 </uix:contents> 
	    </uix:choice>    
	  </uix:cellFormat>          
        </uix:rowLayout>    
      	<uix:rowLayout>
         	<uix:spacer height="10" width="10"/>
      	</uix:rowLayout>

     
	  
	<%-- This is for Free Slots in Index --%>
	<uix:rowLayout >
	    <uix:cellFormat hAlign="right">
		<uix:styledText styleClass="OraInstructionText" textBinding="SPATIAL_FREE_SLOTS_IN_INDEX@uixDBObjectBundle@servletRequest"/>
		</uix:cellFormat> 
		
	    <uix:stackLayout> 	    
	    <uix:textInput id="pctFreeSlotsinIndex"
		 name="pctFreeSlotsinIndex" 
		 shortDescBinding="SPATIAL_FREE_SLOTS_IN_INDEX@uixDBObjectBundle@servletRequest"
		 textBinding="pctFreeSlotsinIndex@spatialBean@servletRequest" 
		 columns="15">
		 <uix:onSubmitValidater>
            <uix:decimal />
          </uix:onSubmitValidater>
		  </uix:textInput>
		 <uix:messageText messageType="error" messageBinding="pctFreeSlotsinIndex@errors@servletRequest"/>
                     </uix:stackLayout>
					 

	</uix:rowLayout>

      
	  
	  <uix:rowLayout>
         <uix:spacer height="10" width="10"/>
      </uix:rowLayout>
	  
	<%-- This is for Work Tablespace --%>
        <uix:switcher childNameBinding="versionEqualOrHigher10@objectBean@servletRequest">
           <uix:case name="true">
		<uix:rowLayout >
		   <uix:cellFormat hAlign="right">
		      <uix:styledText styleClass="OraInstructionText" textBinding="SPATIAL_WORK_TABLESPACE@uixDBObjectBundle@servletRequest"/>                                        
		   </uix:cellFormat>  

		   <uix:cellFormat hAlign="left" wrappingDisabled="true">
		    <uix:lovField id="workTableSpace" name="workTableSpace"
                        textBinding="workTableSpace@spatialBean@servletRequest" 
		      shortDescBinding="TABLESPACE@uixDBObjectBundle@servletRequest"
				searchDescBinding="TABLESPACE@uixDBObjectBundle@servletRequest"
		        onClick="startLov('workTableSpace','ListTablespace')"/>

		    <uix:messageText messageBinding="schemaName@errors@servletRequest"
			 messageType="error"/>

	       </uix:cellFormat>
	      </uix:rowLayout>
	  </uix:case>
        </uix:switcher>

      
	 
	 
	    </uix:tableLayout>
	   </uix:cellFormat>

      <%-- Till here from Rajesh --%>
	  
			<%-- Sachin --%>
			
			<uix:contents>
			   <uix:contentContainer width="100%" textBinding ="DESCRIPTION@sptlMsgs" background="light">
			     <uix:contents>
			       <uix:stackLayout>
				 <uix:contents>
				  
				  			<uix:rowLayout renderedBinding="noOfDimensionGreater2@spatialBean@servletRequest">
				  				<uix:styledText styleClass="OraHeaderSubSub" 
				  		     					textBinding="SPATIAL_NO_DIMS_TO_INDEX@uixDBObjectBundle@servletRequest"/>
				  			</uix:rowLayout>
				  			<uix:rowLayout renderedBinding="noOfDimensionGreater2@spatialBean@servletRequest">
				  				<uix:styledText styleClass="OraInlineInfoText" 
				  								textBinding="INSTR_NUM_DIMS_TO_IDX@sptlMsgs"/>
				  			</uix:rowLayout>
				       		<uix:rowLayout renderedBinding="noOfDimensionGreater2@spatialBean@servletRequest">
				           		<uix:spacer height="10" width="10"/>
				        		</uix:rowLayout>
				  	 
				  
				  	  		<uix:rowLayout>
				  				<uix:styledText styleClass="OraHeaderSubSub" 
				  	    						textBinding="SPATIAL_GEOMETRY_TYPE@uixDBObjectBundle@servletRequest"/>
				  			</uix:rowLayout>
				  			<uix:rowLayout>
				  				<uix:styledText styleClass="OraInlineInfoText" 
				  								textBinding="INSTR_GEOMETRY_TYPE@sptlMsgs"/>	
				  			</uix:rowLayout>
				       	<uix:rowLayout>
				           <uix:spacer height="10" width="10"/>
				        	</uix:rowLayout>
				  	 
				  
				  	  		<uix:rowLayout>
				  				<uix:styledText styleClass="OraHeaderSubSub" 
				  								textBinding="SPATIAL_FREE_SLOTS_IN_INDEX@uixDBObjectBundle@servletRequest"/>
				  			</uix:rowLayout>
				  			<uix:rowLayout>
				  				<uix:styledText styleClass="OraInlineInfoText" 
				  								textBinding="INSTR_FREE_SLOTS_IN_IDX@sptlMsgs"/>
				  			</uix:rowLayout>
				       	<uix:rowLayout>
				           <uix:spacer height="10" width="10"/>
				        	</uix:rowLayout>
				  	 
				  
				  	  		<uix:rowLayout>
				  				<uix:styledText styleClass="OraHeaderSubSub" 
				  		      					textBinding="SPATIAL_WORK_TABLESPACE@uixDBObjectBundle@servletRequest"/>                                        
				  			</uix:rowLayout>
				  			<uix:rowLayout>
				  				<uix:styledText styleClass="OraInlineInfoText" 
				  								textBinding="INSTR_WORK_TABLESPACE_IDX@sptlMsgs"/>
				  			</uix:rowLayout>
				  			
	                          
				 </uix:contents>
			       </uix:stackLayout>
			     </uix:contents>
			   </uix:contentContainer>
                                 </uix:contents>
			

      </uix:rowLayout>
	 </uix:tableLayout>
   </uix:subTabLayout>


       <%-- Create/Edit Buttons --%>
        <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
        </uix:pageButtonBar>
      </uix:pageButtons>
    
    
    </uix:pageLayout>

</db:form>
</uix:body>

</uix:document>

</uix:renderingContext>


