<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        estimateIndexSizePage.jsp
  -- Controller:  db/adm/schm/IndexController.java
  --
  -- Description: On CREATE of Index the Estimate Index Size button will
  --              bring up this page.  It allows the user to figure out 
  --              about how large the index will be once it's created.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="partitionsBundle"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="STORAGE_TITLE@uixIndexBundle@servletRequest"/>
</uix:metaContainer>

<uix:body>
<%-- HTML Form --%>
<db:form name="indexForm" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >

<uix:formValue name="pageName" value="/database/schema/index/storagePage"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="ESTIMATE_INDEX_SIZE@uixDBObjectBundle@servletRequest">  
  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:tableLayout cellSpacing="5">
          <uix:rowLayout>
               <uix:styledText styleClass="OraInstructionText"
                  textBinding="ESTIMATE_TEXT_INDEX@uixDBObjectBundle@servletRequest"/>
            </uix:rowLayout>
            </uix:tableLayout>
          
            <uix:tableLayout width="75%">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="ESTIMATED_SIZE_INDEX@uixDBObjectBundle@servletRequest"/>
                        </uix:cellFormat>     
                        <uix:cellFormat>
                          <uix:rowLayout>
                            <uix:styledText styleClass="OraDataText" 
                                            textBinding="estimatedTableSize@indexEstimateSizeUIBean@servletRequest"/>  
                          </uix:rowLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
<%--
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="SPACE_ALLOCATED@uixDBObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:styledText styleClass="OraDataText"
                                          textBinding="spaceAllocated@indexEstimateSizeUIBean@servletRequest"/> 
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="FREE_SPACE@uixDBObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:styledText styleClass="OraDataText"  
                                          textBinding ="freeSpaceAfterAllocationPct@indexEstimateSizeUIBean@servletRequest"/> 
                        </uix:cellFormat>
                      </uix:rowLayout>                                
--%>
                    </uix:tableLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
      
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:spacer height="5" />
                  </uix:cellFormat>
                </uix:rowLayout>
      
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:tip>
                      <uix:styledText styleClass="OraTipText" textBinding="ESTIMATED_INDEX_SIZE@uixDBObjectBundle@servletRequest" />
                    </uix:tip>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
     <uix:flowLayout>
      <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="cancelEstimateIndexSize"/>
    </uix:flowLayout>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




