<%@ include file="/sdk/oemTop.jspf"%>
<%@ include file="/oemNoscript.jspf"%>
<%--
  -- Page:        generalPage.jsp
  -- Controller:  db/adm/schm/IndexController.java
  --
  -- Description: The General Tab for Index.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>


<jsp:useBean id="objectBean" scope="request"
	type="oracle.sysman.emo.adm.schema.index.Index" />

<db:script src="/database/LOV.js" />

<script language="javascript">
function isOnTable()
{ 
  onTable = document.forms[0].onTable[0].checked;
  return onTable;
}

function popWindow(isOnTable)
{
  if(isOnTable)
  {
    setSearchFilter('schemaName');
    startLov('onSchemaAndObject', 'ListSchemaTable');
  }
  else 
  {
    setSearchFilter('schemaName');
    startLov('onSchemaAndObject', 'ListSchemaCluster');
  }
}

function popXMLWindow(){
   setSearchFilter('schemaName');
   startLov('onSchemaAndObject', 'ListSchemaXMLTable');
}


function xmlLov(){
	var onSchemaAndObject=document.forms[0].onSchemaAndObject.value;
	var array=onSchemaAndObject.split('.');
	var tableName=array[1];
	if(tableName==null || tableName==''){
		tableName=onSchemaAndObject;
	}
	setInitFilterData(tableName);
	startLov('xmlTypeColumnName', 'ListXMLColumns');
}

</script>
<uix:renderingContext id="renderingContext">

	<uix:bundle name="partitionsBundle"
		class="oracle.sysman.db.rsc.schm.PartitionsMsg" />
		<uix:bundle name="indexMsg"
		class="oracle.sysman.db.rsc.schm.IndexMsg" />
		
	<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg" />
	<oem:setURLEncoder id="renderingContext" />
	<uix:document>

		<%-- Imports --%>

		<%@ page import="oracle.sysman.db.adm.schm.IndexConstants"%>

		<%-- HTML Page Title --%>
                <%-- Fix Bug 4080599, for future release
                <%@ include file="/oemTitle.jspf" %>
                --%>
                <uix:metaContainer>
                        <uix:head titleBinding="title@objectBean@servletRequest" />
                </uix:metaContainer>

		<uix:body>

			<%-- HTML Form --%>
			<db:form name="indexForm" method="post"
				destinationBinding="destination@objectBean@servletRequest"
				copyParams="target,type,cancelURL,sname,oname,otype">
				<uix:formValue name="pageName"
					value="/database/schema/index/generalPage" />
				<uix:formValue name="value" />
				<uix:formValue name="source" />
				<uix:pageLayout titleBinding="header@objectBean@servletRequest">

					<%-- Oracle Logo and Tabs --%>
					<%@ include file="/database/global.jspf"%>

					<%-- Warning/Error display --%>
					<oem:messageBox messageType="info"
						errorTableBinding="info@servletRequest" titleTextKey="titleText"
						mainTextKey="mainText" />
					<oem:messageBox messageType="error"
						errorTableBinding="errors@servletRequest" titleTextKey="titleText"
						mainTextKey="mainText" />

					<%-- Create/Edit/View Header --%>
					<uix:subTabLayout>

						<%-- SubTabs --%>
						<uix:subTabs>
							<jsp:include page="/database/schema/index/subTabsInclude.jsp" />
							<uix:ref refID="indexSubTabsInclude" />
						</uix:subTabs>

						<%-- START: TAB CONTENTS starts here --%>

						<uix:tableLayout cellSpacing="5" hAlign="center" width="75%">

							<!-- Index Name -->
							

							<uix:rowLayout>
								<uix:cellFormat hAlign="right" width="80">
									<uix:messagePrompt labeledNodeId="indexName"
										promptBinding="NAME@uixDBObjectBundle@servletRequest"
										required="<%=objectBean.isRequired()%>" />
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:stackLayout>
										<uix:textInput id="indexName" name="indexName"
											shortDescBinding="NAME@uixDBObjectBundle@servletRequest"
											textBinding="indexName@objectBean@servletRequest"
											columns="30" />
										<uix:formValue name="indexName"
											valueBinding="indexName@objectBean@servletRequest" />
										<uix:messageText
											messageBinding="indexName@errors@servletRequest"
											messageType="error" />
									</uix:stackLayout>
								</uix:cellFormat>
							</uix:rowLayout>

							<!-- Schema Name -->

							<uix:rowLayout>
								<uix:cellFormat hAlign="right" width="80">
									<uix:messagePrompt labeledNodeId="SCHEMA"
										promptBinding="SCHEMA@uixDBObjectBundle@servletRequest" />
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:stackLayout>
										<uix:lovField id="SCHEMA" name="schemaName"
											textBinding="schemaName@objectBean@servletRequest"
											shortDescBinding="SCHEMA@uixDBObjectBundle@servletRequest"
											onClick="startLov('schemaName', 'ListSchema')"
											searchDescBinding="SCHEMA@uixDBObjectBundle@servletRequest"
											disabledBinding="editing@objectBean@servletRequest" />
									</uix:stackLayout>
								</uix:cellFormat>
							</uix:rowLayout>

							<!-- Tablespace -->

							<uix:rowLayout renderedBinding="notXMLIndex@objectBean@servletRequest">
								<uix:cellFormat hAlign="right" width="80">
									<uix:messagePrompt labeledNodeId="TBSP"
										promptBinding="TABLESPACE@uixDBObjectBundle@servletRequest" />
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:lovField id="TBSP" name="tablespace"
										textBinding="tablespace@objectBean@servletRequest"
										shortDescBinding="TABLESPACE@uixDBObjectBundle@servletRequest"
										onClick="startLov('tablespace', 'ListTablespaceAll')"
										searchDescBinding="TABLESPACE@uixDBObjectBundle@servletRequest"
										disabledBinding="editing@objectBean@servletRequest" />
									<uix:switcher
										childNameBinding="creatingAndVersionHigher10@objectBean@servletRequest">
										<uix:case name="true">
											<uix:submitButton
												textBinding="ESTIMATE_INDEX_SIZE@uixDBObjectBundle@servletRequest"
												name="event" value="estimateIndexSize" />
										</uix:case>
									</uix:switcher>
								</uix:cellFormat>
							</uix:rowLayout>

							<!-- Index type -->

							<uix:rowLayout renderedBinding="notXMLIndex@objectBean@servletRequest">
								<uix:cellFormat hAlign="right" width="80"
									renderedBinding="onTable@objectBean@servletRequest">
									<uix:messagePrompt
										promptBinding="INDEX_TYPE@uixDBObjectBundle@servletRequest" />
								</uix:cellFormat>
								<uix:cellFormat
									renderedBinding="onTable@objectBean@servletRequest">
									<uix:switcher
										childNameBinding="creating@objectBean@servletRequest">
										<uix:case name="true">
											<uix:switcher
												childNameBinding="MType@objectBean@servletRequest">
												<uix:case name="INDEX">
													<uix:rowLayout hAlign="left">

														<uix:radioButton name="indexType"
															value="<%=IndexConstants.BTREE_INDEX%>"
															textBinding="BTREE_INDEX@uixIndexBundle@servletRequest"
															selectedBinding="BTreeIndex@objectBean@servletRequest" />
														<uix:spacer width="10" />
														<uix:radioButton name="indexType"
															value="<%=IndexConstants.BITMAP_INDEX %>"
															textBinding="BITMAP_INDEX@uixIndexBundle@servletRequest"
															selectedBinding="bitmapIndex@objectBean@servletRequest" />
													</uix:rowLayout>
												</uix:case>
												<uix:case name="XML_INDEX">
													<uix:rowLayout hAlign="left">
														<uix:radioButton name="indexType"
															value="<%=IndexConstants.XML_INDEX %>"
															textBinding="XML_INDEX@uixIndexBundle@servletRequest"
															selected="true"/>
													</uix:rowLayout>
												</uix:case>
											</uix:switcher>

										</uix:case>
										<uix:case name="false">
											<uix:styledText styleClass="OraDataText"
												textBinding="indexType@objectBean@servletRequest" />
										</uix:case>
									</uix:switcher>
								</uix:cellFormat>
							</uix:rowLayout>


							<!-- Status -->

							<uix:switcher
								childNameBinding="creating@objectBean@servletRequest">
								<uix:case name="false">
									<uix:rowLayout>
										<uix:cellFormat hAlign="right" width="80">
											<uix:messagePrompt
												promptBinding="STATUS@uixDBObjectBundle@servletRequest" />
										</uix:cellFormat>

										<uix:cellFormat>
											<uix:switcher
												childNameBinding="creating@objectBean@servletRequest">
												<uix:case name="false">
													<uix:styledText styleClass="OraDataText"
														textBinding="status@objectBean@servletRequest" />
												</uix:case>
											</uix:switcher>
										</uix:cellFormat>
									</uix:rowLayout>
								</uix:case>
							</uix:switcher>

						</uix:tableLayout>






						<uix:header size="2"
							textBinding="INDEXED_TBL_OBJ_HEADER@uixIndexBundle@servletRequest" />

						<uix:tableLayout cellSpacing="5">

							<%-- Indexed object type  for create mode --%>
							<uix:switcher
								childNameBinding="creating@objectBean@servletRequest">
								<uix:case name="true">
									<uix:rowLayout renderedBinding="notXMLIndex@objectBean@servletRequest">
										<uix:cellFormat hAlign="right" width="80">
											<uix:messagePrompt
												promptBinding="INDEX_ON@uixIndexBundle@servletRequest" />
										</uix:cellFormat>
										<uix:cellFormat>
											<oem:radioButton name="onTable" value="true"
												textBinding="TABLE@uixDBObjectBundle@servletRequest"
												onClick="submitForm('indexForm', true, {'event':'createOnTable'})"
												selectedValueBinding="onTable@objectBean@servletRequest" />
											<oem:radioButton name="onTable" value="false"
												textBinding="CLUSTER@uixDBObjectBundle@servletRequest"
												onClick="submitForm('indexForm', true, {'event':'createOnCluster'})"
												selectedValueBinding="onTable@objectBean@servletRequest" 
												/>
										</uix:cellFormat>
									</uix:rowLayout>
								</uix:case>
							</uix:switcher>

							<%--Indexed object type  for edit mode--%>
							
							<uix:switcher
								childNameBinding="creating@objectBean@servletRequest">
								<uix:case name="false">
									<uix:rowLayout>
										<uix:cellFormat hAlign="right" width="120">
											<uix:messagePrompt
												promptBinding="INDEX_ON@uixIndexBundle@servletRequest" />
										</uix:cellFormat>
										<uix:cellFormat>
											<uix:styledText styleClass="OraDataText"
												textBinding="indexedObjectType@objectBean@servletRequest" />
										</uix:cellFormat>
									</uix:rowLayout>
								</uix:case>
							</uix:switcher>

							<!-- Indexed Object Name -->
							<uix:rowLayout>
								<uix:cellFormat hAlign="right">
									<uix:switcher
										childNameBinding="creating@objectBean@servletRequest">
										<uix:case name="true">
											<uix:switcher
												childNameBinding="onTable@objectBean@servletRequest">
												<uix:case name="true">
													<uix:messagePrompt labeledNodeId="NAME"
														promptBinding="TABLE_NAME@uixDBObjectBundle@servletRequest"
														required="<%= objectBean.isRequired()%>" />
												</uix:case>
												<uix:case name="false">
													<uix:messagePrompt labeledNodeId="NAME"
														promptBinding="CLUSTER_NAME@uixDBObjectBundle@servletRequest"
														required="<%= objectBean.isRequired()%>" />
												</uix:case>
											</uix:switcher>
										</uix:case>
										<uix:case name="false">
											<uix:messagePrompt labeledNodeId="NAME"
												promptBinding="OBJECT_NAME@uixDBObjectBundle@servletRequest" />
										</uix:case>
									</uix:switcher>
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:rowLayout>
										<uix:stackLayout>
											<uix:switcher
												childNameBinding="MType@objectBean@servletRequest">
												<uix:case name="INDEX">
													<uix:lovField id="NAME" name="onSchemaAndObject"
														shortDescBinding="OBJECT_NAME@uixDBObjectBundle@servletRequest"
														textBinding="onSchemaAndObject@objectBean@servletRequest"
														columns="60" onClick='<%= "popWindow(isOnTable())"%>'
														searchDescBinding="OBJECT_NAME@uixDBObjectBundle@servletRequest"
														disabledBinding="disabled@objectBean@servletRequest" />
												</uix:case>
												<uix:case name="XML_INDEX">
													<uix:messageLovField id="NAME" name="onSchemaAndObject"
														shortDescBinding="OBJECT_NAME@uixDBObjectBundle@servletRequest"
														textBinding="onSchemaAndObject@objectBean@servletRequest"
														columns="60" onClick='<%= "popXMLWindow()"%>'
														searchDescBinding="OBJECT_NAME@uixDBObjectBundle@servletRequest"
														disabledBinding="disabled@objectBean@servletRequest" />
												</uix:case>
											</uix:switcher>
											<uix:switcher
												childNameBinding="creating@objectBean@servletRequest">
												<uix:case name="true">
													<uix:rowLayout>
														<uix:messageText
															messageBinding="onSchemaAndObject@errors@servletRequest"
															messageType="error" />
													</uix:rowLayout>
												</uix:case>
											</uix:switcher>

										</uix:stackLayout>

										<uix:spacer width="5" />

										<uix:switcher
											childNameBinding="showPopulateColumnsButton@objectBean@servletRequest">
											<uix:case name="true">
												<uix:submitButton
													textBinding="columnsButtonText@objectBean@servletRequest"
													shortDescBinding="columnsButtonText@objectBean@servletRequest"
													name="event" value="populate" 
													renderedBinding="notXMLIndex@objectBean@servletRequest"/>
											</uix:case>
										</uix:switcher>

									</uix:rowLayout>
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout
								renderedBinding="XMLIndex@objectBean@servletRequest">
								<uix:cellFormat hAlign="right" vAlign="top">
									<uix:spacer width="30" height="15"/>
									<uix:messagePrompt
										promptBinding="XMLTYPE_COLUMN_NAME@uixDBObjectBundle@servletRequest"
									/>
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:messageLovField name="xmlTypeColumnName"
										shortDescBinding="XMLTYPE_COLUMN_NAME@uixDBObjectBundle@servletRequest"
										textBinding="xmlTypeColumnName@objectBean@servletRequest"
										columns="60"
										onClick="xmlLov()"
										searchDescBinding="XMLTYPE_COLUMN_NAME@uixDBObjectBundle@servletRequest"
										tipBinding="XML_TYPE_COLUMN_REQUIRED@indexMsg" 
										disabledBinding="disabled@objectBean@servletRequest" />
								</uix:cellFormat>
							</uix:rowLayout>

						</uix:tableLayout>

						<uix:switcher
							childNameBinding="creating@objectBean@servletRequest">
							<uix:case name="true">
								<uix:switcher
									childNameBinding="bitmapJoinIndex@objectBean@servletRequest">
									<uix:case name="false">
										<uix:tableLayout cellSpacing="5">


											<uix:rowLayout
												renderedBinding="onTable@objectBean@servletRequest">
												<uix:switcher
													childNameBinding="spatial@objectBean@servletRequest">
													<uix:case name="true">

														<uix:cellFormat width="15" hAlign="left" vAlign="bottom">
															<uix:spacer width="5" />
														</uix:cellFormat>

														<uix:cellFormat hAlign="left" width="570" vAlign="bottom">
															<uix:tip
																textBinding="SPATIAL_COLUMNS_TIP@uixIndexBundle@servletRequest" />
														</uix:cellFormat>

													</uix:case>
												</uix:switcher>
											</uix:rowLayout>


											<uix:rowLayout
												renderedBinding="spatial@objectBean@servletRequest">
												<uix:cellFormat hAlign="left">
													<uix:spacer width="20" />
												</uix:cellFormat>
											</uix:rowLayout>


											<uix:rowLayout vAlign="bottom"
												renderedBinding="spatial@objectBean@servletRequest">
												<uix:cellFormat hAlign="center" width="120" vAlign="bottom">
													<%-- <uix:messagePrompt promptBinding="INDEX_ON@uixIndexBundle@servletRequest"/>--%>
													<uix:spacer width="10" />
												</uix:cellFormat>
												<uix:cellFormat hAlign="left" vAlign="bottom">
													<oem:radioButton name="showSpatial" value="true"
														textBinding="SPATIAL_COLS@uixDBObjectBundle@servletRequest"
														onClick="submitForm('indexForm', true, {'event':'showSpatial'})"
														selectedValueBinding="showSpatial@objectBean@servletRequest" />
													<oem:radioButton name="showSpatial" value="false"
														textBinding="NON_SPATIAL_COLS@uixDBObjectBundle@servletRequest"
														disabledBinding="disabledOthersOptionForSpatial@objectBean@servletRequest"
														onClick="submitForm('indexForm', true, {'event':'dontShowSpatial'})"
														selectedValueBinding="showSpatial@objectBean@servletRequest" />
												</uix:cellFormat>
											</uix:rowLayout>
										</uix:tableLayout>
									</uix:case>
								</uix:switcher>
							</uix:case>
						</uix:switcher>


						<!-- tip and table -->
						<uix:tableLayout cellSpacing="5" width="80%">

							<uix:rowLayout>
								<uix:cellFormat />

								<uix:switcher
									childNameBinding="creating@objectBean@servletRequest">
									<uix:case name="true">
										<uix:switcher
											childNameBinding="bitmapJoinIndex@objectBean@servletRequest">
											<uix:case name="false">
												<uix:cellFormat hAlign="right" width="100">
													<uix:spacer width="20" />
												</uix:cellFormat>
											</uix:case>
										</uix:switcher>
									</uix:case>
								</uix:switcher>

								<%-- Table columns list --%>
								<uix:switcher
									childNameBinding="creating@objectBean@servletRequest">
									<uix:case name="true">

										<!-- Choose between Spatial and Non-Spatial Columns -->
										<%-- Indexed object type  for create mode --%>

										<!-- bitmap join index check -->
										<uix:switcher
											childNameBinding="bitmapJoinIndex@objectBean@servletRequest">
											<uix:case name="false">
												<uix:tableLayout width="80%"
													renderedBinding="notXMLIndex@objectBean@servletRequest">
													<uix:rowLayout
														renderedBinding="onTable@objectBean@servletRequest">
														<uix:switcher
															childNameBinding="showSingleSelection@objectBean@servletRequest">
															<uix:case name="true">
																<uix:tip
																	textBinding="SPATIAL_COLUMNS_TIP_SINGLE_SELECT@uixIndexBundle@servletRequest" />
															</uix:case>
															<uix:case name="false">
																<uix:tip
																	textBinding="INDEX_COLUMNS_TIP@uixIndexBundle@servletRequest"
																	renderedBinding="notXMLIndex@objectBean@servletRequest" />
															</uix:case>
														</uix:switcher>
													</uix:rowLayout>
													<uix:rowLayout hAlign="left">
														<uix:stackLayout>
															<uix:header size="2"
																textBinding="TABLE_COLS_HEADER@uixIndexBundle@servletRequest">

																<uix:switcher
																	childNameBinding="onTable@objectBean@servletRequest">
																	<uix:case name="true">

																		<uix:switcher
																			childNameBinding="showSingleSelection@objectBean@servletRequest">
																			<uix:case name="true">
																				<oem:table name="columnsTableUI"
																					beanKey="indexColumnBean" formSubmitted="true"
																					blockSize="25" dataSourceProp="columnsTableUI"
																					width="100%"
																					summaryBinding="TABLE_COLS_HEADER@uixIndexBundle@servletRequest"
																					copyParams="target,type,cancelURL,sname,oname,otype">
																					<uix:tableSelection>
																						<uix:singleSelection
																							selectedIndexBinding="selectedIndex@objectBean@servletRequest"
																							shortDescBinding="SELECT@dbMsgs" />
																					</uix:tableSelection>

																				</oem:table>
																			</uix:case>
																			<uix:case name="false">
																				<oem:table name="columnsTableUI"
																					beanKey="indexColumnBean" formSubmitted="true"
																					blockSize="25" dataSourceProp="columnsTableUI"
																					width="100%"
																					summaryBinding="TABLE_COLS_HEADER@uixIndexBundle@servletRequest"
																					copyParams="target,type,cancelURL,sname,oname,otype">
																					<uix:footer>
																						<uix:submitButton
																							textBinding="INSERT_COL_EXP@uixIndexBundle@servletRequest"
																							shortDescBinding="INSERT_COL_EXP@uixIndexBundle@servletRequest"
																							name="event" value="insert" />
																					</uix:footer>

																				</oem:table>
																			</uix:case>
																		</uix:switcher>

																	</uix:case>
																	<uix:case name="false">
																		<oem:table name="clusterColumnsTableUI"
																			beanKey="indexColumnBean" formSubmitted="true"
																			blockSize="25" dataSourceProp="clusterColumnsTableUI"
																			width="100%"
																			summaryBinding="TABLE_COLS_HEADER@uixIndexBundle@servletRequest"
																			copyParams="target,type,cancelURL,sname,oname,otype">
																		</oem:table>
																	</uix:case>
																</uix:switcher>

																<uix:messageText
																	messageBinding="columnsTableUI@errors@servletRequest"
																	messageType="error" />
															</uix:header>
														</uix:stackLayout>
													</uix:rowLayout>

													<uix:rowLayout>
														<uix:spacer height="5" />
													</uix:rowLayout>

													<!-- Table Alias -->
													<uix:switcher
														childNameBinding="showAliasOption@objectBean@servletRequest">
														<uix:case name="true">
															<uix:rowLayout>
																<uix:cellFormat>
																	<uix:styledText labeledNodeId="aliasExpression"
																		styleClass="OraInstructionText"
																		textBinding="colExprAliasInstText@objectBean@servletRequest" />
																	<uix:textInput id="aliasExpression"
																		name="aliasExpression" columns="30"
																		textBinding="aliasExpression@indexColumnBean@servletRequest" />
																</uix:cellFormat>
															</uix:rowLayout>
														</uix:case>
													</uix:switcher>

													<!-- Table Alias Tip -->
													<uix:switcher
														childNameBinding="showAliasOption@objectBean@servletRequest">
														<uix:case name="true">
															<uix:rowLayout>
																<uix:styledText styleClass="OraTipText"
																	textBinding="COLUMN_EXP_ALIAS_TIP@uixIndexBundle@servletRequest" />
															</uix:rowLayout>
														</uix:case>
													</uix:switcher>
												</uix:tableLayout>
											</uix:case>

											<!-- if it's bitmap join index type, show joining layout -->
											<uix:case name="true">
												<jsp:include
													page="/database/schema/index/createJoinIndexLayoutInclude.jsp" />
												<uix:ref refID="joinIndexInclude" />
											</uix:case>
											<!-- end is bimap join index case -->
										</uix:switcher>
									</uix:case>
									<!-- end is creating true case -->

									<uix:case name="false">
										<uix:header size="2"
											textBinding="INDEXED_TBL_COLS_HEADER@uixIndexBundle@servletRequest">
											<oem:table name="columnsTableUI" beanKey="indexColumnBean"
												dataSourceProp="columnsTableUI" width="100%" blockSize="25"
												summaryBinding="INDEXED_TBL_COLS_HEADER@uixIndexBundle@servletRequest"
												copyParams="target,type,cancelURL,sname,oname,otype">
											</oem:table>
										</uix:header>
									</uix:case>
								</uix:switcher>
							</uix:rowLayout>

							<!-- end  tip and table -->


						</uix:tableLayout>


						<%-- END: TAB CONTENTS ends here --%>

					</uix:subTabLayout>

					<%-- Create/Edit Buttons --%>
					<uix:pageButtons>
						<uix:pageButtonBar>
							<jsp:include page="/database/schema/pageButtonInclude.jsp" />
							<uix:ref refID="pageButtonInclude" />
						</uix:pageButtonBar>
					</uix:pageButtons>

				</uix:pageLayout>
			</db:form>
			<%-- END: HTML Form --%>

		</uix:body>
	</uix:document>
</uix:renderingContext>
<%-- END: Content --%>




