<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        optionsPage.jsp
  -- Controller:  db/adm/schm/IndexController.java
  --
  -- Description: The Options Tab for Index.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/LOV.js" />
<db:script src="/database/utils.js"/>

<script language="javascript">
function setParallel()
{
  if (document.forms[0].parallel != null)
  {
    document.forms[0].defaultDegree[0].disabled = !document.forms[0].parallel.checked;
    document.forms[0].defaultDegree[1].disabled = !document.forms[0].parallel.checked;
    document.forms[0].parallelDegree.disabled = (document.forms[0].defaultDegree[0].checked || document.forms[0].defaultDegree[0].disabled);
  }
}

function setAsynchronousIndex(){
  if (document.forms[0].asynchronousIndex != null){
    document.forms[0].asynchronousIndexType[0].disabled = !document.forms[0].asynchronousIndex.checked;
    document.forms[0].asynchronousIndexType[1].disabled = !document.forms[0].asynchronousIndex.checked;
    document.forms[0].asynchronousIndexType[2].disabled = !document.forms[0].asynchronousIndex.checked;
  }
}


function setFrequencyInterval(){
  if (document.forms[0].asynchronousIndexType[2] != null){
     document.forms[0].interval.disabled= !(document.forms[0].asynchronousIndexType[2].checked && document.forms[0].asynchronousIndex.checked);
     document.forms[0].frequency.disabled= !(document.forms[0].asynchronousIndexType[2].checked && document.forms[0].asynchronousIndex.checked);
  }
}

function setPathSubsetting(){
  if (document.forms[0].pathSubsettingRequired != null){
     document.forms[0].pathSubsetting[0].disabled = !document.forms[0].pathSubsettingRequired.checked;
     document.forms[0].pathSubsetting[1].disabled = !document.forms[0].pathSubsettingRequired.checked;
     document.forms[0].pathSubsetting[2].disabled = !document.forms[0].pathSubsettingRequired.checked;
     if(!document.forms[0].pathSubsettingRequired.checked){
     	document.forms[0].pathSubsetting[0].checked=true;     	
     }
  }
}

function setPathTable(){
  if (document.forms[0].pathTableRequired != null){
     document.forms[0].pathTable.disabled = !document.forms[0].pathTableRequired.checked;
  }
}

function setPathTablespace(){
  if (document.forms[0].pathTablespaceRequired != null){
     document.forms[0].pathTablespace.disabled = !document.forms[0].pathTablespaceRequired.checked;
  }
}

</script>

<jsp:useBean id="segmentBean" scope="request"
   type="oracle.sysman.emo.adm.schema.index.IndexSegment"/>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.index.Index"/>

<db:script src="/database/utils.js"/>

<%-- Imports --%>

<%@ page import="oracle.sysman.db.adm.schm.IndexConstants" %>



<uix:renderingContext id="renderingContext">

  <uix:bundle name="partitionsBundle"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%--Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="OPTIONS_TITLE@uixIndexBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<uix:body onLoad="setParallel();setAsynchronousIndex();setFrequencyInterval();setPathSubsetting();setPathTable();setPathTablespace()">
<db:form name="indexForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">

<uix:formValue name="pageName" value="/database/schema/index/optionsPage"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/index/subTabsInclude.jsp" />
      <uix:ref refID="indexSubTabsInclude" />
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

						<uix:switcher childNameBinding="MType@objectBean@servletRequest">
							<uix:case name="INDEX">
								<uix:header size="2"
									textBinding="INDEX_OPTIONS@uixIndexBundle@servletRequest">
									<uix:tableLayout cellSpacing="3">
										<%-- Unique --%>
										<uix:rowLayout>
											<uix:checkBox name="unique"
												checkedBinding="uniqueCheck@objectBean@servletRequest"
												textBinding="UNIQUE_TEXT@uixIndexBundle@servletRequest"
												disabledBinding="uniqueOptDisabled@segmentBean@servletRequest" />
										</uix:rowLayout>
										<%-- Reverse --%>
										<uix:rowLayout>
											<uix:checkBox name="reverse"
												checkedBinding="reverse@segmentBean@servletRequest"
												textBinding="REVERSE_TEXT@uixIndexBundle@servletRequest"
												disabledBinding="reverseOptDisabled@segmentBean@servletRequest" />
										</uix:rowLayout>
										<%-- Parallel --%>
										<uix:rowLayout>
											<uix:checkBox name="parallel"
												checkedBinding="parallel@segmentBean@servletRequest"
												textBinding="PARALLEL_TEXT@uixIndexBundle@servletRequest"
												onClick="setParallel()" />
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:tableLayout cellSpacing="3">
												<uix:rowLayout>
													<uix:cellFormat width="20" />
													<uix:messagePrompt
														promptBinding="PARALLEL_DEGREE@uixIndexBundle@servletRequest" />
													<oem:radioButton name="defaultDegree" value="true"
														textBinding="DEFAULT@uixDBObjectBundle@servletRequest"
														onClick="setParallel()"
														selectedValueBinding="defaultDegree@segmentBean@servletRequest" />
													<oem:radioButton name="defaultDegree" value="false"
														textBinding="VALUE@uixDBObjectBundle@servletRequest"
														onClick="setParallel()"
														selectedValueBinding="defaultDegree@segmentBean@servletRequest" />
													<uix:textInput name="parallelDegree"
														textBinding="parallelDegree@segmentBean@servletRequest"
														columns="5"
														shortDescBinding="PARALLEL_DEGREE@uixIndexBundle@servletRequest" />
												</uix:rowLayout>
											</uix:tableLayout>
										</uix:rowLayout>
										<%-- Compress - Dont show this if index is a bitmap index an version lower than 81 --%>
										<uix:switcher
											childNameBinding="versionEqualOrHigher81@objectBean@servletRequest">
											<uix:case name="true">
												<uix:rowLayout>
													<uix:checkBox name="indexCompress"
														checkedBinding="indexCompress@segmentBean@servletRequest"
														textBinding="COMPRESS_TEXT@uixIndexBundle@servletRequest"
														disabledBinding="disableCompressOption@objectBean@servletRequest" />
												</uix:rowLayout>
											</uix:case>
										</uix:switcher>
										<uix:switcher
											childNameBinding="versionEqualOrHigher81@objectBean@servletRequest">
											<uix:case name="true">
												<uix:rowLayout>
													<uix:tableLayout cellSpacing="3">
														<uix:rowLayout>
															<uix:cellFormat width="20" />
															<uix:messagePrompt labeledNodeId="PREFIX"
																promptBinding="PREFIX_LENGTH@uixIndexBundle@servletRequest" />
															<oem:choice name="prefixLength" id="PREFIX"
																optionsBinding="prefixLengthChoices@segmentBean@servletRequest"
																selectedValueBinding="prefixLength@segmentBean@servletRequest"
																disabledBinding="disableCompressOption@objectBean@servletRequest" />
														</uix:rowLayout>
													</uix:tableLayout>
												</uix:rowLayout>
											</uix:case>
										</uix:switcher>
									</uix:tableLayout>
								</uix:header>
							</uix:case>
						</uix:switcher>

						<%--XML Index--%>
						
						<uix:switcher childNameBinding="MType@objectBean@servletRequest">
							<uix:case name="XML_INDEX">
								<uix:header size="2"
									textBinding="XML_INDEX_OPTIONS@uixIndexBundle@servletRequest">

									<uix:tableLayout cellSpacing="3">
										<uix:rowLayout>

											<uix:checkBox name="pathTableRequired"
												checkedBinding="pathTableRequired@segmentBean@servletRequest"
												textBinding="PATH_TABLE@uixIndexBundle@servletRequest"
												onClick="setPathTable()"
												renderedBinding="XMLIndex@objectBean@servletRequest" />


											<uix:textInput name="pathTable"
												textBinding="pathTable@segmentBean@servletRequest"
												columns="25"
												shortDescBinding="PATH_TABLE@uixIndexBundle@servletRequest"
												renderedBinding="XMLIndex@objectBean@servletRequest" />

										</uix:rowLayout>
									</uix:tableLayout>


									<uix:tableLayout cellSpacing="3">
										<uix:rowLayout>

											<uix:checkBox name="pathTablespaceRequired"
												checkedBinding="pathTablespaceRequired@segmentBean@servletRequest"
												textBinding="PATH_TABLESPACE@uixIndexBundle@servletRequest"
												onClick="setPathTablespace()"
												renderedBinding="XMLIndex@objectBean@servletRequest" />

											<uix:cellFormat>
												<uix:lovField id="TBSP" name="pathTablespace"
													textBinding="pathTablespace@segmentBean@servletRequest"
													shortDescBinding="PATH_TABLESPACE@uixIndexBundle@servletRequest"
													onClick="startLov('pathTablespace', 'ListTablespacePerm')"
													searchDescBinding="PATH_TABLESPACE@uixIndexBundle@servletRequest" />
											</uix:cellFormat>

										</uix:rowLayout>
									</uix:tableLayout>

									<uix:tableLayout cellSpacing="3">
										<uix:rowLayout>
											<uix:checkBox name="pathSubsettingRequired"
												checkedBinding="pathSubsettingRequired@segmentBean@servletRequest"
												textBinding="PATH_SUB_SETTING@uixIndexBundle@servletRequest"
												onClick="setPathSubsetting();submitForm('indexForm', true, {'event':'subTabOptions'})"
												renderedBinding="XMLIndex@objectBean@servletRequest" />

										</uix:rowLayout>
									</uix:tableLayout>


									<uix:tableLayout cellSpacing="3">
										<uix:rowLayout>
											<uix:spacer width="20" />
											<uix:radioButton name="pathSubsetting"
												value="<%=IndexConstants.INCLUDE_ALL%>"
												textBinding="INCLUDE_ALL_PATHS@uixIndexBundle@servletRequest"
												selectedBinding="includeAll@segmentBean@servletRequest"
												disabledBinding="disabled@objectBean@servletRequest"
												onClick="submitForm('indexForm', true, {'event':'subTabOptions'})"
												renderedBinding="XMLIndex@objectBean@servletRequest" />
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:spacer width="20" />
											<uix:radioButton name="pathSubsetting"
												value="<%=IndexConstants.INCLUDE_BELOW%>"
												textBinding="INCLUDE_BELOW_PATHS@uixIndexBundle@servletRequest"
												selectedBinding="includeBelow@segmentBean@servletRequest"
												disabledBinding="disabled@objectBean@servletRequest"
												onClick="submitForm('indexForm', true, {'event':'subTabOptions'})"
												renderedBinding="XMLIndex@objectBean@servletRequest" />
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:spacer width="20" />
											<uix:radioButton name="pathSubsetting"
												value="<%=IndexConstants.EXCLUDE_BELOW%>"
												textBinding="EXCLUDE_BELOW_PATHS@uixIndexBundle@servletRequest"
												selectedBinding="excludeBelow@segmentBean@servletRequest"
												disabledBinding="disabled@objectBean@servletRequest"
												onClick="submitForm('indexForm', true, {'event':'subTabOptions'})"
												renderedBinding="XMLIndex@objectBean@servletRequest" />
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:spacer width="10"
												renderedBinding="pathUIDataSourceRequired@segmentBean@servletRequest" />
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:spacer width="20"
												renderedBinding="PathUIDataSourceRequired@segmentBean@servletRequest" />
											<oem:table name="<%=IndexConstants.PATH_UI_DATASOURCE %>"
												beanKey="segmentBean"
												renderedBinding="pathUIDataSourceRequired@segmentBean@servletRequest"
												blockSize="5"
												destinationBinding="destination@segmentBean@servletRequest"
												formSubmitted="true"
												dataSourceProp="<%=IndexConstants.PATH_UI_DATASOURCE %>"
												width="250" summaryBinding="RESULT@dbMsgs"
												alternateTextBinding="NO_PATHS_AVAILABLE@uixIndexBundle@servletRequest">
												<uix:columnFooter>
													<uix:addTableRow
														textBinding="ADD_FIVE_ROWS@uixIndexBundle@servletRequest"
														rowsBinding="addRows@segmentBean@servletRequest" />
												</uix:columnFooter>
											</oem:table>
										</uix:rowLayout>
									</uix:tableLayout>

									<uix:rowLayout>
										<uix:spacer width="3" />
										<uix:checkBox name="asynchronousIndex"
											checkedBinding="asynchronousIndex@segmentBean@servletRequest"
											textBinding="CREATE_ASYNCHRONOUS_INDEX@uixIndexBundle@servletRequest"
											onClick="setAsynchronousIndex();setFrequencyInterval()"
											renderedBinding="XMLIndex@objectBean@servletRequest" />
									</uix:rowLayout>


									<uix:rowLayout>
										<uix:tableLayout cellSpacing="3">
											<uix:rowLayout>
												<uix:cellFormat width="20" />
												<uix:radioButton name="asynchronousIndexType"
													value="<%=IndexConstants.MANUAL%>"
													textBinding="MANUAL@uixIndexBundle@servletRequest"
													selectedBinding="asynchronousIndexManual@segmentBean@servletRequest"
													onClick="setFrequencyInterval()"
													renderedBinding="XMLIndex@objectBean@servletRequest" />
											</uix:rowLayout>

											<uix:rowLayout>
												<uix:cellFormat width="20" />
												<uix:radioButton name="asynchronousIndexType"
													value="<%=IndexConstants.ON_COMMIT%>"
													textBinding="ON_COMMIT@uixIndexBundle@servletRequest"
													selectedBinding="asynchronousIndexOnCommit@segmentBean@servletRequest"
													onClick="setFrequencyInterval()"
													renderedBinding="XMLIndex@objectBean@servletRequest" />
											</uix:rowLayout>

											<uix:rowLayout>
												<uix:cellFormat width="20" />
												<uix:radioButton name="asynchronousIndexType"
													value="<%=IndexConstants.EVERY%>"
													textBinding="FREQUENCY@uixIndexBundle@servletRequest"
													selectedBinding="asynchronousIndexEvery@segmentBean@servletRequest"
													onClick="setFrequencyInterval()"
													renderedBinding="XMLIndex@objectBean@servletRequest" />
												<uix:textInput name="interval"
													textBinding="interval@segmentBean@servletRequest"
													maximumLength="2" columns="2"
													shortDescBinding="INTERVAL_TOOL_TIP@uixIndexBundle@servletRequest"
													renderedBinding="XMLIndex@objectBean@servletRequest" />
												<uix:choice name="frequency"
													shortDescBinding="FREQUENCY_TOOL_TIP@uixIndexBundle@servletRequest"
													selectedValueBinding="frequency@segmentBean@servletRequest"
													renderedBinding="XMLIndex@objectBean@servletRequest">

													<uix:contents
														childDataBinding="frequencyOptions@segmentBean@servletRequest">
														<uix:option textBinding="text" valueBinding="value"/>
													</uix:contents>
												</uix:choice>
											</uix:rowLayout>
										</uix:tableLayout>
									</uix:rowLayout>


								</uix:header>
							</uix:case>
						</uix:switcher>

						<%-- Execution Options --%>
						<uix:switcher childNameBinding="MType@objectBean@servletRequest">
							<uix:case name="INDEX">
								<uix:header size="2"
									textBinding="EXECUTE_OPTIONS@uixIndexBundle@servletRequest">
									<uix:tableLayout cellSpacing="3">

										<%-- ONLINE --%>
										<uix:rowLayout>
											<uix:checkBox name="online"
												checkedBinding="online@segmentBean@servletRequest"
												disabledBinding="disableOnlineOpt@objectBean@servletRequest"
												textBinding="ONLINE_TEXT@uixIndexBundle@servletRequest" />
										</uix:rowLayout>

										<%-- COMPUTE STATISTICS --%>
										<uix:rowLayout>
											<uix:checkBox name="computeStatistics"
												checkedBinding="computeStatistics@segmentBean@servletRequest"
												disabledBinding="disableComputeStatsOpt@objectBean@servletRequest"
												textBinding="COMPUTE_STATISTICS_TEXT@uixIndexBundle@servletRequest" />
										</uix:rowLayout>

										<%-- NOSORT --%>

										<uix:switcher
											childNameBinding="creating@objectBean@servletRequest">
											<uix:case name="true">
												<uix:rowLayout>
													<uix:checkBox name="nosort"
														checkedBinding="nosort@segmentBean@servletRequest"
														textBinding="NO_SORT_TEXT@uixIndexBundle@servletRequest"
														disabledBinding="disableNosortOpt@objectBean@servletRequest" />
												</uix:rowLayout>
											</uix:case>
										</uix:switcher>
									</uix:tableLayout>
								</uix:header>
							</uix:case>
						</uix:switcher>

						<%-- END: TAB CONTENTS ends here --%>   
        
    </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




