<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        storagePage.jsp
  -- Controller:  db/adm/schm/IndexController.java
  --
  -- Description: The Storage Tab for Index.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="pmsgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%--Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="STORAGE_TITLE@uixIndexBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<db:form name="indexForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.INDEX_STATS_PG %>"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/index/subTabsInclude.jsp" />
      <uix:ref refID="indexSubTabsInclude" />
    </uix:subTabs>      
    
    <!-- STATS -->

      <uix:tableLayout>
       <uix:rowLayout>        
         <uix:cellFormat>
           <uix:spacer height="10" width="5" />
         </uix:cellFormat>
       </uix:rowLayout>      

        <!-- lastAnalyzed -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="LAST_ANALYZED@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="lastAnalyzed@objectBean@servletRequest" />
       </uix:rowLayout>
       
       <!-- blevel -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="BLEVEL@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="blevel@objectBean@servletRequest" />
       </uix:rowLayout>
       
       <!-- distinctKeys -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="DISTINCT_KEYS@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="distinctKeys@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!-- clusteringFactor-->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="CLUSTERING_FACTOR@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="clusteringFactor@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!--leafBlocks -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="LEAF_BLOCKS@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="leafBlocks@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!-- avgLeafBlocksPerKey -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="AVG_LEAF_BLOCKS_PER_KEY@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="avgLeafBlocksPerKey@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!-- avgDataBlocksPerKey-->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="AVG_DATA_BLOCKS_PER_KEY@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="avgDataBlocksPerKey@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!--numRows -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="NUM_ROWS@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="numRows@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!-- sampleSize -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="SAMPLE_SIZE@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="sampleSize@objectBean@servletRequest" />
       </uix:rowLayout>     
       
       <uix:rowLayout>        
         <uix:cellFormat>
           <uix:spacer height="10" width="5" />
         </uix:cellFormat>
       </uix:rowLayout>      
     </uix:tableLayout>
    <%-- END: TAB CONTENTS ends here --%>   
  </uix:subTabLayout>    

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




