<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        storagePage.jsp
  -- Controller:  db/adm/schm/IndexController.java
  --
  -- Description: The Storage Tab for Index.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="pmsgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%--Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="STORAGE_TITLE@uixIndexBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<db:form name="indexForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/index/storagePage"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/index/subTabsInclude.jsp" />
      <uix:ref refID="indexSubTabsInclude" />
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>
  
    <%-- If partitioned, storage is default partition storage --%>
    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
      <uix:case name="false"> 
        <uix:stackLayout renderedBinding="partitioned@objectBean@servletRequest">
          <uix:spacer height="5" />
          <uix:styledText styleClass="OraInstructionText" 
                          textBinding="DESC_DEF_OPTS@pmsgs" />
        </uix:stackLayout>
      </uix:case>
    </uix:switcher>       
    
    <!-- SHARED STORAGE UI -->
    
     <uix:switcher childNameBinding="showSpatial@objectBean@servletRequest">
     <uix:case name="false">
        <uix:dataScope currentDataBinding="segmentBean@servletRequest">
        <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
        <uix:ref refID="storageInclude" />
        </uix:dataScope>
     </uix:case>
     <uix:case name="true">
        <uix:dataScope currentDataBinding="segmentBean@servletRequest">
        <jsp:include page="/database/schema/utilities/spatialStorageContextInclude.jsp" />
        <uix:ref refID="spatialstorageInclude" />
        </uix:dataScope>
     </uix:case>
     </uix:switcher>
     
    


    <%-- END: TAB CONTENTS ends here --%>   
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




