<%--
  -- Page:       subTabsInclude.jsp
  -- 
  -- Description: This handles all of the index subtabs.
  --              All events should be named: subTab<tabName>.
  --              In onEvent any event that starts with "subTab"
  --              will be forwarded to the onSubTab function where
  --              it will be handled. 
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="indexSubTabsInclude">
<uix:subTabBar selectedIndexBinding="selectedTab@objectBean@servletRequest">
		
		<%-- General Tab --%>
		<db:link textBinding="GENERAL@uixDBObjectBundle@servletRequest"
					 shortDescBinding="GENERAL@uixDBObjectBundle@servletRequest"
					 onClick="submitForm('indexForm', true, {event:'subTabGeneral'})"
					 copyParams="target,type,cancelURL,sname,oname,otype" />

		<%-- Storage Tab --%>
		<db:link textBinding="STORAGE@uixDBObjectBundle@servletRequest"
					 shortDescBinding="STORAGE@uixDBObjectBundle@servletRequest"
					 onClick="submitForm('indexForm', true, {event:'subTabStorage'})" 
					 copyParams="target,type,cancelURL,sname,oname,otype" 
					 renderedBinding="notXMLIndex@objectBean@servletRequest"/>


		<%-- Options Tab --%>
		<db:link textBinding="OPTIONS@uixDBObjectBundle@servletRequest" 
					shortDescBinding="OPTIONS@uixDBObjectBundle@servletRequest" 
					onClick="submitForm('indexForm', true, {event:'subTabOptions'})"  
					copyParams="target,type,cancelURL,sname,oname,otype" 
					renderedBinding="dontShowSpatial@objectBean@servletRequest"/>
							

		<%-- Partitions Tab --%>
		<db:link textBinding="PARTITIONS@uixSchemaBundle@servletRequest" 
					shortDescBinding="PARTITIONS@uixSchemaBundle@servletRequest" 
					renderedBinding="showPartition@objectBean@servletRequest" 
					onClick="submitForm('indexForm', true, {event:'subTabPartitions'})" 
					copyParams="target,type,cancelURL,sname,oname,otype" />



		<%-- Space Usage Tab --%>
		<db:link textBinding="SEGMENTS@uixSchemaBundle@servletRequest" 
					shortDescBinding="SEGMENTS@uixSchemaBundle@servletRequest" 
					renderedBinding="showSegments@objectBean@servletRequest" 
					onClick="submitForm('indexForm', true, {event:'subTabSpaceUsage'})" 
					copyParams="target,type,cancelURL,sname,oname,otype" />

		
		<%-- Spatial Usage Tab --%>
		<db:link textBinding="SPATIAL@uixDBObjectBundle@servletRequest" 
					shortDescBinding="SPATIAL@uixDBObjectBundle@servletRequest" 
					onClick="submitForm('indexForm', true, {event:'subTabSpatial'})" 
					renderedBinding="showSpatialTab@objectBean@servletRequest" 
					copyParams="target,type,cancelURL,sname,oname,otype" />
										
 		
 		<%-- Stats Tab --%>
		<db:link textBinding="STATISTICS@uixDBObjectBundle@servletRequest"
					shortDescBinding="STATISTICS@uixDBObjectBundle@servletRequest"
					onClick="submitForm('indexForm', true, {event:'subTabStats'})" 
					copyParams="target,type,cancelURL,sname,oname,otype" 
					renderedBinding="notXMLIndex@objectBean@servletRequest"/> 
		
 </uix:subTabBar>
</uix:buildTree>

