<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        viewPage.jsp
  -- Controller:  db/adm/schm/IndexController.java
  --
  -- Description: on VIEW of an index object, this page will be displayed.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<jsp:useBean id="segmentBean" scope="request"
   type="oracle.sysman.emo.adm.schema.index.IndexSegment"/>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.index.Index"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.IndexConstants"%>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<uix:body>

<%-- HTML Form --%>
<db:form name="vwIdxFrm" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype,guid,version,initMethod">

<uix:formValue name="pageName" value="/database/schema/index/viewPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- START: TAB CONTENTS starts here --%>

  <!-- GENERAL TAB -->
    <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">

       <!-- Name -->      
       <uix:tableLayout>
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80">
           <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="indexName@objectBean@servletRequest" />
       </uix:rowLayout>

       <!-- Schema -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80">
           <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="schemaName@objectBean@servletRequest" />
       </uix:rowLayout>

       <!-- Tablespace -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80">
           <uix:messagePrompt promptBinding="TABLESPACE@uixDBObjectBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="tablespace@objectBean@servletRequest" />
       </uix:rowLayout>

       <!-- Index Type-->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80">
           <uix:messagePrompt promptBinding="INDEX_TYPE@uixDBObjectBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="indexType@objectBean@servletRequest" />
       </uix:rowLayout>

       <!-- Status -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80">
           <uix:messagePrompt promptBinding="STATUS@uixDBObjectBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="status@objectBean@servletRequest" />
       </uix:rowLayout>

       </uix:tableLayout>

    </uix:header>
    <!-- END: GENERAL TAB -->

    <%-- XML INDEX --%>
    <uix:switcher childNameBinding="MType@objectBean@servletRequest">
        <uix:case name="XML_INDEX">
             <jsp:include page="/database/schema/index/viewXmlTypeIndexInclude.jsp" />
             <uix:ref refID="viewXmlTypeIndexInclude" />
        </uix:case>
    </uix:switcher>

    <!-- INDEXD OBJECT -->
    <uix:header textBinding="INDEXED_OBJ@uixIndexBundle@servletRequest">
      <uix:tableLayout> 

       <!-- INDEX ON -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80"> 
           <uix:messagePrompt promptBinding="INDEX_ON@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="indexedObjectType@objectBean@servletRequest" />
       </uix:rowLayout>

       <!-- Base Object Schema -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80">
           <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="onSchemaName@objectBean@servletRequest" />
       </uix:rowLayout>

       <!-- Base Object Name -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80">
           <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:link textBinding="onObjectName@objectBean@servletRequest" 
                   destinationBinding="indexedTablePage@objectBean@servletRequest"/>
       <%--  <uix:styledText styleClass="OraDataText" 
                         textBinding="onObjectName@objectBean@servletRequest" /> --%>
       </uix:rowLayout>

      </uix:tableLayout>
    </uix:header>
    <!-- END:INDEXD OBJECT -->

    <!-- INDEX COLUMNS -->
    <uix:header textBinding="INDEX_COLUMNS@uixIndexBundle@servletRequest">
      <uix:rowLayout>
      <uix:cellFormat>
        <uix:spacer width="15" />
      </uix:cellFormat> 
        <oem:table name="columnsTableUI" beanKey="indexColumnBean"
                   formSubmitted="true"
                   dataSourceProp="columnsTableUI" blockSize="25"
                   summaryBinding="INDEX_COLUMNS@uixIndexBundle@servletRequest"
                   copyParams="target,type,cancelURL,sname,oname,otype,guid,version,initMethod" />
      </uix:rowLayout>
    </uix:header>
    <!-- END:INDEX COLUMNS -->
    
    <!-- PARTITIONS -->
    <uix:header textBinding="PARTITIONS@uixSchemaBundle@servletRequest" 
                renderedBinding="partitioned@objectBean@servletRequest" >
      <jsp:include page="/database/schema/index/partitionsViewInclude.jsp" />
      <uix:ref refID="partitionsViewInclude" />
    </uix:header>
 
    <!-- STORAGE TAB -->
    <uix:switcher childNameBinding="partitioned@objectBean@servletRequest">
      <uix:case name="false">
        <uix:header textBinding="STORAGE@uixDBObjectBundle@servletRequest">
          <!-- SHARED STORAGE UI -->
           <uix:dataScope currentDataBinding="segmentBean@servletRequest">
           <jsp:include page="/database/schema/utilities/viewStorageContextInclude.jsp" />
           <uix:ref refID="viewStorageInclude" />
         </uix:dataScope>
        </uix:header>
      </uix:case>
    </uix:switcher> 
    <!-- END: STORAGE TAB -->

    <!-- OPTIONS -->
    <uix:header textBinding="OPTIONS@uixDBObjectBundle@servletRequest">
      <uix:tableLayout>

        <!-- INDEX OPTIONS -->
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" width="100">
            <uix:switcher childNameBinding="hasIndexOptions@segmentBean@servletRequest">
              <uix:case name="true">
                <uix:messagePrompt promptBinding="INDEX_OPTIONS@uixIndexBundle@servletRequest"/>
              </uix:case> 
            </uix:switcher>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:spacer height="1" width="5" />
          </uix:cellFormat>
            <uix:styledText styleClass="OraDataText" 
                            textBinding="indexOptions@segmentBean@servletRequest"/>
        </uix:rowLayout>

<%--
        <uix:rowLayout>
          <uix:switcher childNameBinding="hasExecutionOptions@segmentBean@servletRequest">
            <uix:case name="true">
              <uix:cellFormat hAlign="right" width="100">
                <uix:messagePrompt promptBinding="EXECUTE_OPTIONS"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="1" width="5" />
              </uix:cellFormat>
                <uix:styledText styleClass="OraDataText" 
                                textBinding="executionOptions@segmentBean@servletRequest"/>
            </uix:case> 
          </uix:switcher> 
        </uix:rowLayout>
--%>
        <!-- END:INDEX OPTIONS -->

        <!-- LOGGIN -->
        <uix:rowLayout>
        </uix:rowLayout>
        <!-- END:LOGGIN -->

        <!-- EXECUTION OPTIONS-->
        <uix:rowLayout>
        </uix:rowLayout>
        <!-- END:EXECUTION OPTIONS-->

      </uix:tableLayout>
    </uix:header>
    <!-- END:OPTIONS--> 
    
    	<!-- STATS -->
    <uix:header textBinding="STATISTICS@uixDBObjectBundle@servletRequest">
      <uix:tableLayout>

        <!-- lastAnalyzed -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="LAST_ANALYZED@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="lastAnalyzed@objectBean@servletRequest" />
       </uix:rowLayout>
       
       <!-- blevel -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="BLEVEL@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:spacer height="1" width="5" />
         </uix:cellFormat>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="blevel@objectBean@servletRequest" />
       </uix:rowLayout>
       
       <!-- distinctKeys -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="DISTINCT_KEYS@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="distinctKeys@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!-- clusteringFactor-->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="CLUSTERING_FACTOR@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="clusteringFactor@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!--leafBlocks -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="LEAF_BLOCKS@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="leafBlocks@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!-- avgLeafBlocksPerKey -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="AVG_LEAF_BLOCKS_PER_KEY@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="avgLeafBlocksPerKey@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!-- avgDataBlocksPerKey-->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="AVG_DATA_BLOCKS_PER_KEY@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="avgDataBlocksPerKey@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!--numRows -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="NUM_ROWS@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="numRows@objectBean@servletRequest" />
       </uix:rowLayout>
       
        <!-- sampleSize -->
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="200">
           <uix:messagePrompt promptBinding="SAMPLE_SIZE@uixIndexBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:cellFormat> <uix:spacer height="1" width="5" /></uix:cellFormat>
         <uix:styledText styleClass="OraDataText"  textBinding="sampleSize@objectBean@servletRequest" />
       </uix:rowLayout>
       
	  </uix:tableLayout>
    </uix:header>


        <!-- END:INDEX STATS -->

    <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- View Buttons --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
            <uix:case name="false">
              <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
              <uix:ref refID="pageButtonViewInclude" />
            </uix:case>
            <uix:case name="true">
            <%-- OK Button --%>             <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
            </uix:case>
          </uix:switcher>
        </uix:pageButtonBar>
      </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




