<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.IndexConstants"%>

<uix:buildTree nodeID="viewXmlTypeIndexInclude">
    <uix:dataScope>
        <uix:tableLayout>
            <uix:stackLayout>
                <uix:header textBinding="XML_INDEX@uixIndexBundle@servletRequest">
                    <uix:contents>
                        <uix:tableLayout cellSpacing="5">

                        	<!-- Path Table -->
	                        <uix:rowLayout>
	                      	    <uix:cellFormat hAlign="right" width="50%">
									<uix:messagePrompt promptBinding="PATH_TABLE@uixIndexBundle@servletRequest"/>
								</uix:cellFormat>
			                    <uix:cellFormat>
									<uix:spacer height="1" width="5" />
	                            </uix:cellFormat>
	                            <uix:styledText styleClass="OraDataText" 
									textBinding="pathTable@segmentBean@servletRequest" />
	                        </uix:rowLayout>

    	                    <!-- Path Tablespace -->
	                        <uix:rowLayout>
								<uix:cellFormat hAlign="right" width="50%">
									<uix:messagePrompt promptBinding="PATH_TABLESPACE@uixIndexBundle@servletRequest"/>
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:spacer height="1" width="5" />
								</uix:cellFormat>
								<uix:styledText styleClass="OraDataText" 
									textBinding="pathTablespace@segmentBean@servletRequest" />
							</uix:rowLayout>

						</uix:tableLayout>

						<uix:tableLayout cellSpacing="3">
							<uix:rowLayout>
								<uix:checkBox name="pathSubsettingRequired"
									checkedBinding="pathSubsettingRequired@segmentBean@servletRequest"
									textBinding="PATH_SUB_SETTING@uixIndexBundle@servletRequest"
									disabledBinding="disabled@objectBean@servletRequest" />
							</uix:rowLayout>
						</uix:tableLayout>


						<uix:tableLayout cellSpacing="3">
							<uix:rowLayout>
								<uix:spacer width="20" />
								<uix:radioButton name="pathSubsetting"
									value="<%=IndexConstants.INCLUDE_ALL%>"
									textBinding="INCLUDE_ALL_PATHS@uixIndexBundle@servletRequest"
									selectedBinding="includeAll@segmentBean@servletRequest"
									disabledBinding="disabled@objectBean@servletRequest" />
							</uix:rowLayout>
							<uix:rowLayout>
								<uix:spacer width="20" />
								<uix:radioButton name="pathSubsetting"
									value="<%=IndexConstants.INCLUDE_BELOW%>"
									textBinding="INCLUDE_BELOW_PATHS@uixIndexBundle@servletRequest"
									selectedBinding="includeBelow@segmentBean@servletRequest"
									disabledBinding="disabled@objectBean@servletRequest" />
							</uix:rowLayout>
							<uix:rowLayout>
								<uix:spacer width="20" />
								<uix:radioButton name="pathSubsetting"
									value="<%=IndexConstants.EXCLUDE_BELOW%>"
									textBinding="EXCLUDE_BELOW_PATHS@uixIndexBundle@servletRequest"
									selectedBinding="excludeBelow@segmentBean@servletRequest"
									disabledBinding="disabled@objectBean@servletRequest" />
							</uix:rowLayout>
							<uix:rowLayout>
								<uix:spacer width="10"
									renderedBinding="pathUIDataSourceRequired@segmentBean@servletRequest" />
							</uix:rowLayout>
							<uix:rowLayout>
								<uix:spacer width="20"
									renderedBinding="pathUIDataSourceRequired@segmentBean@servletRequest" />
								<oem:table name="<%=IndexConstants.PATH_UI_DATASOURCE %>"
									beanKey="segmentBean"
									renderedBinding="pathUIDataSourceRequired@segmentBean@servletRequest"
									blockSize="5"
									destinationBinding="destination@segmentBean@servletRequest"
									formSubmitted="true"
									dataSourceProp="<%=IndexConstants.PATH_UI_DATASOURCE %>"
									width="250" summaryBinding="RESULT@dbMsgs"
									alternateTextBinding="NO_PATHS_AVAILABLE@uixIndexBundle@servletRequest">
								</oem:table>
							</uix:rowLayout>
						</uix:tableLayout>

						<uix:rowLayout>
							<uix:spacer width="3" />
							<uix:checkBox name="asynchronousIndex"
								checkedBinding="asynchronousIndex@segmentBean@servletRequest"
								textBinding="CREATE_ASYNCHRONOUS_INDEX@uixIndexBundle@servletRequest"
								disabledBinding="disabled@objectBean@servletRequest" />
						</uix:rowLayout>


						<uix:rowLayout>
							<uix:tableLayout cellSpacing="3">
								<uix:rowLayout>
									<uix:cellFormat width="20" />
									<uix:radioButton name="asynchronousIndexType"
										value="<%=IndexConstants.MANUAL%>"
										textBinding="MANUAL@uixIndexBundle@servletRequest"
										selectedBinding="asynchronousIndexManual@segmentBean@servletRequest"
										disabledBinding="disabled@objectBean@servletRequest" />
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:cellFormat width="20" />
									<uix:radioButton name="asynchronousIndexType"
										value="<%=IndexConstants.ON_COMMIT%>"
										textBinding="ON_COMMIT@uixIndexBundle@servletRequest"
										disabledBinding="disabled@objectBean@servletRequest" />
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:cellFormat width="20" />
									<uix:radioButton name="asynchronousIndexType"
										value="<%=IndexConstants.EVERY%>"
										textBinding="FREQUENCY@uixIndexBundle@servletRequest"
										selectedBinding="asynchronousIndexEvery@segmentBean@servletRequest"
										disabledBinding="disabled@objectBean@servletRequest" />
									<uix:textInput name="interval"
										textBinding="interval@segmentBean@servletRequest"
										maximumLength="2" columns="2" />
									<uix:choice name="frequency"
										shortDescBinding="FREQUENCY_TOOL_TIP@uixIndexBundle@servletRequest"
										selectedValueBinding="frequency@segmentBean@servletRequest"
										disabledBinding="disabled@objectBean@servletRequest">
										<uix:contents
											childDataBinding="frequencyOptions@segmentBean@servletRequest">
											<uix:option textBinding="text" valueBinding="value"/>
										</uix:contents>
									</uix:choice>
								</uix:rowLayout>
							</uix:tableLayout>
						</uix:rowLayout>
                    </uix:contents>
                </uix:header>
            </uix:stackLayout>
        </uix:tableLayout>
    </uix:dataScope>
</uix:buildTree>
