<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/java/dropJavaPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- START: TAB CONTENTS starts here --%>

        <uix:header textBinding="GENERAL@dbMsgs">
          <uix:subTabLayout>
            <uix:contents>
            <uix:spacer height="10"/>
              <uix:rowLayout>
                               
              <uix:contents>     
                <uix:stackLayout>            
                    <%-- SCHEMA --%>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt  labeledNodeId="SCHEMA"
                                              promptBinding="SCHEMA@dbMsgs" required="yes"/> 
                        </uix:cellFormat>
                        <uix:spacer width = "5"/>      
                        <uix:cellFormat hAlign="left">     
                          <uix:stackLayout>            
                            <uix:messageLovField name="schemaName" 
                                                 id="SCHEMA"
                                                 shortDescBinding="SCHEMA@dbMsgs"    
                                                 searchDescBinding="SCHEMA@dbMsgs"    
                                                 textBinding="schemaName@objectBean@servletRequest"    
                                                 onClick="startLov('schemaName','ListSchemaWithPubUser')"/>  
                            <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/> 
                          </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                    <uix:stackLayout>
                      <oem:table name="loadFileUIDataSource"
                                 beanKey="objectBean"
                                 destinationBinding="destination@objectBean@servletRequest"
                                 formSubmitted="true"
                                 dataSourceProp="loadFileUIDataSource" 
                                 width="100%"
                                 summaryBinding="DROPJAVA@uixJavaSourceTypeBundle@servletRequest"
                                 copyParams="target,type,cancelURL,sname,oname,otype">
                        <uix:tableSelection>
                        <oem:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                             selectedIndexBinding="selectedIndex@objectBean@servletRequest">
                          <uix:submitButton textBinding="DELETE@dbMsgs" name="event" value="deleteRowDropJava"/>
                        </oem:singleSelection>
                        </uix:tableSelection>
                        <uix:footer>
                          <uix:submitButton textBinding="ADD_ANOTHER_ROW@uixJavaSourceTypeBundle@servletRequest" name="event" value="addRowDropJava" />
                       </uix:footer>
                      </oem:table>  
                      <uix:messageText messageBinding="fileNames@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout> 
                    <uix:spacer width = "20"/>             
                </uix:stackLayout> 
                           
              </uix:contents>              
            </uix:rowLayout> 
          </uix:contents>
        </uix:subTabLayout>
        
      </uix:header>
      <uix:header textBinding="OPTIONS@dbMsgs">
      <uix:tableLayout>
        <uix:contents>
          <uix:checkBox name="dropCreatedSynonymOption" textBinding="DROPSYNONYM_OPTION@uixJavaSourceTypeBundle@servletRequest" checkedBinding="dropCreatedSynonymOption@objectBean@servletRequest"/> 
          <uix:rowLayout>
            <uix:contents> 
              <uix:checkBox name="otherOptionsLoadOption"  textBinding="OTHEROPTIONS_OPTION@uixJavaSourceTypeBundle@servletRequest"  checkedBinding="otherOptionsLoadOption@objectBean@servletRequest"/>  
                <uix:spacer width = "5"/>
                <uix:textInput name="otherOptionsLoadOptionInput"  
                               textBinding="otherOptionsLoadOptionInput@objectBean@servletRequest"
                               shortDescBinding="OTHEROPTIONS_OPTION@uixJavaSourceTypeBundle@servletRequest"/>
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
      </uix:header>



    <%-- END: TAB CONTENTS ends here --%>   
        

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
    <uix:pageButtonBar>
      <uix:submitButton textBinding="SHOWSQL@dbMsgs" name="event" value="showSql" />
      <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" unvalidated="true"/>
      <uix:submitButton textBinding="OK@dbMsgs" name="event" value="apply"/>
    </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




