<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destination="/console/database/schema/javaClass"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/java/javaclass/generalPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">
           <db:link textBinding="GENERAL@uixDBObjectBundle@servletRequest"
                    copyParams="target,type,cancelURL,sname,oname,otype"/>
           <db:link textBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest"
                    onClick="submitForm('foo', true, {event:'gotoValue2'})"
                    copyParams="target,type,cancelURL,sname,oname,otype" />
     </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

            <uix:rowLayout>
              <uix:contents>
                <uix:spacer width="30"/> 
              </uix:contents>                         
              <uix:contents>     
                <uix:stackLayout>
                                      
                  <uix:tableLayout cellSpacing="5">

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                        </uix:cellFormat>                  
                        <uix:styledText styleClass="OraDataText" textBinding="javaObjectName@objectBean@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>
                    
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>                
                        </uix:cellFormat> 
                        <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>   
                                
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="STATUS@uixDBObjectBundle@servletRequest"/>
                        </uix:cellFormat>                     
                        <uix:styledText styleClass="OraDataText" textBinding="status@objectBean@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>
				
                    <uix:rowLayout>
                      <uix:messagePrompt prompt = " "/>
                        <uix:cellFormat hAlign="right">
                          <uix:submitButton textBinding="COMPILE@uixDBObjectBundle@servletRequest" name="event" value="compile"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="errorButtonName@objectBean@servletRequest" 
                                            name="event" 
                                            value="showErrors" 
                                            disabledBinding="hasNoErrors@objectBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
			
                    <uix:rowLayout renderedBinding="showErrorsUI@objectBean@servletRequest">
                      <uix:cellFormat hAlign="right" vAlign="top">
                        <uix:messagePrompt labeledNodeId="errorsDisplay"
                                           promptBinding="ERRORS@uixDBObjectBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:textInput id="errorsDisplay"
                                     name="errorsDisplay" 
                                     textBinding="errorsDisplay@objectBean@servletRequest" 
                                     columns="60" 
                                     rows="15"
                                     readOnly="true"/>
                    </uix:rowLayout>
                                                 
                  </uix:tableLayout>
               
                </uix:stackLayout>            
              </uix:contents>              
            </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




