<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destination="/console/database/schema/javaClass"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/java/javaclass/pageView"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


    <%-- START: TAB CONTENTS starts here --%>

          <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">

            <uix:tableLayout cellSpacing="5">

              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText styleClass="OraDataText" textBinding="javaObjectName@objectBean@servletRequest"/>
              </uix:rowLayout>
              
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="STATUS@uixDBObjectBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText styleClass="OraDataText" textBinding="status@objectBean@servletRequest"/>
              </uix:rowLayout>

              <uix:switcher childNameBinding="viewShowErrors@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top">
                      <uix:messagePrompt labeledNodeId="errorsDisplay"
                                         promptBinding="ERRORS@uixDBObjectBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:textInput id="errorsDisplay"
                                   name="errorsDisplay"
                                   textBinding="errorsDisplay@objectBean@servletRequest" 
                                   columns="60" 
                                   rows="5" 
                                   readOnly="true"/>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
              
            </uix:tableLayout>
          </uix:header>

           <uix:header textBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest">
            <oem:table name="resolverUI"
                       beanKey="resolverBean" 
                       dataSourceProp="resolverUI"
                       formSubmitted="true" 
                       width="50%" 
                       summaryBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest"
                       copyParams="target,type,cancelURL,sname,oname,otype">
            </oem:table>
          </uix:header>


    <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
    <uix:ref refID="pageButtonViewInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




