<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destination="/console/database/schema/javaSource"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/java/javasource/generalPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">

       <db:link textBinding="GENERAL@uixJavaSourceTypeBundle@servletRequest"
                copyParams="target,type,cancelURL,sname,oname,otype" />
       <db:link textBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest" 
                onClick="submitForm('foo', true, {event:'gotoValue2'})"
                copyParams="target,type,cancelURL,sname,oname,otype" />

     </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

        <uix:rowLayout>
          <uix:contents>
            <uix:spacer width="30"/> 
          </uix:contents>
                                   
          <uix:contents>     
            <uix:stackLayout>                      
              <uix:tableLayout cellSpacing="5">
              
                <uix:rowLayout>
                  <uix:contents>
                  
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt labeledNodeId="javaObjectName"
                                             promptBinding="NAME@dbMsgs" 
                                             required="yes"/>
                        </uix:case>
                        <uix:case name="false">
                        <uix:messagePrompt labeledNodeId="javaObjectName"
                                           promptBinding="NAME@dbMsgs"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>                  

                    <%-- SWITCHER: name --%>
                    <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:stackLayout>
                          <uix:textInput id="javaObjectName"
                                         name="javaObjectName" 
                                         textBinding="javaObjectName@objectBean@servletRequest" 
                                         required="true"/>
                          <uix:messageText messageBinding="javaObjectName@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>
                      </uix:case>   
                      <uix:case name="false">
                        <uix:styledText styleClass="OraDataText" textBinding="javaObjectName@objectBean@servletRequest"/>
                      </uix:case>         
                    </uix:switcher>
                    <%-- SWITCHER: name --%>
                                   				 
                  </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                  <uix:contents>
                  
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt labeledNodeId="SCHEMA"
                                             promptBinding="SCHEMA@dbMsgs" required="yes"/> 
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt labeledNodeId="SCHEMA"
                                             promptBinding="SCHEMA@dbMsgs"/> 
                        </uix:case>
                        </uix:switcher>
                    </uix:cellFormat> 
                     
                     <%-- SWITCHER: schema --%>
                       <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                         <uix:case name="true">
                          <uix:stackLayout>                
                            <uix:messageLovField name="schemaName" 
                                                 id="SCHEMA"
                                                 shortDescBinding="SCHEMA@dbMsgs" 
                                                 textBinding="schemaName@objectBean@servletRequest" 
                                                 onClick="startLov('schemaName','ListSchemaWithPubUser')" 
                                                 required="true"/>  
                            <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/>
                          </uix:stackLayout>
                         </uix:case>   
                         <uix:case name="false">
                           <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                         </uix:case>         
                       </uix:switcher>
                    <%-- SWITCHER: schema --%>  
                                         
                  </uix:contents>
                 </uix:rowLayout>     
                                  
                 <%-- SWITCHER: status --%>
                 <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="false"> 
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="STATUS@dbMsgs"/>
                        </uix:cellFormat>                     
                        <uix:styledText styleClass="OraDataText" textBinding="status@objectBean@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>                     
                <%-- SWITCHER: status --%>

                <%-- SWITCHER: replace --%>
                <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">                               
                    <uix:rowLayout>
                      <uix:cellFormat/> 
                      <uix:cellFormat> 
                        <uix:checkBox name="replace" 
                                      textBinding="REPLACE_IF_EXISTS@uixJavaSourceTypeBundle@servletRequest"
                                      checkedBinding="replace@objectBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>                
                  </uix:case>
                </uix:switcher>     
                <%-- SWITCHER: replace --%>
          
                <%-- SWITCHER: noForce --%>
                <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true"> 
                    <uix:rowLayout>
                       <uix:cellFormat/> 
                       <uix:cellFormat> 
                        <uix:checkBox name="compile" 
                                      textBinding="COMPILE_AFTER_UPDATE@uixJavaSourceTypeBundle@servletRequest"
                                      checkedBinding="compile@objectBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>      
                  </uix:case>
                  <uix:case name="false">   
                    <uix:rowLayout>
                      <uix:cellFormat/> 
                      <uix:cellFormat> 
                        <uix:checkBox name="compile" 
                                      textBinding="COMPILE_AFTER_UPDATE@uixJavaSourceTypeBundle@servletRequest"
                                      checkedBinding="compile@objectBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>      
                  </uix:case>    
                </uix:switcher>     
                <%-- SWITCHER: noForce --%>

                <%-- SWITCHER: noForce:DO_NOT_CREATE option  --%>
                <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true"> 
                    <uix:rowLayout>
                       <uix:cellFormat/>
                        <uix:checkBox name="noForce" 
                                      textBinding="DO_NOT_CREATE@uixJavaSourceTypeBundle@servletRequest"
                                      checkedBinding="noForce@objectBean@servletRequest" />
                    </uix:rowLayout>      
                  </uix:case>
                </uix:switcher>     
                <%-- SWITCHER: noForce --%>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top">
                    <uix:messagePrompt labeledNodeId="sourceCode"
                                       promptBinding="SOURCE@uixJavaSourceTypeBundle@servletRequest"
                                       required="yes"/> 
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:textInput id="sourceCode"
                                   name="sourceCode" 
                                   textBinding="sourceCode@objectBean@servletRequest" 
                                   columns="60" 
                                   rows="10"/>
                    <uix:messageText messageBinding="sourceCode@errors@servletRequest" messageType="error"/>
                    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                      <uix:case name="false">
                        <uix:rowLayout hAlign="right">
                          <uix:submitButton textBinding="COMPILE@uixDBObjectBundle@servletRequest" name="event" value="compilegeneral"/>
                          <uix:spacer width="5"/>
                          <uix:switcher childNameBinding="valid@objectBean@servletRequest">
                            <uix:case name="true">
                              <uix:submitButton textBinding = "errorButtonName@objectBean@servletRequest" 
                                                name="event" 
                                                value="showErrors" 
                                                disabled="true"/>
                            </uix:case>
                            <uix:case name="false">
                              <uix:submitButton textBinding = "errorButtonName@objectBean@servletRequest" name="event" value="showErrors"/>
                            </uix:case>
                          </uix:switcher>
                        </uix:rowLayout>
                      </uix:case>
                    </uix:switcher>
                  </uix:stackLayout>
                </uix:rowLayout>
        
                <uix:switcher childNameBinding="showErrors@objectBean@servletRequest">
                  <uix:case name = "true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" vAlign="top">
                        <uix:messagePrompt labeledNodeId="errorsDisplay"
                                           promptBinding="ERRORS@uixDBObjectBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:textInput id="errorsDisplay"
                                     name="errorsDisplay"
                                     textBinding="errorsDisplay@objectBean@servletRequest" 
                                     columns="60" 
                                     rows="5"/>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
                             
              </uix:tableLayout>
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




